/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentSaveDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentUpdateDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustSearchDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.drug.SysDrugSearchVo;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugAdjustParentService;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrugAdjust/parent"})
public class SysDrugAdjustParentController {
    @Autowired
    private SysDrugAdjustParentService sysDrugAdjustParentService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @UserOptLogger(operation="\u836f\u54c1\u8c03\u4ef7\u6a21\u5757")
    @ApiOperation(value="\u836f\u54c1\u8c03\u4ef7\u76ee\u5f55-\u65b0\u589e")
    public ResponseData sysDrugAdjustParentSave(@RequestBody @Valid SysDrugAdjustParentSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugAdjustParentService.sysDrugAdjustParentSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u836f\u54c1\u8c03\u4ef7\u76ee\u5f55-\u5206\u9875\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugAdjustParentSelect(Page page, SysDrugAdjustParentDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.sysDrugAdjustParentService.sysDrugAdjustParentSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @ApiOperation(value="\u836f\u54c1\u8c03\u4ef7\u76ee\u5f55-\u66f4\u65b0")
    public ResponseData sysDrugAdjustParentUpdate(@RequestBody @Valid SysDrugAdjustParentUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugAdjustParentService.sysDrugAdjustParentUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u836f\u54c1\u8c03\u4ef7\u76ee\u5f55-\u5220\u9664")
    public ResponseData sysDrugAdjustParentDelete(@RequestBody String[] ids) {
        this.sysDrugAdjustParentService.sysDrugAdjustParentDelete(ids);
        return ResponseData.success().delete();
    }

    @GetMapping(value={"/search"})
    @ApiOperation(value="\u67e5\u8be2\u4e2d\u897f\u836f\u4ee5\u53ca\u6750\u6599\u5217\u8868")
    public ResponseData sysDrugAdjustParentSearch(Page page, SysDrugAdjustSearchDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        SysDrugSearchVo vo = this.sysDrugAdjustParentService.sysDrugAdjustParentSearch(page, dto);
        if (null != vo.getDrugVoList() && !CollectionUtils.isEmpty((Collection)vo.getDrugVoList().getRecords())) {
            return ResponseData.success((Object)vo.getDrugVoList());
        }
        if (null != vo.getMaterialVoList() && !CollectionUtils.isEmpty((Collection)vo.getMaterialVoList().getRecords())) {
            return ResponseData.success((Object)vo.getMaterialVoList());
        }
        return ResponseData.success();
    }
}

