/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.drug.SysDrugInventoryDto;
import com.byh.sys.api.dto.drug.SysDrugTogetherDto;
import com.byh.sys.api.model.drug.SysDrugPharmacyOutTempEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugBatchEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryEntity;
import com.byh.sys.api.util.EasyExcelUtil;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.vo.drug.ExportDrugInventory;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugAccessService;
import com.byh.sys.web.service.SysDrugBatchService;
import com.byh.sys.web.service.SysDrugInventoryService;
import com.byh.sys.web.service.SysDrugTogetherService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugInventory"})
public class SysDrugInventoryController {
    private static Logger logger = LoggerFactory.getLogger(SysDrugInventoryController.class);
    private final SysDrugInventoryService drugInventoryService;
    private final CommonRequest commonRequest;
    private final SysDrugBatchService drugBatchService;
    private final SysDrugAccessService sysDrugAccessService;
    private final SysDrugTogetherService drugTogetherService;

    @ApiOperation(value="\u5206\u9875", httpMethod="GET", notes="\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysDrugInventoryDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugInventoryService.pageList(page, dto));
    }

    @GetMapping(value={"/exportDrugInventory"})
    @AntiRefresh
    public void exportDrugInventory(HttpServletResponse response, Page page, SysDrugInventoryDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        List exportList = this.drugInventoryService.exportDrugInventory(dto);
        String excelName = "\u5e93\u5b58\u7ba1\u7406";
        String sheetName = "\u5e93\u5b58\u7ba1\u7406";
        EasyExcelUtil.exportExcelSheet((HttpServletResponse)response, (String)excelName, (String)sheetName, (Object)new ExportDrugInventory(), (List)exportList, null);
    }

    @PostMapping(value={"/settings"})
    @UserOptLogger(operation="\u836f\u5e93\u5e93\u5b58\u8bbe\u7f6e")
    @ApiOperation(value="settings", httpMethod="POST", notes="settings")
    public ResponseData settings(@RequestBody List<SysDrugInventoryEntity> entityList) {
        this.drugInventoryService.saveOrUpdateBatch(entityList);
        return ResponseData.success().msg("\u8bbe\u7f6e\u6210\u529f");
    }

    @GetMapping(value={"/batchDetails"})
    @ApiOperation(value="\u6279\u6b21\u8be6\u60c5", httpMethod="GET", notes="\u6279\u6b21\u8be6\u60c5")
    @AntiRefresh
    public ResponseData batchDetails(Page page, SysDrugBatchEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugBatchService.batchDetails(page, entity));
    }

    @GetMapping(value={"/access"})
    @ApiOperation(value="\u8fdb\u9500\u5b58\u8be6\u60c5", httpMethod="GET", notes="\u8fdb\u9500\u5b58\u8be6\u60c5")
    @AntiRefresh
    public ResponseData access(Page page, SysDrugAccessEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugAccessService.access(page, entity));
    }

    @GetMapping(value={"/refund"})
    @ApiOperation(value="\u8fdb\u9500\u5b58\u8be6\u60c5", httpMethod="GET", notes="\u8fdb\u9500\u5b58\u8be6\u60c5")
    @AntiRefresh
    public ResponseData refund(SysDrugPharmacyOutTempEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugAccessService.refund(entity));
    }

    @GetMapping(value={"/wholeOrder"})
    @ApiOperation(value="\u836f\u623f\u9000\u836f\u5e93 \u6574\u5355\u5c55\u793a", httpMethod="GET", notes="\u836f\u623f\u9000\u836f\u5e93 \u6574\u5355\u5c55\u793a")
    @AntiRefresh
    public ResponseData wholeOrder(Page<SysDrugPharmacyOutTempEntity> page, SysDrugPharmacyOutTempEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.sysDrugAccessService.wholeOrder(page, entity));
    }

    @ApiOperation(value="\u836f\u5e93\u6574\u5355\u51fa\u5e93\u8868\u5206\u9875", httpMethod="GET", notes="\u836f\u5e93\u6574\u5355\u51fa\u5e93\u8868\u5206\u9875")
    @GetMapping(value={"/pageTogether"})
    @AntiRefresh
    public ResponseData pageTogether(Page page, SysDrugTogetherDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.drugTogetherService.pageTogether(page, dto));
    }

    public SysDrugInventoryController(SysDrugInventoryService drugInventoryService, CommonRequest commonRequest, SysDrugBatchService drugBatchService, SysDrugAccessService sysDrugAccessService, SysDrugTogetherService drugTogetherService) {
        this.drugInventoryService = drugInventoryService;
        this.commonRequest = commonRequest;
        this.drugBatchService = drugBatchService;
        this.sysDrugAccessService = sysDrugAccessService;
        this.drugTogetherService = drugTogetherService;
    }
}

