/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.drug;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInSaveDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateShelfNumberDto;
import com.byh.sys.api.dto.drug.drugPharmacyIn.SysDrugPharmacyInUpdateStatusDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.api.util.StringUtils;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDrugPharmacyInService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysDrugPharmacy/in"})
public class SysDrugPharmacyInController {
    @Autowired
    private SysDrugPharmacyInService sysDrugPharmacyInService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u65b0\u589e")
    public ResponseData sysDrugPharmacyInSave(@RequestBody @Valid SysDrugPharmacyInSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehousingWarehouse())) {
            dto.setWarehousingWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyInService.sysDrugPharmacyInSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u67e5\u8be2")
    @AntiRefresh
    public ResponseData sysDrugPharmacyInSelect(Page page, SysDrugPharmacyInDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehousingWarehouse())) {
            dto.setWarehousingWarehouse(this.commonRequest.getDrugRoomId());
        }
        IPage list = this.sysDrugPharmacyInService.sysDrugPharmacyInSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    @UserOptLogger(operation="\u836f\u623f\u5165\u5e93\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u66f4\u65b0")
    public ResponseData sysDrugPharmacyInUpdate(@RequestBody @Valid SysDrugPharmacyInUpdateDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyInService.sysDrugPharmacyInUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/update/status"})
    @UserOptLogger(operation="\u836f\u623f\u5165\u5e93\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u66f4\u65b0\u72b6\u6001")
    public ResponseData sysDrugPharmacyInUpdateStatus(@RequestBody @Valid SysDrugPharmacyInUpdateStatusDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyInService.sysDrugPharmacyInUpdateStatus(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/update/shelfNumber"})
    @UserOptLogger(operation="\u836f\u623f\u5165\u5e93\u6a21\u5757")
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u66f4\u65b0\u836f\u54c1\u8d27\u67b6\u53f7")
    public ResponseData sysDrugPharmacyInUpdateShelfNumber(@RequestBody @Valid SysDrugPharmacyInUpdateShelfNumberDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.sysDrugPharmacyInService.sysDrugPharmacyInUpdateShelfNumber(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/confirm"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u786e\u8ba4\u5165\u5e93")
    public ResponseData sysDrugPharmacyInConfirm(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyInService.sysDrugPharmacyInConfirm(entity.getId(), this.commonRequest.getTenant());
        return ResponseData.success().msg("\u5165\u5e93\u5355\u5df2\u786e\u8ba4");
    }

    @RequestMapping(value={"/detail"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u5165\u5e93\u8be6\u60c5")
    @AntiRefresh
    public ResponseData sysDrugPharmacyInDetail(@RequestBody SysEasyEntity entity) {
        List list = this.sysDrugPharmacyInService.sysDrugPharmacyInDetail(entity.getId(), this.commonRequest.getTenant());
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u5220\u9664")
    public ResponseData sysDrugPharmacyInDelete(@RequestBody String[] ids) {
        this.sysDrugPharmacyInService.sysDrugPharmacyInDelete(ids);
        return ResponseData.success().delete();
    }

    @RequestMapping(value={"/back"})
    @ApiOperation(value="\u836f\u623f\u5165\u5e93\u8868-\u9000\u56de\u836f\u54c1")
    public ResponseData sysDrugPharmacyInBack(@RequestBody SysEasyEntity entity) {
        this.sysDrugPharmacyInService.sysDrugPharmacyInBack(entity, this.commonRequest.getTenant());
        return ResponseData.success().msg("\u836f\u54c1\u5df2\u9000\u56de");
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="GET", notes="\u5bfc\u51faExcel")
    public void sysDrugPharmacyInExport(HttpServletResponse response, Page page, SysDrugPharmacyInDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        if (StringUtils.isBlank((String)dto.getWarehousingWarehouse())) {
            dto.setWarehousingWarehouse(this.commonRequest.getDrugRoomId());
        }
        this.sysDrugPharmacyInService.sysDrugPharmacyInExport(response, page, dto);
    }
}

