/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.material;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.annotation.AntiRefresh;
import com.byh.sys.api.annotation.UserOptLogger;
import com.byh.sys.api.dto.SysMaterialDto;
import com.byh.sys.api.model.material.SysMaterialEntity;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMaterialService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/material"})
public class SysMaterialController {
    private static Logger logger = LoggerFactory.getLogger(SysMaterialController.class);
    private final CommonRequest commonRequest;
    private final SysMaterialService materialService;

    @ApiOperation(value="\u6750\u6599\u5206\u9875", httpMethod="GET", notes="\u6750\u6599\u5206\u9875")
    @GetMapping(value={"/pageList"})
    @AntiRefresh
    public ResponseData pageList(Page page, SysMaterialDto dto) {
        Integer tenantId = this.commonRequest.getTenant();
        dto.setTenantId(tenantId);
        return ResponseData.success((Object)this.materialService.pageList(page, dto));
    }

    @UserOptLogger(operation="\u6750\u6599\u76ee\u5f55\u65b0\u589e/\u7f16\u8f91")
    @PostMapping(value={"/saveUpdate"})
    @Transactional(rollbackFor={Exception.class})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539")
    public ResponseData saveUpdate(@RequestBody SysMaterialEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        this.materialService.saveUpdate(entity);
        return ResponseData.success().msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u6750\u6599\u8be6\u60c5", httpMethod="GET", notes="\u6750\u6599\u8be6\u60c5")
    @GetMapping(value={"/details"})
    @AntiRefresh
    public ResponseData details(SysMaterialEntity entity) {
        Integer tenantId = this.commonRequest.getTenant();
        entity.setTenantId(tenantId);
        return ResponseData.success((Object)this.materialService.details(entity));
    }

    @UserOptLogger(operation="\u6750\u6599\u76ee\u5f55\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/removeSysDoctor"})
    @ApiOperation(value="\u6750\u6599\u76ee\u5f55\u6279\u91cf\u5220\u9664", httpMethod="POST", notes="\u6750\u6599\u76ee\u5f55\u6279\u91cf\u5220\u9664")
    public ResponseData removeMaterial(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestBody Long[] ids) {
        return ResponseData.success((Object)this.materialService.removeMaterial(ids)).msg("\u5220\u9664\u6210\u529f");
    }

    public SysMaterialController(CommonRequest commonRequest, SysMaterialService materialService) {
        this.commonRequest = commonRequest;
        this.materialService = materialService;
    }
}

