/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.purchaseOrder;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.purchaseOrder.FlDataCallBackDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderSaveDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderUpdateDto;
import com.byh.sys.api.dto.purchaseOrder.PurchaseOrderUpdateStatusDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PurchaseOrderService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PurchaseOrderController {
    @Autowired
    private PurchaseOrderService purchaseOrderService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/purchase/order/save"})
    public ResponseData purchaseOrderSave(@RequestBody @Valid PurchaseOrderSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.purchaseOrderService.purchaseOrderSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/purchase/order/select"})
    public ResponseData purchaseOrderSelect(Page page, PurchaseOrderDto dto) {
        IPage list = this.purchaseOrderService.purchaseOrderSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/purchase/order/preIn/select"})
    public ResponseData purchaseOrderPreInSelect(Page page, PurchaseOrderDto dto) {
        IPage list = this.purchaseOrderService.purchaseOrderPreInSelect(page, dto);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/purchase/order/update"})
    public ResponseData purchaseOrderUpdate(@RequestBody @Valid PurchaseOrderUpdateDto dto) {
        this.purchaseOrderService.purchaseOrderUpdate(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/purchase/order/update/status"})
    public ResponseData purchaseOrderUpdate(@RequestBody @Valid PurchaseOrderUpdateStatusDto dto) {
        this.purchaseOrderService.purchaseOrderUpdateStatus(dto);
        return ResponseData.success().update();
    }

    @RequestMapping(value={"/purchase/order/push"})
    public ResponseData purchaseOrderPush(@RequestBody @Valid SysEasyEntity dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.purchaseOrderService.purchaseOrderPush(dto);
        return ResponseData.success();
    }

    @GetMapping(value={"/purchase/order/relation/inventory"})
    public ResponseData orderRelationInventory(Page page, SysEasyEntity entity) {
        entity.setTenantId(this.commonRequest.getTenant());
        IPage list = this.purchaseOrderService.orderRelationInventory(page, entity);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/select/pda/purchase/order"})
    public ResponseData selectPdaPurchaseOrder(Page page, FlDataCallBackDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        IPage list = this.purchaseOrderService.selectPdaPurchaseOrder(page, dto);
        return ResponseData.success((Object)list);
    }
}

