/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.mvc.controller.purchaseOrder;

import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailDto;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailSaveDto;
import com.byh.sys.api.dto.purchaseOrderDetail.PurchaseOrderDetailUpdateDto;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.PurchaseOrderDetailService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchase/order/detail"})
public class PurchaseOrderDetailController {
    @Autowired
    private PurchaseOrderDetailService purchaseOrderDetailService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/save"})
    public ResponseData purchaseOrderDetailSave(@RequestBody @Valid PurchaseOrderDetailSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.purchaseOrderDetailService.purchaseOrderDetailSave(dto);
        return ResponseData.success().save();
    }

    @GetMapping(value={"/select"})
    public ResponseData purchaseOrderDetailSelect(PurchaseOrderDetailDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        List list = this.purchaseOrderDetailService.purchaseOrderDetailSelect(dto);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/preIn"})
    public ResponseData purchaseOrderPreIn(@RequestParam(value="orderid") String orderid, @RequestParam(value="orderSelectType") String orderSelectType) {
        List list = this.purchaseOrderDetailService.purchaseOrderPreIn(orderid, this.commonRequest.getTenant(), orderSelectType);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/update"})
    public ResponseData purchaseOrderDetailUpdate(@RequestBody @Valid PurchaseOrderDetailUpdateDto dto) {
        this.purchaseOrderDetailService.purchaseOrderDetailUpdate(dto);
        return ResponseData.success().update();
    }
}

