/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.CheckRelationDto;
import com.byh.sys.api.dto.dict.SysDictDTO;
import com.byh.sys.api.dto.dict.SysDictSaveDTO;
import com.byh.sys.api.dto.dict.SysDictUpdateDTO;
import com.byh.sys.api.dto.dict.SysDictValueDTO;
import com.byh.sys.api.dto.dict.SysDictValueSaveDTO;
import com.byh.sys.api.dto.dict.SysDictValueUpdateDTO;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysDictEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.dict.SysDictEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.dict.SysDictValueVo;
import com.byh.sys.api.vo.dict.SysDictVo;
import com.byh.sys.data.repository.SysDictMapper;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysDictService;
import enums.ConstantsEnums;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDictServiceImpl
implements SysDictService {
    private final Logger logger = LoggerFactory.getLogger(SysDictServiceImpl.class);
    private final SysDictMapper sysDictMapper;
    private final SysDictValueMapper sysDictValueMapper;
    @Autowired
    private CommonRequest commonRequest;

    public void sysDictSaveOrUpdate(SysDictDTO dto) {
        SysDictEntity entity = new SysDictEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (null == dto.getId()) {
            int a = this.sysDictMapper.insert((Object)entity);
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_INSERT_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_INSERT_ERROR.getName());
        } else {
            int a = this.sysDictMapper.updateById((Object)entity);
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_UPDATE_ERROR.getName());
        }
    }

    public void sysDictSave(SysDictSaveDTO dto) {
        this.checkDictName(dto.getName(), dto.getType());
        SysDictEntity entity = new SysDictEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int a = this.sysDictMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_INSERT_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_INSERT_ERROR.getName());
    }

    public void sysDictUpdate(SysDictUpdateDTO dto) {
        SysDictEntity entity = new SysDictEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int a = this.sysDictMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_UPDATE_ERROR.getName());
    }

    public Page<SysDictVo> sysDictSelect(SysDictDTO dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysDictMapper.sysDictSelect(page, dto);
        page.setRecords(list);
        return page;
    }

    public void sysDictDeleteByIds(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException(SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getCode(), SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getName());
        }
        List list = this.sysDictMapper.checkRelation(ids, this.commonRequest.getTenant());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            StringBuilder builder = new StringBuilder();
            for (CheckRelationDto n : list) {
                builder.append("\u3010").append(n.getName()).append("\u3011\u4e3b\u5b57\u5178\u4e0b\u6709\uff1a\u3010").append(n.getCount()).append("\u3011\u4e2a\u503c;");
            }
            builder.append("\u8bf7\u5148\u5220\u9664\u5b57\u5178\u503c\uff0c\u518d\u5220\u9664\u4e3b\u5b57\u5178\u3002");
            throw new BusinessException(SysDictEnum.SYS_DICT_DELETE_ERROR.getCode(), builder.toString());
        }
    }

    public void checkDictName(String name, String type) {
        SysDictEntity sysDictEntity = (SysDictEntity)this.sysDictMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(SysDictEntity::getName, (Object)name)).or()).eq(SysDictEntity::getType, (Object)type);
        }));
        if (null != sysDictEntity) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysDictEnum.SYS_DICT_ALREADY_EXIST.getCode(), (String)SysDictEnum.SYS_DICT_ALREADY_EXIST.getName());
        }
    }

    public List<SysDictValueVo> sysDictValueSelectByType(String type) {
        SysDictValueDTO dto = new SysDictValueDTO();
        dto.setSize(-1);
        dto.setType(type);
        List voList = this.sysDictValueSelect(dto).getRecords();
        return voList;
    }

    public Page<SysDictValueVo> sysDictValueSelect(SysDictValueDTO dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysDictValueMapper.sysDictValueSelect(page, dto);
        page.setRecords(list);
        return page;
    }

    public void sysDictValueSaveOrUpdate(SysDictValueDTO dto) {
        SysDictValueEntity entity = new SysDictValueEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (null == dto.getId()) {
            int sort = this.sysDictValueMapper.selectMaxSort(dto.getType(), this.commonRequest.getTenant());
            entity.setSort(Integer.valueOf(sort + 1));
            int a = this.sysDictValueMapper.insert((Object)entity);
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_INSERT_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_INSERT_ERROR.getName());
        } else {
            int a = this.sysDictValueMapper.updateById((Object)entity);
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
        }
    }

    public void sysDictValueSave(SysDictValueSaveDTO dto) {
        this.checkDictValueName(dto.getLabel(), dto.getType(), dto.getTenantId(), dto.getValue());
        SysDictValueEntity entity = new SysDictValueEntity();
        BeanUtil.copyProperties((Object)dto, (Object)entity);
        int sort = this.sysDictValueMapper.selectMaxSort(dto.getType(), this.commonRequest.getTenant());
        int value = this.sysDictValueMapper.selectMaxValue(dto.getType(), this.commonRequest.getTenant());
        entity.setSort(Integer.valueOf(sort + 1));
        if (StrUtil.isNotBlank((CharSequence)dto.getValue())) {
            entity.setValue(dto.getValue());
        } else {
            entity.setValue(String.valueOf(value + 1));
        }
        int a = this.sysDictValueMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_INSERT_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_INSERT_ERROR.getName());
    }

    public void sysDictValueUpdate(SysDictValueUpdateDTO dto) {
        this.checkDictValue(dto.getLabel(), dto.getType(), dto.getTenantId(), dto.getValue(), dto.getId());
        SysDictValueEntity entity = new SysDictValueEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        int a = this.sysDictValueMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
    }

    public void sysDictDeleteValueByIds(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException(SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getCode(), SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getName());
        }
        int a = this.sysDictValueMapper.sysDictDeleteValueByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={Exception.class})
    public void sysDictValueMove(SysDictValueUpdateDTO dto) {
        if ("top".equals(dto.getMoveFlag())) {
            int a = this.sysDictValueMapper.updateAll(dto.getType(), dto.getTenantId());
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
            SysDictValueEntity entity = new SysDictValueEntity();
            entity.setId(dto.getId());
            entity.setSort(Integer.valueOf(this.sysDictValueMapper.selectMinSort(dto.getType(), dto.getTenantId()) - 1));
            int b = this.sysDictValueMapper.updateById((Object)entity);
            ExceptionUtils.createException((Logger)this.logger, (int)b, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
        } else {
            SysDictValueVo entry;
            List valueList = this.sysDictValueSelectByType(dto.getType());
            for (int i = 0; !(i >= valueList.size() || (entry = (SysDictValueVo)valueList.get(i)).getId().equals(dto.getId()) && i == 0); ++i) {
                if (!entry.getId().equals(dto.getId())) continue;
                int a = this.sysDictValueMapper.sysDictValueMoveUp(dto, (SysDictValueVo)valueList.get(i - 1));
                ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_UPDATE_ERROR.getName());
                break;
            }
        }
    }

    public void checkDictValueName(String label, String type, Integer tenantId, String value) {
        SysDictValueEntity entity = (SysDictValueEntity)this.sysDictValueMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getValue, (Object)value)).eq(SysDictValueEntity::getType, (Object)type)).eq(SysDictValueEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (null != entity) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysDictEnum.SYS_DICT_ALREADY_EXIST.getCode(), (String)SysDictEnum.SYS_DICT_ALREADY_EXIST.getName());
        }
    }

    public void checkDictValue(String label, String type, Integer tenantId, String value, Integer id) {
        SysDictValueEntity entity = (SysDictValueEntity)this.sysDictValueMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getValue, (Object)value)).eq(SysDictValueEntity::getType, (Object)type)).eq(SysDictValueEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue())).ne(BaseEntity::getId, (Object)id));
        if (null != entity) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysDictEnum.SYS_DICT_VALUE_ALREADY_EXIST.getCode(), (String)SysDictEnum.SYS_DICT_VALUE_ALREADY_EXIST.getName());
        }
    }

    public SysDictServiceImpl(SysDictMapper sysDictMapper, SysDictValueMapper sysDictValueMapper, CommonRequest commonRequest) {
        this.sysDictMapper = sysDictMapper;
        this.sysDictValueMapper = sysDictValueMapper;
        this.commonRequest = commonRequest;
    }
}

