/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.model.drug.SysDrugPharmacyOutTempEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugAccessEntity;
import com.byh.sys.api.model.drug.inventory.SysDrugInventoryInPrescriptionEntity;
import com.byh.sys.data.repository.SysDrugAccessMapper;
import com.byh.sys.web.service.SysDrugAccessService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysDrugAccessServiceImpl
extends ServiceImpl<SysDrugAccessMapper, SysDrugAccessEntity>
implements SysDrugAccessService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugAccessServiceImpl.class);

    public IPage<SysDrugAccessEntity> access(Page<SysDrugAccessEntity> page, SysDrugAccessEntity entity) {
        LambdaQueryWrapper qw = Wrappers.lambdaQuery();
        qw.eq(SysDrugAccessEntity::getTenantId, (Object)entity.getTenantId());
        if (StrUtil.isNotEmpty((CharSequence)entity.getStartTime()) && StrUtil.isNotEmpty((CharSequence)entity.getEndTime())) {
            entity.setStartTime(entity.getStartTime() + " 00:00:00");
            entity.setEndTime(entity.getEndTime() + " 23:59:59");
            qw.between(SysDrugAccessEntity::getWayTime, (Object)entity.getStartTime(), (Object)entity.getEndTime());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getSearch())) {
            qw.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(SysDrugAccessEntity::getWayNom, (Object)entity.getSearch())).or()).like(SysDrugAccessEntity::getBatchNumber, (Object)entity.getSearch());
            });
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getWayType())) {
            qw.eq(SysDrugAccessEntity::getWayType, (Object)entity.getWayType());
        }
        if (StrUtil.isNotEmpty((CharSequence)entity.getDrugId())) {
            qw.eq(SysDrugAccessEntity::getDrugId, (Object)entity.getDrugId());
        }
        IPage sysDrugAccessEntityIPage = ((SysDrugAccessMapper)this.baseMapper).selectPage(page, (Wrapper)qw);
        return sysDrugAccessEntityIPage;
    }

    public List<SysDrugInventoryInPrescriptionEntity> refund(SysDrugPharmacyOutTempEntity entity) {
        return ((SysDrugAccessMapper)this.baseMapper).refund(entity);
    }

    public IPage<SysDrugPharmacyOutTempEntity> wholeOrder(Page<SysDrugPharmacyOutTempEntity> page, SysDrugPharmacyOutTempEntity entity) {
        return ((SysDrugAccessMapper)this.baseMapper).wholeOrder(page, entity);
    }
}

