/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentSaveDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustParentUpdateDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustSaveDto;
import com.byh.sys.api.dto.drug.adjust.SysDrugAdjustSearchDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysDrugEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.drug.SysDrugAdjustParentEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacySimpleEntity;
import com.byh.sys.api.model.material.SysMaterialInventorySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.drug.SysDrugAdjustParentVo;
import com.byh.sys.api.vo.drug.SysDrugSearchVo;
import com.byh.sys.api.vo.drug.SysDrugVo;
import com.byh.sys.api.vo.material.SysMaterialVo;
import com.byh.sys.data.repository.SysDrugAdjustParentMapper;
import com.byh.sys.data.repository.SysDrugInventoryMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacySimpleMapper;
import com.byh.sys.data.repository.SysMaterialInventorySimpleMapper;
import com.byh.sys.data.repository.SysMaterialMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.plusSql.SysAdjustPlusSql;
import com.byh.sys.web.service.SysDrugAdjustParentService;
import com.byh.sys.web.service.SysDrugAdjustService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysDrugAdjustParentServiceImpl
implements SysDrugAdjustParentService {
    private static final Logger log = LoggerFactory.getLogger(SysDrugAdjustParentServiceImpl.class);
    @Resource
    private SysDrugAdjustParentMapper sysDrugAdjustParentMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysDrugMapper sysDrugMapper;
    @Resource
    private SysMaterialMapper sysMaterialMapper;
    @Resource
    private SysMaterialInventorySimpleMapper sysMaterialInventorySimpleMapper;
    @Resource
    private SysDrugInventoryMapper sysDrugInventoryMapper;
    @Resource
    private SysDrugPharmacySimpleMapper sysDrugPharmacySimpleMapper;
    @Resource
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysAdjustPlusSql sysAdjustPlusSql;
    @Resource
    private SysDrugAdjustService sysDrugAdjustService;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysDrugAdjustParentSave(SysDrugAdjustParentSaveDto dto) {
        BigDecimal allPlPrice = new BigDecimal(0);
        SysDrugAdjustParentEntity entity = (SysDrugAdjustParentEntity)BeanUtil.copy((Object)dto, SysDrugAdjustParentEntity.class);
        Integer userId = this.commonRequest.getUserId();
        String parentId = UUIDUtils.getRandom((int)6, (boolean)true);
        entity.setCreateUser(userId);
        entity.setId(parentId);
        entity.setCreateUser(this.commonRequest.getUserId());
        for (SysDrugAdjustSaveDto entry : dto.getList()) {
            entry.setTenantId(dto.getTenantId());
            entry.setParentId(parentId);
            entry.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            BigDecimal plPrice = entry.getNewPrice().subtract(entry.getOldPrice()).multiply(new BigDecimal(entry.getNowInventory()));
            allPlPrice = allPlPrice.add(plPrice);
            entry.setPlPrice(plPrice);
            if (DictEnums.ADJUST_SEARCH_DRUG.getCode().equals(entry.getType())) {
                this.sysDrugMapper.drugUpdateRetailPrice(entry);
                continue;
            }
            if (!DictEnums.ADJUST_SEARCH_MATERIAL.getCode().equals(entry.getType())) continue;
            this.sysMaterialMapper.materialUpdateRetailPrice(entry);
        }
        entity.setPlPrice(allPlPrice);
        int a = this.sysDrugAdjustParentMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_INSERT_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_INSERT_ERROR.getName());
        this.sysDrugAdjustService.sysDrugAdjustSaveBatch(dto.getList());
    }

    public IPage<SysDrugAdjustParentVo> sysDrugAdjustParentSelect(Page page, SysDrugAdjustParentDto dto) {
        IPage list = this.sysDrugAdjustParentMapper.sysDrugAdjustParentSelect(page, dto);
        return list;
    }

    public void sysDrugAdjustParentUpdate(SysDrugAdjustParentUpdateDto dto) {
        SysDrugAdjustParentEntity entity = (SysDrugAdjustParentEntity)BeanUtil.copy((Object)dto, SysDrugAdjustParentEntity.class);
        int a = this.sysDrugAdjustParentMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysDrugAdjustParentEntity::getId, (Object)dto.getId())).eq(SysDrugAdjustParentEntity::getTenantId, (Object)dto.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_UPDATE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_UPDATE_ERROR.getName());
    }

    public void sysDrugAdjustParentDelete(String[] ids) {
        int a = this.sysDrugAdjustParentMapper.sysDrugAdjustParentDelete(ids);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_DELETE_ERROR.getCode(), (String)SysDrugEnum.SYS_DRUG_ADJUST_PARENT_DELETE_ERROR.getName());
    }

    public SysDrugSearchVo sysDrugAdjustParentSearch(Page page, SysDrugAdjustSearchDto dto) {
        SysDrugSearchVo vo = new SysDrugSearchVo();
        if (DictEnums.ADJUST_SEARCH_DRUG.getCode().equals(dto.getType())) {
            Page sysDrugVo = this.sysAdjustPlusSql.getDrugList(page, dto);
            Object[] ids = sysDrugVo.getRecords().stream().map(SysDrugVo::getId).toArray();
            if (!ArrayUtil.isEmpty((Object[])ids)) {
                List drugInventoryEntityList = this.sysDrugPharmacySimpleMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysDrugPharmacySimpleEntity::getDrugsId, ids));
                List sysDrugPharmacyEntities = this.sysDrugPharmacyMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysDrugPharmacyEntity::getDrugsId, ids)).eq(SysDrugPharmacyEntity::getInOutType, (Object)1)).orderByDesc(SysDrugPharmacyEntity::getInOutTime));
                Map<String, List<SysDrugPharmacyEntity>> collect = sysDrugPharmacyEntities.stream().collect(Collectors.groupingBy(SysDrugPharmacyEntity::getDrugsId));
                Map<String, List<SysDrugVo>> drugMap = sysDrugVo.getRecords().stream().collect(Collectors.groupingBy(SysDrugVo::getId));
                Map<String, List<SysDrugPharmacySimpleEntity>> inventoryMap = drugInventoryEntityList.stream().collect(Collectors.groupingBy(SysDrugPharmacySimpleEntity::getDrugsId));
                for (Map.Entry<String, List<SysDrugVo>> entry : drugMap.entrySet()) {
                    List<SysDrugPharmacyEntity> items;
                    List<SysDrugPharmacySimpleEntity> li = inventoryMap.get(entry.getKey());
                    if (!CollectionUtils.isEmpty(li)) {
                        entry.getValue().get(0).setActualInventory(li.get(0).getActualInventory());
                    }
                    if (CollectionUtils.isEmpty(items = collect.get(entry.getKey()))) continue;
                    entry.getValue().get(0).setPurchasePrice(items.get(0).getPurchasePrice());
                }
            }
            vo.setDrugVoList(sysDrugVo);
        } else if (DictEnums.ADJUST_SEARCH_MATERIAL.getCode().equals(dto.getType())) {
            Page materialVo = this.sysAdjustPlusSql.getMaterialList(page, dto);
            Object[] ids = materialVo.getRecords().stream().map(SysMaterialVo::getId).toArray();
            if (!ArrayUtil.isEmpty((Object[])ids)) {
                List materialInventorySimpleEntityList = this.sysMaterialInventorySimpleMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysMaterialInventorySimpleEntity::getDrugsId, ids));
                Map<String, List<SysMaterialVo>> materialMap = materialVo.getRecords().stream().collect(Collectors.groupingBy(SysMaterialVo::getId));
                Map<String, List<SysMaterialInventorySimpleEntity>> simpleMap = materialInventorySimpleEntityList.stream().collect(Collectors.groupingBy(SysMaterialInventorySimpleEntity::getDrugsId));
                for (Map.Entry<String, List<SysMaterialVo>> entry : materialMap.entrySet()) {
                    List<SysMaterialInventorySimpleEntity> li = simpleMap.get(entry.getKey());
                    if (CollectionUtils.isEmpty(li)) continue;
                    entry.getValue().get(0).setActualInventory(li.get(0).getActualInventory());
                }
            }
            vo.setMaterialVoList(materialVo);
        }
        return vo;
    }
}

