/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.SysHisDrugCounterDto;
import com.byh.sys.api.model.SysHisDrugCounterEntity;
import com.byh.sys.api.model.dict.SysDictValueEntity;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.util.HttpUtils;
import com.byh.sys.api.util.ResponseData;
import com.byh.sys.data.repository.SysDictValueMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysHisDrugCounterMapper;
import com.byh.sys.web.service.SysHisDrugCounterService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysHisDrugCounterServiceImpl
implements SysHisDrugCounterService {
    @Autowired
    SysHisDrugCounterMapper mapper;
    @Autowired
    SysDrugMapper drugMapper;
    @Autowired
    SysDictValueMapper dictValueMapper;
    private final String drugSite = "HTTP://123.56.176.15:8886/api/Order/GetGoodsInfo";

    public ResponseData<PageInfo<SysHisDrugCounterEntity>> searchList(SysHisDrugCounterDto param) {
        PageHelper.startPage((int)param.getCurrent(), (int)param.getSize());
        List sysHisDrugCounterEntities = this.mapper.selectList((Wrapper)Wrappers.lambdaQuery().like(param.getDrugName() != null, SysHisDrugCounterEntity::getDrugName, (Object)param.getDrugName()));
        PageInfo sysHisDrugCounterEntityPageInfo = new PageInfo(sysHisDrugCounterEntities);
        return ResponseData.success((Object)sysHisDrugCounterEntityPageInfo);
    }

    public ResponseData<JSONArray> searchNanHuaList(SysHisDrugCounterDto param) {
        SysDrugEntity sysDrugEntity = (SysDrugEntity)this.drugMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(param.getDrugId() != null, SysDrugEntity::getId, (Object)param.getDrugId())).like(param.getDrugName() != null, SysDrugEntity::getDrugsName, (Object)param.getDrugName()));
        if (sysDrugEntity != null) {
            String drugUrl = "";
            String drugsName = sysDrugEntity.getDrugsName();
            Boolean appEmpty = sysDrugEntity.getApprovalNumber() == null || sysDrugEntity.getApprovalNumber().length() == 0;
            drugUrl = appEmpty != false ? "HTTP://123.56.176.15:8886/api/Order/GetGoodsInfo?gname=" + drugsName : "HTTP://123.56.176.15:8886/api/Order/GetGoodsInfo?gname=";
            String manufacturer = sysDrugEntity.getManufacturer();
            drugUrl = appEmpty != false && sysDrugEntity.getManufacturer() != null ? drugUrl + "&factoryname=" + sysDrugEntity.getManufacturer() : drugUrl + "&factoryname=";
            if (sysDrugEntity.getApprovalNumber() != null) {
                String approvalNumber = sysDrugEntity.getApprovalNumber();
                if (approvalNumber.contains("\uff1a")) {
                    approvalNumber = approvalNumber.substring(approvalNumber.indexOf("\uff1a") + 1, approvalNumber.length());
                }
                drugUrl = drugUrl + "&approvedocno=" + approvalNumber.replaceAll("\u56fd\u836f\u51c6\u5b57", "");
            } else {
                drugUrl = drugUrl + "&approvedocno=";
            }
            String defaultUsageUnit = sysDrugEntity.getDefaultUsageUnit();
            SysDictValueEntity sysDictValueEntity = (SysDictValueEntity)this.dictValueMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getValue, (Object)defaultUsageUnit)).eq(SysDictValueEntity::getType, (Object)"usage_unit"));
            String usageUnit = "";
            if (sysDictValueEntity != null) {
                usageUnit = sysDictValueEntity.getLabel();
            }
            sysDrugEntity.getDefaultUsage();
            drugUrl = drugUrl + "&goodstype=&goodsunit=";
            try {
                String s = HttpUtils.get((String)drugUrl);
                JSONObject dataMap = JSON.parseObject((String)s);
                String goodsInfo = dataMap.get("goodsInfo").toString();
                if (!goodsInfo.toString().equals("[]")) {
                    return ResponseData.success((Object)JSONObject.parseArray((String)goodsInfo));
                }
                return ResponseData.error((String)"\u6ca1\u6709\u5339\u914d\u7684\u836f\u54c1");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ResponseData.error((String)"\u53c2\u6570\u9519\u8bef");
    }

    public ResponseData<List<SysHisDrugCounterEntity>> searchOne(String[] drugIds) {
        ArrayList ids = new ArrayList();
        List sysHisDrugCounterEntities = this.mapper.selectList((Wrapper)Wrappers.lambdaQuery().in(SysHisDrugCounterEntity::getDrugId, (Object[])drugIds));
        return ResponseData.success((Object)sysHisDrugCounterEntities);
    }

    public ResponseData<SysHisDrugCounterEntity> test(SysHisDrugCounterEntity param) {
        SysDrugEntity sysDrugEntity;
        SysHisDrugCounterEntity sysHisDrugCounterEntity = (SysHisDrugCounterEntity)this.mapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysHisDrugCounterEntity::getDrugId, (Object)param.getDrugId()));
        Boolean flag = true;
        if (sysHisDrugCounterEntity == null && (sysDrugEntity = (SysDrugEntity)this.drugMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(param.getDrugId() != null, SysDrugEntity::getId, (Object)param.getDrugId())).like(param.getDrugName() != null, SysDrugEntity::getDrugsName, (Object)param.getDrugName()))) != null) {
            String drugsName = sysDrugEntity.getDrugsName();
            String drugUrl = "HTTP://123.56.176.15:8886/api/Order/GetGoodsInfo?gname=";
            String manufacturer = sysDrugEntity.getManufacturer();
            drugUrl = drugUrl + "&factoryname=";
            if (sysDrugEntity.getApprovalNumber() != null) {
                String approvalNumber = sysDrugEntity.getApprovalNumber();
                if (approvalNumber.contains("\uff1a")) {
                    approvalNumber = approvalNumber.substring(approvalNumber.indexOf("\uff1a") + 1, approvalNumber.length());
                }
                drugUrl = drugUrl + "&approvedocno=" + approvalNumber.replaceAll("\u56fd\u836f\u51c6\u5b57", "");
            } else {
                drugUrl = drugUrl + "&approvedocno=";
            }
            String defaultUsageUnit = sysDrugEntity.getDefaultUsageUnit();
            SysDictValueEntity sysDictValueEntity = (SysDictValueEntity)this.dictValueMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysDictValueEntity::getValue, (Object)defaultUsageUnit)).eq(SysDictValueEntity::getType, (Object)"usage_unit"));
            String usageUnit = "";
            if (sysDictValueEntity != null) {
                usageUnit = sysDictValueEntity.getLabel();
            }
            if (sysDrugEntity.getDefaultUsage() != null) {
                String defaultUsage = sysDrugEntity.getDefaultUsage();
                drugUrl = drugUrl + "&goodstype=" + defaultUsage + usageUnit + "&goodsunit=";
            } else {
                drugUrl = drugUrl + "&goodstype=&goodsunit=";
            }
            try {
                String s = HttpUtils.get((String)drugUrl);
                JSONObject dataMap = JSON.parseObject((String)s);
                String goodsInfo = dataMap.get("goodsInfo").toString();
                flag = !goodsInfo.toString().equals("[]");
                if (flag.booleanValue()) {
                    for (Object o : JSONObject.parseArray((String)goodsInfo)) {
                        JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
                        String goodstype = jsonObject.get((Object)"goodstype").toString();
                        if (!goodstype.contains("*" + sysDrugEntity.getPackSpecification() + sysDrugEntity.getPackSmallUnitsLabel()) && !goodstype.contains(":" + sysDrugEntity.getPackSpecification() + sysDrugEntity.getPackSmallUnitsLabel()) && !goodstype.contains("\u00d7" + sysDrugEntity.getPackSpecification() + sysDrugEntity.getPackSmallUnitsLabel()) && !goodstype.contains("/" + sysDrugEntity.getPackSpecification() + sysDrugEntity.getPackSmallUnitsLabel()) && !goodstype.contains(sysDrugEntity.getPackSpecification() + "%")) continue;
                        param.setHisId(jsonObject.get((Object)"goodsid").toString());
                        param.setDrugName(sysDrugEntity.getDrugsName());
                        int insert = this.mapper.insert((Object)param);
                        if (insert <= 0) continue;
                        sysHisDrugCounterEntity = (SysHisDrugCounterEntity)this.mapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysHisDrugCounterEntity::getDrugId, (Object)param.getDrugId()));
                        return ResponseData.success((Object)sysHisDrugCounterEntity);
                    }
                }
                System.out.println(goodsInfo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (flag.booleanValue()) {
            return ResponseData.success((Object)sysHisDrugCounterEntity);
        }
        return ResponseData.error((String)"\u6ca1\u6709\u5339\u914d\u7684\u836f\u54c1");
    }

    public ResponseData saveNanhua() throws IOException {
        String s = HttpUtils.get((String)"http://123.56.176.15:8886/api/Order/GetGoodsInfo?gname=&factoryname=&approvedocno=&goodstype=&goodsunit=");
        JSONObject dataMap = JSON.parseObject((String)s);
        String goodsInfo = dataMap.get("goodsInfo").toString();
        ArrayList params = new ArrayList();
        for (Object o : JSONObject.parseArray((String)goodsInfo)) {
            HashMap<String, String> param = new HashMap<String, String>();
            JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
            String goodsid = jsonObject.getString("goodsid");
            String goodsname = jsonObject.getString("goodsname");
            String currencyname = jsonObject.getString("currencyname");
            String goodstype = jsonObject.getString("goodstype");
            String goodsunit = jsonObject.getString("goodsunit");
            String factoryname = jsonObject.getString("factoryname");
            String approvedocno = jsonObject.getString("approvedocno");
            param.put("goodsid", goodsid);
            param.put("goodsname", goodsname);
            param.put("currencyname", currencyname);
            param.put("goodstype", goodstype);
            param.put("goodsunit", goodsunit);
            param.put("factoryname", factoryname);
            param.put("approvedocno", approvedocno);
            params.add(param);
        }
        this.mapper.addNanhuaDrug(params);
        return ResponseData.success();
    }

    public ResponseData add(SysHisDrugCounterEntity param) {
        this.mapper.insert((Object)param);
        return ResponseData.success();
    }

    public ResponseData update(SysHisDrugCounterEntity param) {
        this.mapper.updateById((Object)param);
        return ResponseData.success();
    }
}

