/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.sys.api.dto.SysEasyEntity;
import com.byh.sys.api.dto.drug.drugPharmacy.SysDrugPharmacySaveDto;
import com.byh.sys.api.model.drug.SysDrugEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyEntity;
import com.byh.sys.api.model.drug.pharmacy.SysDrugPharmacyOutEntity;
import com.byh.sys.api.model.hsUpload.HsUploadBak;
import com.byh.sys.api.model.shelf.SysDrugNumberRelationEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.data.repository.HsUploadLogMapper;
import com.byh.sys.data.repository.SysDrugMapper;
import com.byh.sys.data.repository.SysDrugNumberRelationMapper;
import com.byh.sys.data.repository.SysDrugPharmacyMapper;
import com.byh.sys.data.repository.SysDrugPharmacyOutMapper;
import com.byh.sys.web.call_function.HsUploadExtend;
import com.byh.sys.web.service.SysHsUploadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysHsUploadServiceImpl
implements SysHsUploadService {
    private static final Logger log = LoggerFactory.getLogger(SysHsUploadServiceImpl.class);
    @Autowired
    private HsUploadExtend hsUploadExtend;
    @Autowired
    private SysDrugPharmacyOutMapper sysDrugPharmacyOutMapper;
    @Autowired
    private SysDrugPharmacyMapper sysDrugPharmacyMapper;
    @Autowired
    private SysDrugNumberRelationMapper sysDrugNumberRelationMapper;
    @Autowired
    private SysDrugMapper sysDrugMapper;
    @Autowired
    private HsUploadLogMapper hsUploadLogMapper;

    public void goodSale(SysEasyEntity entity) {
        JSONObject drugTracCodg = entity.getDrugTracCodg();
        for (Map.Entry entry : drugTracCodg.entrySet()) {
            SysDrugEntity sysDrugEntity = (SysDrugEntity)this.sysDrugMapper.selectById((Serializable)entry.getKey());
            ExceptionUtils.createException((Logger)log, (null == sysDrugEntity ? 1 : 0) != 0, (String)("\u836f\u54c1id\uff1a" + (String)entry.getKey() + "\u6ca1\u6709\u5339\u914d\u836f\u54c1"));
            SysDrugNumberRelationEntity relationEntity = (SysDrugNumberRelationEntity)this.sysDrugNumberRelationMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugNumberRelationEntity::getThirdCode, (Object)sysDrugEntity.getThirdCode()));
            if (Objects.isNull(relationEntity)) continue;
            String[] split = entry.getValue().toString().split(",");
            StringBuilder builder = new StringBuilder(30);
            for (String s : split) {
                for (int i = 0; i < relationEntity.getNumber(); ++i) {
                    builder.append(s).append(",");
                }
            }
            String substring = builder.substring(0, builder.length() - 1);
            drugTracCodg.put((String)entry.getKey(), (Object)substring);
        }
        SysDrugPharmacyOutEntity sysDrugPharmacyOutEntity = (SysDrugPharmacyOutEntity)this.sysDrugPharmacyOutMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyOutEntity::getPrescriptionId, (Object)entity.getId()));
        ExceptionUtils.createException((Logger)log, (boolean)Objects.isNull(sysDrugPharmacyOutEntity), (String)("\u672a\u67e5\u8be2\u5230\u51fa\u5e93\u5355\uff1a" + entity.getId() + "\uff1b\u7684\u6570\u636e"));
        List list = this.sysDrugPharmacyMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(SysDrugPharmacyEntity::getInventoryId, (Object)sysDrugPharmacyOutEntity.getId()));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)"500", (String)"\u5f53\u524d\u5904\u65b9\u672a\u53d1\u836f\u3002");
        List saveDtoList = BeanUtil.copyList((List)list, SysDrugPharmacySaveDto.class);
        entity.getDrugTracCodg().put("createId", (Object)entity.getCreateId());
        entity.getDrugTracCodg().put("createName", (Object)entity.getCreateName());
        entity.getDrugTracCodg().put("type", (Object)"2");
        ArrayList<HsUploadBak> hsUploadBaks = new ArrayList<HsUploadBak>();
        List baks = this.hsUploadLogMapper.selectHsUploadBak(entity.getId());
        String patientName = this.hsUploadLogMapper.getPatientName(entity.getId());
        if (CollectionUtils.isEmpty((Collection)baks)) {
            for (SysDrugPharmacyEntity entry : list) {
                HsUploadBak hsUploadBak = new HsUploadBak();
                hsUploadBak.setPrescriptionId(entry.getPrescriptionId());
                hsUploadBak.setParam(JSONObject.toJSONString((Object)entry));
                hsUploadBak.setDrugTracCodg(JSONObject.toJSONString((Object)entity.getDrugTracCodg()));
                hsUploadBaks.add(hsUploadBak);
                hsUploadBak.setPatientName(patientName);
            }
            int a = this.hsUploadLogMapper.saveHsUploadBakBatch(hsUploadBaks);
            ExceptionUtils.createException((Logger)log, (int)a, (String)"\u6dfb\u52a0\u5907\u4efd\u6570\u636e\u5931\u8d25");
        }
        this.hsUploadExtend.context(saveDtoList, entity.getDrugTracCodg());
    }

    public void goodSaleAgain(SysEasyEntity entity) {
        List hsUploadBaks = this.hsUploadLogMapper.selectHsUploadBak(entity.getId());
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)hsUploadBaks), (String)("\u5904\u65b9\u53f7\uff1a" + entity.getId() + "\uff1b\u672a\u67e5\u8be2\u5230\u660e\u7ec6"));
        ArrayList<Object> saveDtoList = new ArrayList<Object>();
        for (HsUploadBak entry : hsUploadBaks) {
            saveDtoList.add(JSONObject.parseObject((String)entry.getParam(), SysDrugPharmacySaveDto.class));
        }
        entity.setDrugTracCodg(JSONObject.parseObject((String)((HsUploadBak)hsUploadBaks.get(0)).getDrugTracCodg()));
        this.hsUploadExtend.context(saveDtoList, entity.getDrugTracCodg());
    }
}

