/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.invoice.SysInvoiceDto;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.invoice.SysInvoiceEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.invoice.SysInvoiceVo;
import com.byh.sys.data.repository.SysInvoiceMapper;
import com.byh.sys.web.mvc.utils.nuonuo.NuoNuoClientUtils;
import com.byh.sys.web.service.SysInvoiceService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysInvoiceServiceImpl
extends ServiceImpl<SysInvoiceMapper, SysInvoiceEntity>
implements SysInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(SysInvoiceServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(SysInvoiceServiceImpl.class);
    @Resource
    private SysInvoiceMapper sysInvoiceMapper;

    public Page<SysInvoiceVo> selectPageList(SysInvoiceDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysInvoiceMapper.selectPageList(page, dto);
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void getInvoiceInfoAndUpdate(SysInvoiceDto dto) {
        String result;
        JSONObject jsonObject;
        String code;
        if (dto.getId() == null || StrUtil.isEmpty((CharSequence)dto.getId().toString())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u7cfb\u7edf\u53d1\u7968\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isEmpty((CharSequence)dto.getSerialNo())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u83b7\u53d6\u53d1\u7968\u8be6\u60c5\u65f6\uff0c\u84dd\u8272\u53d1\u7968\u6d41\u6c34\u53f7\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if ("E0000".equals(code = (jsonObject = JSONObject.parseObject((String)(result = this.getInvoiceInfo(new String[]{dto.getSerialNo()})))).getString("code"))) {
            JSONArray jsonArray = JSONArray.parseArray((String)jsonObject.getString("result"));
            JSONObject resultJson = (JSONObject)jsonArray.get(0);
            dto.setOfdUrl(resultJson.getString("ofdUrl"));
            dto.setImgUrls(resultJson.getString("imgUrls"));
            dto.setPdfUrl(resultJson.getString("pdfUrl"));
            SysInvoiceEntity invoiceEntity = new SysInvoiceEntity();
            BeanUtils.copyProperties((Object)dto, (Object)invoiceEntity);
            ((SysInvoiceMapper)this.baseMapper).updateById((Object)invoiceEntity);
        } else {
            String errorMsg = jsonObject.getString("describe");
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)code, (String)errorMsg);
        }
    }

    private String getInvoiceInfo(String[] serialNos) {
        String isOfferInvoiceDetail = "1";
        String[] orderNos = new String[]{"-"};
        String result = NuoNuoClientUtils.queryInvoiceResultPro((String)isOfferInvoiceDetail, (String[])orderNos, (String[])serialNos);
        return result;
    }

    public void batchUpdate(Integer tenantId) {
        List list = ((SysInvoiceMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysInvoiceEntity.class).eq(SysInvoiceEntity::getTenantId, (Object)tenantId)).eq(SysInvoiceEntity::getImgUrls, (Object)"")).eq(SysInvoiceEntity::getOfdUrl, (Object)"")).eq(SysInvoiceEntity::getPdfUrl, (Object)""));
        Map map = list.stream().collect(Collectors.toMap(SysInvoiceEntity::getSerialNo, Function.identity()));
        List serialNoList = list.stream().map(SysInvoiceEntity::getSerialNo).collect(Collectors.toList());
        List<List> splitLists = IntStream.range(0, serialNoList.size()).filter(i -> i % 50 == 0).mapToObj(i -> serialNoList.subList(i, Math.min(i + 50, serialNoList.size()))).collect(Collectors.toList());
        splitLists.forEach(split -> {
            String[] serialNos = split.toArray(new String[0]);
            String result = this.getInvoiceInfo(serialNos);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            String code = jsonObject.getString("code");
            if ("E0000".equals(code)) {
                String resultJson = jsonObject.getString("result");
                JSONArray jsonArray = JSON.parseArray((String)resultJson);
                jsonArray.forEach(json -> {
                    String serilNo;
                    SysInvoiceEntity entity;
                    JSONObject object = (JSONObject)json;
                    if (object != null && (entity = (SysInvoiceEntity)map.get(serilNo = object.getString("serialNo"))) != null) {
                        entity.setOfdUrl(object.getString("ofdUrl"));
                        entity.setImgUrls(object.getString("imgUrls"));
                        entity.setPdfUrl(object.getString("pdfUrl"));
                        ((SysInvoiceMapper)this.baseMapper).updateById((Object)entity);
                    }
                });
            }
        });
        System.out.println();
    }

    public SysInvoiceEntity selectInvoiceByserialNo(String serialNo) {
        return ((SysInvoiceMapper)this.baseMapper).selectInvoiceByserialNo(serialNo);
    }
}

