/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.material.inventoryCheck.SysMaterialInventoryCheckDto;
import com.byh.sys.api.dto.material.inventoryCheck.SysMaterialInventoryCheckSaveDto;
import com.byh.sys.api.dto.material.inventoryCheck.SysMaterialInventoryCheckUpdateDto;
import com.byh.sys.api.dto.material.inventoryCheck.SysMaterialInventoryCheckUpdateStatusDto;
import com.byh.sys.api.dto.material.inventoryCheckPrescrip.SysMaterialInventoryCheckPrescriptionSaveDto;
import com.byh.sys.api.dto.material.inventoryCheckPrescrip.SysMaterialInventoryCheckPrescriptionUpdateDto;
import com.byh.sys.api.enums.DictEnums;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysUserEntity;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryCheckEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryCheckPrescriptionEntity;
import com.byh.sys.api.model.material.SysMaterialInventorySimpleEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.material.SysMaterialInventoryCheckVo;
import com.byh.sys.api.vo.material.SysMaterialInventoryVo;
import com.byh.sys.data.repository.SysMaterialInventoryCheckMapper;
import com.byh.sys.data.repository.SysMaterialInventoryCheckPrescriptionMapper;
import com.byh.sys.data.repository.SysMaterialInventoryMapper;
import com.byh.sys.data.repository.SysMaterialInventorySimpleMapper;
import com.byh.sys.web.mvc.utils.CommonRequest;
import com.byh.sys.web.service.SysMaterialInventoryCheckPrescriptionService;
import com.byh.sys.web.service.SysMaterialInventoryCheckService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMaterialInventoryCheckServiceImpl
implements SysMaterialInventoryCheckService {
    private static final Logger log = LoggerFactory.getLogger(SysMaterialInventoryCheckServiceImpl.class);
    @Resource
    private SysMaterialInventoryCheckMapper sysMaterialInventoryCheckMapper;
    @Resource
    private SysMaterialInventoryCheckPrescriptionMapper sysMaterialInventoryCheckPrescriptionMapper;
    @Autowired
    private SysMaterialInventoryCheckPrescriptionService sysMaterialInventoryCheckPrescriptionService;
    @Resource
    private SysMaterialInventorySimpleMapper sysMaterialInventorySimpleMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private SysMaterialInventoryMapper sysMaterialInventoryMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public SysMaterialInventoryCheckEntity sysMaterialInventoryCheckSave(SysMaterialInventoryCheckSaveDto dto) {
        this.sysMaterialInventoryCheckStatus();
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        String checkId = UUIDUtils.getRandom((int)6, (boolean)true);
        SysMaterialInventoryCheckEntity entity = (SysMaterialInventoryCheckEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryCheckEntity.class);
        entity.setAuditUse(DictEnums.CHECK_READY.getCode());
        entity.setId(checkId);
        entity.setCheckUse(this.commonRequest.getUserId().toString());
        entity.setCheckNumber(Integer.valueOf(dto.getPrescripList().size()));
        entity.setAuditStatus(DictEnums.CHECK_READY.getCode());
        List prescripList = dto.getPrescripList();
        for (SysMaterialInventoryCheckPrescriptionSaveDto n : prescripList) {
            n.setTenantId(dto.getTenantId());
            n.setMaterialInventoryCheckId(checkId);
            n.setId(UUIDUtils.getRandom((int)6, (boolean)true));
            n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
            n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
            rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
            n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
            rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
        }
        entity.setPurchasePricePl(rootPurchasePricePl);
        entity.setRetailPricePl(rootRetailPricePl);
        int a = this.sysMaterialInventoryCheckMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_INSERT_ERROR.getName());
        this.sysMaterialInventoryCheckPrescriptionMapper.sysMaterialInventoryCheckPrescriptionSaveBatch(prescripList);
        entity.setPrescripList(prescripList);
        return entity;
    }

    public IPage<SysMaterialInventoryCheckVo> sysMaterialInventoryCheckSelect(Page page, SysMaterialInventoryCheckDto dto) {
        return this.sysMaterialInventoryCheckMapper.sysMaterialInventoryCheckSelect(page, dto);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryCheckUpdate(SysMaterialInventoryCheckUpdateDto dto) {
        BigDecimal rootPurchasePricePl = new BigDecimal(0);
        BigDecimal rootRetailPricePl = new BigDecimal(0);
        SysMaterialInventoryCheckEntity entity = (SysMaterialInventoryCheckEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryCheckEntity.class);
        List list = dto.getPrescripList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysMaterialInventoryCheckPrescriptionUpdateDto n : list) {
                n.setPlNumber(Integer.valueOf(n.getRealityInventory() - n.getBookInventory()));
                n.setPurchasePricePl(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
                rootPurchasePricePl = rootPurchasePricePl.add(n.getPurchasePricePl());
                n.setRetailPricePl(new BigDecimal(n.getPlNumber()).multiply(n.getRetailPrice()));
                rootRetailPricePl = rootRetailPricePl.add(n.getRetailPricePl());
            }
            entity.setPurchasePricePl(rootPurchasePricePl);
            entity.setRetailPricePl(rootRetailPricePl);
            entity.setCheckNumber(Integer.valueOf(list.size()));
            for (SysMaterialInventoryCheckPrescriptionUpdateDto n : list) {
                n.setTenantId(dto.getTenantId());
                this.sysMaterialInventoryCheckPrescriptionService.sysMaterialInventoryCheckPrescriptionUpdate(n);
            }
        }
        int a = this.sysMaterialInventoryCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryCheckEntity::getTenantId, (Object)dto.getTenantId())).eq(SysMaterialInventoryCheckEntity::getId, (Object)dto.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getName());
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMaterialInventoryCheckDelete(String id) {
        List list = this.sysMaterialInventoryCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryCheckPrescriptionEntity::getMaterialInventoryCheckId, (Object)id)).eq(SysMaterialInventoryCheckPrescriptionEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ExceptionUtils.createException((Logger)log, (boolean)CollectionUtils.isEmpty((Collection)list), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_PRESCRIPTION_SELECT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_PRESCRIPTION_SELECT_ERROR.getName());
        List ids = list.stream().map(SysMaterialInventoryCheckPrescriptionEntity::getId).collect(Collectors.toList());
        this.sysMaterialInventoryCheckPrescriptionMapper.deleteBatchIds(ids);
        int a = this.sysMaterialInventoryCheckMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryCheckEntity::getId, (Object)id)).eq(SysMaterialInventoryCheckEntity::getTenantId, (Object)this.commonRequest.getTenant()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_DELETE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_DELETE_ERROR.getName());
    }

    public SysMaterialInventoryCheckEntity sysMaterialInventoryCheckUpdateStatus(SysMaterialInventoryCheckUpdateStatusDto dto) {
        ExceptionUtils.createException((Logger)log, (boolean)DictEnums.CHECK_ALREADY_CONFIRM.equals((Object)dto.getAuditStatus()), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getName());
        SysMaterialInventoryCheckEntity entity = (SysMaterialInventoryCheckEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryCheckEntity.class);
        SysUserEntity userInfo = this.commonRequest.getUserInfo();
        if (null != userInfo) {
            entity.setAuditUse(userInfo.getUserName());
        }
        entity.setCheckTime(new Date());
        int a = this.sysMaterialInventoryCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryCheckEntity::getId, (Object)entity.getId())).eq(SysMaterialInventoryCheckEntity::getTenantId, (Object)entity.getTenantId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getName());
        return entity;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public SysMaterialInventoryCheckEntity sysMaterialInventoryCheckConfirm(String id, Integer tenantId) {
        SysMaterialInventoryCheckEntity entity = new SysMaterialInventoryCheckEntity();
        entity.setAuditStatus(DictEnums.CHECK_ALREADY_CONFIRM.getCode());
        int a = this.sysMaterialInventoryCheckMapper.update((Object)entity, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventoryCheckEntity::getTenantId, (Object)tenantId)).eq(SysMaterialInventoryCheckEntity::getId, (Object)id));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_UPDATE_ERROR.getName());
        List list = this.sysMaterialInventoryCheckPrescriptionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryCheckPrescriptionEntity::getTenantId, (Object)tenantId)).eq(SysMaterialInventoryCheckPrescriptionEntity::getMaterialInventoryCheckId, (Object)id));
        for (SysMaterialInventoryCheckPrescriptionEntity n : list) {
            if (n.getPlNumber() == 0) continue;
            SysMaterialInventorySimpleEntity simple = (SysMaterialInventorySimpleEntity)this.sysMaterialInventorySimpleMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)tenantId)).eq(SysMaterialInventorySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            if (null == simple) {
                ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_SIMPLE_SELECT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_SIMPLE_SELECT_ERROR.getName());
            }
            simple.setActualInventory(Integer.valueOf(simple.getActualInventory() + n.getPlNumber()));
            simple.setPurchaseAmount(simple.getPurchaseAmount().add(new BigDecimal(n.getRealityInventory()).multiply(n.getPurchasePrice())));
            int b = this.sysMaterialInventorySimpleMapper.update((Object)simple, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(SysMaterialInventorySimpleEntity::getTenantId, (Object)tenantId)).eq(SysMaterialInventorySimpleEntity::getDrugsId, (Object)n.getDrugsId()));
            ExceptionUtils.createException((Logger)log, (int)b, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_UPDATE_ERROR.getName());
            ArrayList saveDtoList = new ArrayList();
            this.insertMaterialInventory(n, saveDtoList);
            this.sysMaterialInventoryMapper.sysMaterialInventorySaveBatch(saveDtoList);
        }
        return entity;
    }

    private void insertMaterialInventory(SysMaterialInventoryCheckPrescriptionEntity n, List<SysMaterialInventorySaveDto> saveDtoList) {
        SysMaterialInventorySaveDto saveDto = (SysMaterialInventorySaveDto)BeanUtil.copy((Object)n, SysMaterialInventorySaveDto.class);
        saveDto.setBatchNumber(n.getBatchNumber());
        saveDto.setId(UUIDUtils.getRandom((int)5, (boolean)true));
        saveDto.setInventoryId(n.getId());
        saveDto.setActualInventory(n.getPlNumber());
        saveDto.setPurchaseAmount(new BigDecimal(n.getPlNumber()).multiply(n.getPurchasePrice()));
        saveDto.setInOutType(DictEnums.IN_OUT_TYPE_CHECK.getCode());
        saveDtoList.add(saveDto);
    }

    public IPage<SysMaterialInventoryVo> sysMaterialInventoryCheckSearch(Page page, SysMaterialInventoryCheckDto dto) {
        IPage list = this.sysMaterialInventoryCheckMapper.sysMaterialInventoryCheckSearch(page, dto);
        return list;
    }

    public void sysMaterialInventoryCheckStatus() {
        List list = this.sysMaterialInventoryCheckMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryCheckEntity::getAuditStatus, (Object)DictEnums.CHECK_ING.getCode())).eq(SysMaterialInventoryCheckEntity::getTenantId, (Object)this.commonRequest.getTenant())).eq(NoIdBaseEntity::getDelFlag, (Object)"0"));
        ExceptionUtils.createException((Logger)log, (!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_ING_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INVENTORY_CHECK_ING_ERROR.getName());
    }
}

