/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventoryDto;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventorySaveDto;
import com.byh.sys.api.dto.material.inventory.SysMaterialInventoryUpdateDto;
import com.byh.sys.api.enums.SysMaterialInventoryEnum;
import com.byh.sys.api.model.base.NoIdBaseEntity;
import com.byh.sys.api.model.material.SysMaterialInventoryEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.material.SysMaterialInventoryVo;
import com.byh.sys.data.repository.SysMaterialInventoryMapper;
import com.byh.sys.web.service.SysMaterialInventoryService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysMaterialInventoryServiceImpl
implements SysMaterialInventoryService {
    private static final Logger log = LoggerFactory.getLogger(SysMaterialInventoryServiceImpl.class);
    @Resource
    private SysMaterialInventoryMapper sysMaterialInventoryMapper;

    public void sysMaterialInventorySave(SysMaterialInventorySaveDto dto) {
        SysMaterialInventoryEntity entity = (SysMaterialInventoryEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryEntity.class);
        int a = this.sysMaterialInventoryMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getName());
    }

    public void sysMaterialInventorySaveBatch(List<SysMaterialInventorySaveDto> list) {
        int a = this.sysMaterialInventoryMapper.sysMaterialInventorySaveBatch(list);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getName());
    }

    public List<SysMaterialInventoryVo> sysMaterialInventorySelectByInventoryId(SysMaterialInventoryDto dto) {
        Page page = new Page(1L, -1L);
        IPage vo = this.sysMaterialInventoryMapper.sysMaterialInventorySelectNormal(page, dto);
        return vo.getRecords();
    }

    public IPage<SysMaterialInventoryVo> sysMaterialInventorySelect(Page page, SysMaterialInventoryDto dto) {
        IPage list = this.sysMaterialInventoryMapper.sysMaterialInventorySelect(page, dto);
        return list;
    }

    public void sysMaterialInventoryUpdate(SysMaterialInventoryUpdateDto dto) {
        SysMaterialInventoryEntity entity = (SysMaterialInventoryEntity)BeanUtil.copy((Object)dto, SysMaterialInventoryEntity.class);
        int a = this.sysMaterialInventoryMapper.sysMaterialInventoryUpdate(entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getCode(), (String)SysMaterialInventoryEnum.SYS_MATERIAL_INSERT_ERROR.getName());
    }

    public void sysMaterialInventoryDelete(SysMaterialInventoryEntity entity) {
        int a = this.sysMaterialInventoryMapper.sysMaterialInventoryDelete(entity);
    }

    public void sysMaterialInventoryDeleteByInventoryId(String inventoryId) {
        int a = this.sysMaterialInventoryMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysMaterialInventoryEntity::getInventoryId, (Object)inventoryId));
        ExceptionUtils.createException((Logger)log, (int)a, (String)"500", (String)("\u3010\u51fa\u5e93\u5355\uff1a" + inventoryId + "\u3011\u5220\u9664sys_material_inventory\u51fa\u73b0\u5f02\u5e38"));
    }

    public void sysMaterialInventoryInOutDetail(Integer id, Integer tenantId) {
        List list = this.sysMaterialInventoryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(NoIdBaseEntity::getDelFlag, (Object)"0")).eq(SysMaterialInventoryEntity::getTenantId, (Object)tenantId)).eq(SysMaterialInventoryEntity::getDrugsId, (Object)id));
    }

    public void sysMaterialInventoryBatchDetail(Integer id, Integer tenantId) {
    }
}

