/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.menurole.SysMenuRoleDTO;
import com.byh.sys.api.dto.menurole.SysMenuRoleUpdateDTO;
import com.byh.sys.api.enums.SysMenuRoleEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysMenuRoleEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.data.repository.SysMenuRoleMapper;
import com.byh.sys.data.repository.SysUserRoleMapper;
import com.byh.sys.web.service.SysMenuRoleService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysMenuRoleServiceImpl
extends ServiceImpl<SysMenuRoleMapper, SysMenuRoleEntity>
implements SysMenuRoleService {
    Logger logger = LoggerFactory.getLogger(SysMenuRoleServiceImpl.class);
    @Resource
    private SysMenuRoleMapper sysMenuRoleMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void sysMenuRoleSave(SysMenuRoleDTO dto) {
        int delete = this.sysMenuRoleMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SysMenuRoleEntity::getRoleId, (Object)dto.getRoleId()));
        if (!CollectionUtils.isEmpty((Collection)dto.getList())) {
            int a = this.sysMenuRoleMapper.insertQuery(dto.getList());
            ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysMenuRoleEnum.SYS_MENU_ROLE_INSERT_ERROR.getCode(), (String)SysMenuRoleEnum.SYS_MENU_ROLE_INSERT_ERROR.getName());
        } else {
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysMenuRoleEnum.SYS_MENU_ROLE_NAME_NO_CHILDS.getCode(), (String)SysMenuRoleEnum.SYS_MENU_ROLE_NAME_NO_CHILDS.getName());
        }
    }

    public List<SysMenuRoleEntity> sysMenuRoleSelect(SysMenuRoleDTO dto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (null != dto.getMenuId()) {
            wrapper.eq((Object)"menu_id", (Object)dto.getMenuId());
        }
        if (null != dto.getRoleId()) {
            wrapper.eq((Object)"role_id", (Object)dto.getRoleId());
        }
        List list = this.sysMenuRoleMapper.selectList((Wrapper)wrapper);
        return list;
    }

    public void sysMenuRoleUpdate(List<SysMenuRoleUpdateDTO> dto) {
        SysMenuRoleEntity entity = new SysMenuRoleEntity();
        BeanUtils.copyProperties(dto, (Object)entity);
        int a = this.sysMenuRoleMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysMenuRoleEnum.SYS_MENU_ROLE_UPDATE_ERROR.getCode(), (String)SysMenuRoleEnum.SYS_MENU_ROLE_UPDATE_ERROR.getName());
    }
}

