/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.organ.SysOrganDTO;
import com.byh.sys.api.dto.organ.SysOrganSaveDTO;
import com.byh.sys.api.dto.organ.SysOrganUpdateDTO;
import com.byh.sys.api.enums.SysCommonEnum;
import com.byh.sys.api.enums.SysOrganEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.organ.SysOrganEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.vo.organ.SysOrganVo;
import com.byh.sys.data.repository.SysHospitalMapper;
import com.byh.sys.data.repository.SysOrganMapper;
import com.byh.sys.web.service.SysOrganService;
import enums.ConstantsEnums;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysOrganServiceImpl
extends ServiceImpl<SysOrganMapper, SysOrganEntity>
implements SysOrganService {
    private final SysOrganMapper sysOrganMapper;
    private final Logger logger = LoggerFactory.getLogger(SysOrganServiceImpl.class);
    @Resource
    private SysHospitalMapper sysHospitalMapper;

    public Page<SysOrganVo> sysOrganSelect(SysOrganDTO dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysOrganMapper.sysOrganSelect(page, dto);
        page.setRecords(list);
        return page;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void sysOrganSave(SysOrganSaveDTO dto) {
        SysOrganEntity entity = new SysOrganEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        this.checkNameExists(dto.getName());
        int a = this.sysOrganMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysOrganEnum.SYS_ORGAN_INSERT_ERROR.getCode(), (String)SysOrganEnum.SYS_ORGAN_INSERT_ERROR.getName());
    }

    public void sysOrganUpdate(SysOrganUpdateDTO dto) {
        SysOrganEntity entity = new SysOrganEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        SysOrganEntity oldEntity = (SysOrganEntity)this.sysOrganMapper.selectById((Serializable)dto.getId());
        if (!oldEntity.getName().equals(dto.getName())) {
            this.checkNameExists(dto.getName());
        }
        int a = this.sysOrganMapper.updateById((Object)entity);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysOrganEnum.SYS_ORGAN_UPDATE_ERROR.getCode(), (String)SysOrganEnum.SYS_ORGAN_UPDATE_ERROR.getName());
    }

    public void sysOrganDeleteByIds(Integer[] ids) {
        if (ArrayUtil.isEmpty((Object[])ids)) {
            throw new BusinessException(SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getCode(), SysCommonEnum.ARRAY_LENGTH_IS_ZERO.getName());
        }
        List list = this.sysOrganMapper.checkRelation(ids);
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SysOrganVo vo : list) {
                builder.append("\u3010").append(vo.getName()).append("\u3011\u4e0b\u6709\u3010").append(vo.getCount()).append("\u5bb6\u3011\u533b\u9662\u6b63\u5728\u5173\u8054").append(";");
            }
            ExceptionUtils.createException((Logger)this.logger, (boolean)Boolean.TRUE, (String)SysOrganEnum.SYS_ORGAN_DELETE_ERROR.getCode(), (String)builder.toString());
        }
        int a = this.sysOrganMapper.sysOrganDeleteByIds(ids);
        ExceptionUtils.createException((Logger)this.logger, (int)a, (String)SysOrganEnum.SYS_ORGAN_DELETE_ERROR.getCode(), (String)SysOrganEnum.SYS_ORGAN_DELETE_ERROR.getName());
    }

    public void checkNameExists(String name) {
        List entityList = this.sysOrganMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysOrganEntity::getName, (Object)name)).eq(BaseEntity::getDelFlag, (Object)ConstantsEnums.DEL_FLAG_ZERO.getValue()));
        if (!CollectionUtils.isEmpty((Collection)entityList)) {
            throw new BusinessException(SysOrganEnum.SYS_ORGAN_NAME_ALREADY_EXISTS.getCode(), SysOrganEnum.SYS_ORGAN_NAME_ALREADY_EXISTS.getName());
        }
    }

    public SysOrganServiceImpl(SysOrganMapper sysOrganMapper, SysHospitalMapper sysHospitalMapper) {
        this.sysOrganMapper = sysOrganMapper;
        this.sysHospitalMapper = sysHospitalMapper;
    }
}

