/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.sys.api.dto.suppiler.SysSupplierDto;
import com.byh.sys.api.dto.suppiler.SysSupplierSaveDto;
import com.byh.sys.api.dto.suppiler.SysSupplierUpdateDto;
import com.byh.sys.api.enums.SyssupplierEnum;
import com.byh.sys.api.model.suppiler.SysSupplierEntity;
import com.byh.sys.api.util.BeanUtil;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.UUIDUtils;
import com.byh.sys.api.vo.SysSupplierVo;
import com.byh.sys.data.repository.SysSupplierMapper;
import com.byh.sys.web.service.SysSupplierService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysSupplierServiceImpl
implements SysSupplierService {
    private static final Logger log = LoggerFactory.getLogger(SysSupplierServiceImpl.class);
    @Resource
    private SysSupplierMapper sysSupplierMapper;

    public void sysSupplierSave(SysSupplierSaveDto dto) {
        SysSupplierEntity entity = (SysSupplierEntity)BeanUtil.copy((Object)dto, SysSupplierEntity.class);
        entity.setId(UUIDUtils.getAllLetterRandom((int)6));
        if (null != dto.getBusinessLicense()) {
            entity.setBusinessLicense(JSON.toJSONString((Object)dto.getBusinessLicense()));
        }
        if (null != dto.getMedicalDeviceRegistration()) {
            entity.setMedicalDeviceRegistration(JSON.toJSONString((Object)dto.getMedicalDeviceRegistration()));
        }
        if (null != dto.getOperatePermit()) {
            entity.setOperatePermit(JSON.toJSONString((Object)dto.getOperatePermit()));
        }
        entity.setId(UUIDUtils.getRandom((int)6, (boolean)false));
        int a = this.sysSupplierMapper.insert((Object)entity);
        ExceptionUtils.createException((Logger)log, (int)a, (String)SyssupplierEnum.SYS_SUPPLIER_INSERT_ERROR.getCode(), (String)SyssupplierEnum.SYS_SUPPLIER_INSERT_ERROR.getName());
    }

    public IPage<SysSupplierVo> sysSupplierSelect(Page page, SysSupplierDto dto) {
        IPage list = this.sysSupplierMapper.sysSupplierSelect(page, dto);
        return list;
    }

    public void sysSupplierUpdate(SysSupplierUpdateDto dto) {
        SysSupplierEntity entity = (SysSupplierEntity)BeanUtil.copy((Object)dto, SysSupplierEntity.class);
        if (null != dto.getBusinessLicense()) {
            entity.setBusinessLicense(JSON.toJSONString((Object)dto.getBusinessLicense()));
        }
        if (null != dto.getMedicalDeviceRegistration()) {
            entity.setMedicalDeviceRegistration(JSON.toJSONString((Object)dto.getMedicalDeviceRegistration()));
        }
        if (null != dto.getOperatePermit()) {
            entity.setOperatePermit(JSON.toJSONString((Object)dto.getOperatePermit()));
        }
        int a = this.sysSupplierMapper.update((Object)entity, (Wrapper)Wrappers.lambdaQuery().eq(SysSupplierEntity::getId, (Object)dto.getId()));
        ExceptionUtils.createException((Logger)log, (int)a, (String)SyssupplierEnum.SYS_SUPPLIER_UPDATE_ERROR.getCode(), (String)SyssupplierEnum.SYS_SUPPLIER_UPDATE_ERROR.getName());
    }

    public void sysSupplierDelete(String[] ids) {
        int a = this.sysSupplierMapper.sysSupplierDelete(ids);
    }
}

