/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.web.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.sys.api.dto.ward.QueryWardPageDto;
import com.byh.sys.api.enums.DelFlagEnum;
import com.byh.sys.api.exception.BusinessException;
import com.byh.sys.api.model.SysDoctorEntity;
import com.byh.sys.api.model.base.BaseEntity;
import com.byh.sys.api.model.department.SysDepartmentEntity;
import com.byh.sys.api.model.ward.SysDoctorWardEntity;
import com.byh.sys.api.model.ward.SysWardDepartmentEntity;
import com.byh.sys.api.model.ward.SysWardEntity;
import com.byh.sys.api.util.ExceptionUtils;
import com.byh.sys.api.util.StringPinYinUtil;
import com.byh.sys.api.util.StringWubiUtil;
import com.byh.sys.api.vo.ward.SysWardVo;
import com.byh.sys.data.repository.SysDepartmentMapper;
import com.byh.sys.data.repository.SysDoctorMapper;
import com.byh.sys.data.repository.SysDoctorWardMapper;
import com.byh.sys.data.repository.SysWardDepartmentMapper;
import com.byh.sys.data.repository.SysWardMapper;
import com.byh.sys.web.service.SysWardService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysWardServiceImpl
extends ServiceImpl<SysWardMapper, SysWardEntity>
implements SysWardService {
    private Logger logger = LoggerFactory.getLogger(SysWardServiceImpl.class);
    @Resource
    private SysWardMapper sysWardMapper;
    @Resource
    private SysWardDepartmentMapper sysWardDepartmentMapper;
    @Resource
    private SysDepartmentMapper sysDepartmentMapper;
    @Resource
    private SysDoctorMapper sysDoctorMapper;
    @Resource
    private SysDoctorWardMapper sysDoctorWardMapper;

    public List<SysWardVo> selectTreeList(QueryWardPageDto dto) {
        Page page = new Page();
        page.setSize(-1L);
        List list = this.sysWardMapper.selectPageList(page, dto);
        if (!list.isEmpty()) {
            list = this.getDetailList(list, dto.getTenantId());
        }
        Map nodeMap = list.stream().collect(Collectors.toMap(SysWardVo::getId, Function.identity()));
        ArrayList<SysWardVo> treeList = new ArrayList<SysWardVo>();
        for (SysWardVo vo : list) {
            if (vo.getParentId() == null) {
                treeList.add(vo);
                continue;
            }
            SysWardVo parentTree = (SysWardVo)nodeMap.get(vo.getParentId());
            if (parentTree == null) continue;
            ArrayList<SysWardVo> children = parentTree.getChildren();
            if (children == null) {
                children = new ArrayList<SysWardVo>();
                parentTree.setChildren(children);
            }
            children.add(vo);
        }
        return treeList;
    }

    public Page<SysWardVo> selectPageList(QueryWardPageDto dto) {
        Page page = new Page((long)dto.getCurrent(), (long)dto.getSize());
        List list = this.sysWardMapper.selectPageList(page, dto);
        if (!list.isEmpty()) {
            list = this.getDetailList(list, dto.getTenantId());
        }
        page.setRecords(list);
        return page;
    }

    private List<SysWardVo> getDetailList(List<SysWardVo> list, Integer tenantId) {
        List doctorIds;
        List doctorWardList;
        List deptIds;
        List wardIds = list.stream().map(SysWardVo::getId).collect(Collectors.toList());
        List wardDeptList = this.sysWardDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardDepartmentEntity.class).eq(tenantId != null, SysWardDepartmentEntity::getTenantId, (Object)tenantId)).in(SysWardDepartmentEntity::getWardId, wardIds)).eq(SysWardDepartmentEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
        if (!wardDeptList.isEmpty() && !(deptIds = wardDeptList.stream().map(SysWardDepartmentEntity::getDeptId).distinct().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            List deptList = this.sysDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDepartmentEntity.class).eq(tenantId != null, SysDepartmentEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDepartmentEntity::getStatus, (Object)"0")).in(BaseEntity::getId, deptIds));
            Map deptMap = deptList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map<Integer, List<SysWardDepartmentEntity>> relationMap = wardDeptList.stream().collect(Collectors.groupingBy(SysWardDepartmentEntity::getWardId));
            for (Map.Entry<Integer, List<SysWardDepartmentEntity>> entry : relationMap.entrySet()) {
                List<SysWardDepartmentEntity> wardDepts = entry.getValue();
                for (SysWardDepartmentEntity sysWardDepartmentEntity : wardDepts) {
                    SysDepartmentEntity deptEntity = (SysDepartmentEntity)deptMap.get(sysWardDepartmentEntity.getDeptId());
                    if (deptEntity == null) continue;
                    sysWardDepartmentEntity.setDeptEntity(deptEntity);
                }
            }
            for (SysWardVo vo : list) {
                List relationList = relationMap.getOrDefault(vo.getId(), new ArrayList());
                List depts = relationList.stream().map(SysWardDepartmentEntity::getDeptEntity).filter(Objects::nonNull).collect(Collectors.toList());
                vo.setDeptList(depts);
            }
        }
        if (!(doctorWardList = this.sysDoctorWardMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorWardEntity.class).eq(tenantId != null, SysDoctorWardEntity::getTenantId, (Object)tenantId)).eq(SysDoctorWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysDoctorWardEntity::getWardId, wardIds))).isEmpty() && !(doctorIds = doctorWardList.stream().map(SysDoctorWardEntity::getDoctorId).distinct().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            List doctorList = this.sysDoctorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorEntity.class).eq(tenantId != null, SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDoctorEntity::getStatus, (Object)"0")).in(SysDoctorEntity::getId, doctorIds));
            Map doctorMap = doctorList.stream().collect(Collectors.toMap(SysDoctorEntity::getId, Function.identity()));
            Map<Integer, List<SysDoctorWardEntity>> relationMap = doctorWardList.stream().collect(Collectors.groupingBy(SysDoctorWardEntity::getWardId));
            for (Map.Entry<Integer, List<SysDoctorWardEntity>> entry : relationMap.entrySet()) {
                List<SysDoctorWardEntity> relations = entry.getValue();
                for (SysDoctorWardEntity relation : relations) {
                    SysDoctorEntity doctorEntity = (SysDoctorEntity)doctorMap.get(relation.getDoctorId());
                    if (doctorEntity == null) continue;
                    relation.setDoctor(doctorEntity);
                }
            }
            for (SysWardVo vo : list) {
                List relationList = relationMap.getOrDefault(vo.getId(), new ArrayList());
                List list2 = relationList.stream().map(SysDoctorWardEntity::getDoctor).filter(Objects::nonNull).collect(Collectors.toList());
                vo.setDoctorList(list2);
            }
        }
        return list;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void deleteList(Integer[] ids, Integer tenantId) {
        List doctorWardList;
        List deptWard;
        if (ArrayUtil.isEmpty((Object[])ids)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u6279\u91cf\u5220\u9664\u75c5\u533a\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (!(deptWard = this.sysWardDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardDepartmentEntity.class).eq(tenantId != null, SysWardDepartmentEntity::getTenantId, (Object)tenantId)).eq(SysWardDepartmentEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysWardDepartmentEntity::getWardId, (Object[])ids))).isEmpty()) {
            List deptIds = deptWard.stream().map(SysWardDepartmentEntity::getDeptId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List deptList = this.sysDepartmentMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDepartmentEntity.class).eq(tenantId != null, SysDepartmentEntity::getTenantId, (Object)tenantId)).eq(BaseEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDepartmentEntity::getStatus, (Object)"0")).in(BaseEntity::getId, deptIds));
            if (!deptList.isEmpty()) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5b58\u5728\u5173\u8054\u7684\u79d1\u5ba4\uff0c\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        if (!(doctorWardList = this.sysDoctorWardMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorWardEntity.class).eq(tenantId != null, SysDoctorWardEntity::getTenantId, (Object)tenantId)).eq(SysDoctorWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).in(SysDoctorWardEntity::getWardId, (Object[])ids))).isEmpty()) {
            List doctorIds = doctorWardList.stream().map(SysDoctorWardEntity::getDoctorId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List doctorList = this.sysDoctorMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysDoctorEntity.class).eq(tenantId != null, SysDoctorEntity::getTenantId, (Object)tenantId)).eq(SysDoctorEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue())).eq(SysDoctorEntity::getStatus, (Object)"0")).in(SysDoctorEntity::getId, doctorIds));
            if (!doctorList.isEmpty()) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u5b58\u5728\u5173\u8054\u7684\u4eba\u5458\uff0c\u5220\u9664\u5931\u8d25\uff01");
            }
        }
        int deleteCount = this.sysWardMapper.deletList(ids, tenantId);
        ExceptionUtils.createException((Logger)this.logger, (int)deleteCount, (String)"500", (String)"\u75c5\u533a\u5220\u9664\u5931\u8d25\uff01");
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void update(SysWardEntity entity) {
        if (entity.getId() == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u75c5\u533a\u65f6\uff0c\u4e3b\u952eID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        Integer tenantId = entity.getTenantId();
        String wardName = entity.getWardName();
        Integer operatorId = entity.getUpdateId();
        String operatorName = entity.getUpdateName();
        Integer wardId = entity.getId();
        SysWardEntity dbWard = (SysWardEntity)this.sysWardMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardEntity.class).eq(tenantId != null, SysWardEntity::getTenantId, (Object)tenantId)).eq(SysWardEntity::getWardName, (Object)wardName)).eq(SysWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
        if (dbWard != null && !dbWard.getId().equals(entity.getId())) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u7f16\u8f91\u75c5\u533a\u65f6\uff0c\u75c5\u533a\u5df2\u5b58\u5728\uff01");
        }
        entity.setPyCode(StringPinYinUtil.toFirstChar((String)wardName));
        entity.setWbCode(StringWubiUtil.getWbCode((String)wardName));
        entity.setUpdateId(operatorId);
        entity.setUpdateName(operatorName);
        entity.setUpdateTime(new Date());
        this.sysWardMapper.updateById((Object)entity);
        LambdaQueryWrapper deleteRelationWrapper = Wrappers.lambdaQuery();
        deleteRelationWrapper.eq(tenantId != null, SysWardDepartmentEntity::getTenantId, (Object)tenantId);
        deleteRelationWrapper.eq(SysWardDepartmentEntity::getWardId, (Object)wardId);
        this.sysWardDepartmentMapper.delete((Wrapper)deleteRelationWrapper);
        if (entity.getDeptIds() != null && !entity.getDeptIds().isEmpty()) {
            this.insertRelationList(entity.getDeptIds(), tenantId, wardId, operatorId, operatorName);
        }
        LambdaQueryWrapper deleteDoctorRelation = Wrappers.lambdaQuery();
        deleteDoctorRelation.eq(tenantId != null, SysDoctorWardEntity::getTenantId, (Object)tenantId);
        deleteDoctorRelation.eq(SysDoctorWardEntity::getWardId, (Object)wardId);
        this.sysDoctorWardMapper.delete((Wrapper)deleteDoctorRelation);
        if (entity.getDoctorIds() != null && !entity.getDoctorIds().isEmpty()) {
            this.insertDoctorRelationList(entity.getDoctorIds(), tenantId, wardId, operatorId, operatorName);
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insert(SysWardEntity entity) {
        Integer tenantId = entity.getTenantId();
        String wardName = entity.getWardName();
        Integer operatorId = entity.getCreateId();
        String operatorName = entity.getCreateName();
        SysWardEntity dbWard = (SysWardEntity)this.sysWardMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysWardEntity.class).eq(tenantId != null, SysWardEntity::getTenantId, (Object)tenantId)).eq(SysWardEntity::getWardName, (Object)wardName)).eq(SysWardEntity::getDelFlag, (Object)DelFlagEnum.NOT_FLAG.getValue()));
        if (dbWard != null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u65b0\u589e\u75c5\u533a\u65f6\uff0c\u75c5\u533a\u5df2\u5b58\u5728\uff01");
        }
        entity.setPyCode(StringPinYinUtil.toFirstChar((String)wardName));
        entity.setWbCode(StringWubiUtil.getWbCode((String)wardName));
        entity.setCreateId(operatorId);
        entity.setCreateName(operatorName);
        this.sysWardMapper.insert((Object)entity);
        Integer wardId = entity.getId();
        if (entity.getDeptIds() != null && !entity.getDeptIds().isEmpty()) {
            this.insertRelationList(entity.getDeptIds(), tenantId, wardId, operatorId, operatorName);
        }
        if (entity.getDoctorIds() != null && !entity.getDoctorIds().isEmpty()) {
            this.insertDoctorRelationList(entity.getDoctorIds(), tenantId, wardId, operatorId, operatorName);
        }
    }

    private void insertDoctorRelationList(List<Integer> doctorIds, Integer tenantId, Integer wardId, Integer operatorId, String operatorName) {
        List relationList = doctorIds.stream().map(doctorId -> {
            SysDoctorWardEntity doctorWard = new SysDoctorWardEntity();
            doctorWard.setTenantId(tenantId);
            doctorWard.setDoctorId(doctorId);
            doctorWard.setWardId(wardId);
            doctorWard.setOperatorId(operatorId);
            doctorWard.setOperatorName(operatorName);
            return doctorWard;
        }).collect(Collectors.toList());
        this.sysDoctorWardMapper.insertList(relationList);
    }

    private void insertRelationList(List<Integer> deptIds, Integer tenantId, Integer wardId, Integer operatorId, String operatorName) {
        List relationList = deptIds.stream().map(deptId -> {
            SysWardDepartmentEntity deptWard = new SysWardDepartmentEntity();
            deptWard.setTenantId(tenantId);
            deptWard.setDeptId(deptId);
            deptWard.setWardId(wardId);
            deptWard.setOperatorId(operatorId);
            deptWard.setOperatorName(operatorName);
            return deptWard;
        }).collect(Collectors.toList());
        this.sysWardDepartmentMapper.insertList(relationList);
    }
}

