/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.chdu.ai.service.DashScopeService;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DashScopeServiceImpl
implements DashScopeService {
    private static final Logger log = LoggerFactory.getLogger(DashScopeServiceImpl.class);
    @Value(value="${dashscope.api-key}")
    private String apiKey;
    @Value(value="${dashscope.model}")
    private String model;

    public String generateResponse(String userInput) {
        try {
            Generation gen = new Generation();
            Message userMsg = Message.builder().role(Role.USER.getValue()).content(userInput).build();
            GenerationParam param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.model)).messages(Arrays.asList(userMsg)).resultFormat(GenerationParam.ResultFormat.MESSAGE).build();
            GenerationResult result = gen.call((HalfDuplexServiceParam)param);
            return ((GenerationOutput.Choice)result.getOutput().getChoices().get(0)).getMessage().getContent();
        }
        catch (ApiException | InputRequiredException | NoApiKeyException e) {
            log.error("DashScope API \u8c03\u7528\u5931\u8d25: {}", (Object)e.getMessage());
            return "\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002";
        }
    }
}

