/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.ChatMessage;
import com.chdu.ai.service.ChatService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/chat"})
@CrossOrigin(origins={"*"})
public class ChatController {
    private static final Logger logger = LoggerFactory.getLogger(ChatController.class);
    @Autowired
    private ChatService chatService;

    @GetMapping(value={"/history/{conversationId}"})
    public BaseResponse<List<ChatMessage>> getChatHistory(@PathVariable String conversationId) {
        try {
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2: conversationId={}", (Object)conversationId);
            List messages = this.chatService.getChatRecords(conversationId);
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u6210\u529f: conversationId={}, \u6d88\u606f\u6570\u91cf={}", (Object)conversationId, (Object)messages.size());
            return BaseResponse.success((Object)messages);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: conversationId={}", (Object)conversationId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5bf9\u8bdd\u5386\u53f2\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/messages"})
    public BaseResponse<List<ChatMessage>> getChatMessages(@RequestParam String hospitalId, @RequestParam String userId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u83b7\u53d6\u804a\u5929\u8bb0\u5f55: hospitalId={}, userId={}, page={}, size={}", new Object[]{hospitalId, userId, page, size});
            List messages = this.chatService.getChatMessagesByHospitalAndUser(hospitalId, userId, page, size);
            logger.info("\u83b7\u53d6\u804a\u5929\u8bb0\u5f55\u6210\u529f: hospitalId={}, userId={}, \u6d88\u606f\u6570\u91cf={}", new Object[]{hospitalId, userId, messages.size()});
            return BaseResponse.success((Object)messages);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u804a\u5929\u8bb0\u5f55\u5931\u8d25: hospitalId={}, userId={}", new Object[]{hospitalId, userId, e});
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u804a\u5929\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/conversations"})
    public BaseResponse<List<Map<String, Object>>> getConversations(@RequestParam String hospitalId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5217\u8868: hospitalId={}, page={}, size={}", new Object[]{hospitalId, page, size});
            List conversations = this.chatService.getConversationsByHospital(hospitalId, page, size);
            logger.info("\u83b7\u53d6\u5bf9\u8bdd\u5217\u8868\u6210\u529f: hospitalId={}, \u5bf9\u8bdd\u6570\u91cf={}", (Object)hospitalId, (Object)conversations.size());
            return BaseResponse.success((Object)conversations);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8bdd\u5217\u8868\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5bf9\u8bdd\u5217\u8868\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PutMapping(value={"/revoke/{messageId}"})
    public BaseResponse<String> revokeMessage(@PathVariable String messageId) {
        try {
            logger.info("\u64a4\u56de\u6d88\u606f: messageId={}", (Object)messageId);
            boolean success = this.chatService.revokeMessage(messageId);
            if (success) {
                logger.info("\u64a4\u56de\u6d88\u606f\u6210\u529f: messageId={}", (Object)messageId);
                return BaseResponse.success((Object)"\u6d88\u606f\u64a4\u56de\u6210\u529f");
            }
            logger.warn("\u64a4\u56de\u6d88\u606f\u5931\u8d25: messageId={}", (Object)messageId);
            return BaseResponse.error((String)"400", (String)"\u6d88\u606f\u64a4\u56de\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u64a4\u56de\u6d88\u606f\u5f02\u5e38: messageId={}", (Object)messageId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u64a4\u56de\u6d88\u606f\u5931\u8d25: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{messageId}"})
    public BaseResponse<String> deleteMessage(@PathVariable String messageId) {
        try {
            logger.info("\u5220\u9664\u6d88\u606f: messageId={}", (Object)messageId);
            boolean success = this.chatService.deleteMessage(messageId);
            if (success) {
                logger.info("\u5220\u9664\u6d88\u606f\u6210\u529f: messageId={}", (Object)messageId);
                return BaseResponse.success((Object)"\u6d88\u606f\u5220\u9664\u6210\u529f");
            }
            logger.warn("\u5220\u9664\u6d88\u606f\u5931\u8d25: messageId={}", (Object)messageId);
            return BaseResponse.error((String)"400", (String)"\u6d88\u606f\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6d88\u606f\u5f02\u5e38: messageId={}", (Object)messageId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u6d88\u606f\u5931\u8d25: " + e.getMessage()));
        }
    }
}

