/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.model.DifyDataset;
import com.chdu.ai.model.DifyDocument;
import com.chdu.ai.model.DifyDocumentRequest;
import com.chdu.ai.model.DifyKnowledgeRequest;
import com.chdu.ai.model.HospitalWorkflow;
import com.chdu.ai.service.DifyKnowledgeService;
import com.chdu.ai.service.HospitalWorkflowService;
import com.chdu.ai.service.impl.DifyKnowledgeServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DifyKnowledgeServiceImpl
implements DifyKnowledgeService {
    private static final Logger logger = LoggerFactory.getLogger(DifyKnowledgeServiceImpl.class);
    @Autowired
    private HospitalWorkflowService hospitalWorkflowService;
    private final RestTemplate restTemplate = new RestTemplate();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public DifyDataset createDataset(DifyKnowledgeRequest request, String hospitalId, String createdBy) {
        logger.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6: name={}, hospitalId={}, createdBy={}", new Object[]{request.getName(), hospitalId, createdBy});
        try {
            this.validateCreateDatasetRequest(request, hospitalId, createdBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets";
            HttpHeaders headers = this.createHeaders(workflow);
            Map requestBody = this.buildCreateDatasetRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDataset dataset = this.parseDatasetFromResponse(jsonResponse, hospitalId, createdBy);
                logger.info("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u6210\u529f: id={}, name={}", (Object)dataset.getId(), (Object)dataset.getName());
                return dataset;
            }
            logger.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5f02\u5e38: name={}, hospitalId={}", new Object[]{request.getName(), hospitalId, e});
            throw new RuntimeException("\u521b\u5efa\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public List<DifyDataset> getDatasets(String hospitalId, int page, int limit) {
        logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868: hospitalId={}, page={}, limit={}", new Object[]{hospitalId, page, limit});
        try {
            this.validatePaginationParams(page, limit);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets?page=" + page + "&limit=" + limit;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List datasets = this.parseDatasetListFromResponse(jsonResponse, hospitalId);
                logger.info("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868\u6210\u529f: hospitalId={}, count={}", (Object)hospitalId, (Object)datasets.size());
                return datasets;
            }
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new ArrayList<DifyDataset>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u77e5\u8bc6\u5e93\u6570\u636e\u96c6\u5217\u8868\u5f02\u5e38: hospitalId={}", (Object)hospitalId, (Object)e);
            return new ArrayList<DifyDataset>();
        }
    }

    public DifyDataset getDatasetById(String datasetId, String hospitalId) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5: datasetId={}, hospitalId={}", (Object)datasetId, (Object)hospitalId);
        try {
            this.validateDatasetId(datasetId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDataset dataset = this.parseDatasetFromResponse(jsonResponse, hospitalId, null);
                logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u6210\u529f: id={}, name={}", (Object)dataset.getId(), (Object)dataset.getName());
                return dataset;
            }
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{datasetId, hospitalId, e});
            return null;
        }
    }

    public DifyDataset updateDataset(String datasetId, DifyKnowledgeRequest request, String hospitalId, String updatedBy) {
        logger.info("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f: datasetId={}, hospitalId={}, updatedBy={}", new Object[]{datasetId, hospitalId, updatedBy});
        try {
            this.validateDatasetId(datasetId);
            this.validateUpdateDatasetRequest(request, hospitalId, updatedBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId;
            HttpHeaders headers = this.createHeaders(workflow);
            Map requestBody = this.buildUpdateDatasetRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDataset dataset = this.parseDatasetFromResponse(jsonResponse, hospitalId, updatedBy);
                logger.info("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u6210\u529f: id={}, name={}", (Object)dataset.getId(), (Object)dataset.getName());
                return dataset;
            }
            logger.error("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{datasetId, hospitalId, e});
            throw new RuntimeException("\u66f4\u65b0\u6570\u636e\u96c6\u4fe1\u606f\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public boolean deleteDataset(String datasetId, String hospitalId) {
        logger.info("\u5220\u9664\u6570\u636e\u96c6: datasetId={}, hospitalId={}", (Object)datasetId, (Object)hospitalId);
        try {
            boolean success;
            this.validateDatasetId(datasetId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u5220\u9664\u6570\u636e\u96c6\u6210\u529f: datasetId={}", (Object)datasetId);
            } else {
                logger.error("\u5220\u9664\u6570\u636e\u96c6\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u96c6\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{datasetId, hospitalId, e});
            return false;
        }
    }

    public DifyDocument uploadDocument(DifyDocumentRequest request, String hospitalId, String uploadedBy) {
        logger.info("\u4e0a\u4f20\u6587\u6863\u5230\u6570\u636e\u96c6: datasetId={}, hospitalId={}, uploadedBy={}", new Object[]{request.getDatasetId(), hospitalId, uploadedBy});
        try {
            this.validateUploadDocumentRequest(request, hospitalId, uploadedBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + request.getDatasetId() + "/document/create_by_file";
            HttpHeaders headers = this.createMultipartHeaders(workflow);
            MultiValueMap requestBody = this.buildUploadDocumentRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, request.getDatasetId(), uploadedBy);
                logger.info("\u4e0a\u4f20\u6587\u6863\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u4e0a\u4f20\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u6863\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{request.getDatasetId(), hospitalId, e});
            throw new RuntimeException("\u4e0a\u4f20\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public List<DifyDocument> getDocuments(String datasetId, String hospitalId, int page, int limit) {
        logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868: datasetId={}, hospitalId={}, page={}, limit={}", new Object[]{datasetId, hospitalId, page, limit});
        try {
            this.validateDatasetId(datasetId);
            this.validatePaginationParams(page, limit);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/documents?page=" + page + "&limit=" + limit;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                List documents = this.parseDocumentListFromResponse(jsonResponse, datasetId);
                logger.info("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868\u6210\u529f: datasetId={}, count={}", (Object)datasetId, (Object)documents.size());
                return documents;
            }
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new ArrayList<DifyDocument>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u96c6\u6587\u6863\u5217\u8868\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{datasetId, hospitalId, e});
            return new ArrayList<DifyDocument>();
        }
    }

    public DifyDocument getDocumentById(String documentId, String hospitalId) {
        logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, null, null);
                logger.info("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u8be6\u60c5\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return null;
        }
    }

    public DifyDocument updateDocument(String documentId, DifyDocumentRequest request, String hospitalId, String updatedBy) {
        logger.info("\u66f4\u65b0\u6587\u6863: documentId={}, hospitalId={}, updatedBy={}", new Object[]{documentId, hospitalId, updatedBy});
        try {
            this.validateDocumentId(documentId);
            this.validateUpdateDocumentRequest(request, hospitalId, updatedBy);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId + "/update_by_file";
            HttpHeaders headers = this.createMultipartHeaders(workflow);
            MultiValueMap requestBody = this.buildUpdateDocumentRequestBody(request);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                DifyDocument document = this.parseDocumentFromResponse(jsonResponse, request.getDatasetId(), updatedBy);
                logger.info("\u66f4\u65b0\u6587\u6863\u6210\u529f: id={}, name={}", (Object)document.getId(), (Object)document.getName());
                return document;
            }
            logger.error("\u66f4\u65b0\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + response.getStatusCode());
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            throw new RuntimeException("\u66f4\u65b0\u6587\u6863\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public boolean deleteDocument(String documentId, String hospitalId) {
        logger.info("\u5220\u9664\u6587\u6863: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            boolean success;
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u5220\u9664\u6587\u6863\u6210\u529f: documentId={}", (Object)documentId);
            } else {
                logger.error("\u5220\u9664\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    public boolean toggleDocumentStatus(String documentId, boolean enabled, String hospitalId, String operatedBy) {
        logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001: documentId={}, enabled={}, hospitalId={}, operatedBy={}", new Object[]{documentId, enabled, hospitalId, operatedBy});
        try {
            boolean success;
            this.validateDocumentId(documentId);
            String action = enabled ? "enable" : "disable";
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId + "/" + action;
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PATCH, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u5207\u6362\u6587\u6863\u72b6\u6001\u6210\u529f: documentId={}, enabled={}", (Object)documentId, (Object)enabled);
            } else {
                logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6587\u6863\u72b6\u6001\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    public Map<String, Object> retrieveKnowledge(String datasetId, String query, int topK, double scoreThreshold, String hospitalId) {
        logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9: datasetId={}, query={}, topK={}, scoreThreshold={}, hospitalId={}", new Object[]{datasetId, query, topK, scoreThreshold, hospitalId});
        try {
            this.validateDatasetId(datasetId);
            this.validateRetrieveKnowledgeParams(query, topK, scoreThreshold);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/" + datasetId + "/retrieve";
            HttpHeaders headers = this.createHeaders(workflow);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("query", query);
            HashMap<String, Number> retrievalSetting = new HashMap<String, Number>();
            retrievalSetting.put("top_k", topK);
            retrievalSetting.put("score_threshold", scoreThreshold);
            requestBody.put("retrieval_setting", retrievalSetting);
            HttpEntity entity = new HttpEntity(requestBody, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                Map result = (Map)this.objectMapper.convertValue((Object)jsonResponse, Map.class);
                logger.info("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u6210\u529f: datasetId={}, resultCount={}", (Object)datasetId, (Object)jsonResponse.get("query_result").size());
                return result;
            }
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            logger.error("\u68c0\u7d22\u77e5\u8bc6\u5e93\u5185\u5bb9\u5f02\u5e38: datasetId={}, hospitalId={}", new Object[]{datasetId, hospitalId, e});
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Object> getDocumentStatus(String documentId, String hospitalId) {
        logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001: documentId={}, hospitalId={}", (Object)documentId, (Object)hospitalId);
        try {
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId + "/indexing-status";
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                JsonNode jsonResponse = this.objectMapper.readTree((String)response.getBody());
                Map status = (Map)this.objectMapper.convertValue((Object)jsonResponse, Map.class);
                logger.info("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u6210\u529f: documentId={}, status={}", (Object)documentId, (Object)jsonResponse.get("indexing_status"));
                return status;
            }
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u6863\u5904\u7406\u72b6\u6001\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return new HashMap<String, Object>();
        }
    }

    public boolean reindexDocument(String documentId, String hospitalId, String operatedBy) {
        logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863: documentId={}, hospitalId={}, operatedBy={}", new Object[]{documentId, hospitalId, operatedBy});
        try {
            boolean success;
            this.validateDocumentId(documentId);
            HospitalWorkflow workflow = this.getWorkflowConfig(hospitalId);
            String url = this.getApiUrl(workflow) + "/datasets/documents/" + documentId + "/processing";
            HttpHeaders headers = this.createHeaders(workflow);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            boolean bl = success = response.getStatusCode() == HttpStatus.OK;
            if (success) {
                logger.info("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u6210\u529f: documentId={}", (Object)documentId);
            } else {
                logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
            return success;
        }
        catch (Exception e) {
            logger.error("\u91cd\u65b0\u7d22\u5f15\u6587\u6863\u5f02\u5e38: documentId={}, hospitalId={}", new Object[]{documentId, hospitalId, e});
            return false;
        }
    }

    private HospitalWorkflow getWorkflowConfig(String hospitalId) {
        if (hospitalId == null || hospitalId.trim().isEmpty()) {
            throw new IllegalArgumentException("hospitalId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        HospitalWorkflow workflow = this.hospitalWorkflowService.getWorkflowByHospitalIdAndType(hospitalId, "knowledge");
        if (workflow != null) {
            logger.debug("\u4f7f\u7528\u77e5\u8bc6\u5e93\u4e13\u7528\u5de5\u4f5c\u6d41: hospitalId={}, workflowType=knowledge", (Object)hospitalId);
            return workflow;
        }
        workflow = this.hospitalWorkflowService.getWorkflowByHospitalId(hospitalId);
        if (workflow == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u533b\u9662\u5de5\u4f5c\u6d41\u914d\u7f6e: hospitalId=" + hospitalId);
        }
        logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u5de5\u4f5c\u6d41: hospitalId={}, workflowType={}", (Object)hospitalId, (Object)workflow.getWorkflowType());
        return workflow;
    }

    private String getApiUrl(HospitalWorkflow workflow) {
        if (workflow == null || workflow.getDifyApiUrl() == null) {
            throw new RuntimeException("\u5de5\u4f5c\u6d41\u914d\u7f6e\u4e2d\u7f3a\u5c11 Dify API URL");
        }
        return workflow.getDifyApiUrl();
    }

    private String getApiKey(HospitalWorkflow workflow) {
        if (workflow == null || workflow.getDifyApiKey() == null) {
            throw new RuntimeException("\u5de5\u4f5c\u6d41\u914d\u7f6e\u4e2d\u7f3a\u5c11 Dify API Key");
        }
        return workflow.getDifyApiKey();
    }

    private HttpHeaders createHeaders(HospitalWorkflow workflow) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.getApiKey(workflow));
        return headers;
    }

    private HttpHeaders createMultipartHeaders(HospitalWorkflow workflow) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("Authorization", "Bearer " + this.getApiKey(workflow));
        return headers;
    }

    private void validateCreateDatasetRequest(DifyKnowledgeRequest request, String hospitalId, String createdBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u521b\u5efa\u6570\u636e\u96c6\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)request.getName())) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)createdBy)) {
            throw new IllegalArgumentException("\u521b\u5efa\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUpdateDatasetRequest(DifyKnowledgeRequest request, String hospitalId, String updatedBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u96c6\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)updatedBy)) {
            throw new IllegalArgumentException("\u66f4\u65b0\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUploadDocumentRequest(DifyDocumentRequest request, String hospitalId, String uploadedBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u6863\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)request.getDatasetId())) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getFile() == null || request.getFile().isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)uploadedBy)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUpdateDocumentRequest(DifyDocumentRequest request, String hospitalId, String updatedBy) {
        if (request == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6587\u6863\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)hospitalId)) {
            throw new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)updatedBy)) {
            throw new IllegalArgumentException("\u66f4\u65b0\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateDatasetId(String datasetId) {
        if (!StringUtils.hasText((String)datasetId)) {
            throw new IllegalArgumentException("\u6570\u636e\u96c6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateDocumentId(String documentId) {
        if (!StringUtils.hasText((String)documentId)) {
            throw new IllegalArgumentException("\u6587\u6863ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validatePaginationParams(int page, int limit) {
        if (page < 1) {
            throw new IllegalArgumentException("\u9875\u7801\u5fc5\u987b\u5927\u4e8e0");
        }
        if (limit < 1 || limit > 100) {
            throw new IllegalArgumentException("\u6bcf\u9875\u6570\u91cf\u5fc5\u987b\u57281-100\u4e4b\u95f4");
        }
    }

    private void validateRetrieveKnowledgeParams(String query, int topK, double scoreThreshold) {
        if (!StringUtils.hasText((String)query)) {
            throw new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (topK < 1 || topK > 50) {
            throw new IllegalArgumentException("\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u5fc5\u987b\u57281-50\u4e4b\u95f4");
        }
        if (scoreThreshold < 0.0 || scoreThreshold > 1.0) {
            throw new IllegalArgumentException("\u76f8\u4f3c\u5ea6\u9608\u503c\u5fc5\u987b\u57280.0-1.0\u4e4b\u95f4");
        }
    }

    private Map<String, Object> buildCreateDatasetRequestBody(DifyKnowledgeRequest request) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("name", request.getName());
        if (StringUtils.hasText((String)request.getDescription())) {
            requestBody.put("description", request.getDescription());
        }
        if (StringUtils.hasText((String)request.getPermissionType())) {
            requestBody.put("permission", request.getPermissionType());
        }
        if (StringUtils.hasText((String)request.getIndexingTechnique())) {
            requestBody.put("indexing_technique", request.getIndexingTechnique());
        }
        if (StringUtils.hasText((String)request.getEmbeddingModel())) {
            HashMap<String, String> embeddingConfig = new HashMap<String, String>();
            embeddingConfig.put("embedding_model", request.getEmbeddingModel());
            if (StringUtils.hasText((String)request.getEmbeddingModelProvider())) {
                embeddingConfig.put("embedding_model_provider", request.getEmbeddingModelProvider());
            }
            if (request.getEmbeddingModelConfig() != null) {
                embeddingConfig.putAll(request.getEmbeddingModelConfig());
            }
            requestBody.put("embedding_model_config", embeddingConfig);
        }
        if (StringUtils.hasText((String)request.getRetrievalModel()) || request.getRetrievalModelConfig() != null) {
            HashMap<String, String> retrievalConfig = new HashMap<String, String>();
            if (StringUtils.hasText((String)request.getRetrievalModel())) {
                retrievalConfig.put("retrieval_model", request.getRetrievalModel());
            }
            if (request.getRetrievalModelConfig() != null) {
                retrievalConfig.putAll(request.getRetrievalModelConfig());
            }
            requestBody.put("retrieval_model_config", retrievalConfig);
        }
        return requestBody;
    }

    private Map<String, Object> buildUpdateDatasetRequestBody(DifyKnowledgeRequest request) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        if (StringUtils.hasText((String)request.getName())) {
            requestBody.put("name", request.getName());
        }
        if (StringUtils.hasText((String)request.getDescription())) {
            requestBody.put("description", request.getDescription());
        }
        if (StringUtils.hasText((String)request.getPermissionType())) {
            requestBody.put("permission", request.getPermissionType());
        }
        return requestBody;
    }

    private MultiValueMap<String, Object> buildUploadDocumentRequestBody(DifyDocumentRequest request) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        MultipartFile file = request.getFile();
        1 fileResource = new /* Unavailable Anonymous Inner Class!! */;
        requestBody.add((Object)"file", (Object)fileResource);
        if (StringUtils.hasText((String)request.getIndexingTechnique())) {
            requestBody.add((Object)"indexing_technique", (Object)request.getIndexingTechnique());
        }
        if (StringUtils.hasText((String)request.getProcessRule())) {
            requestBody.add((Object)"process_rule", (Object)request.getProcessRule());
        }
        if (StringUtils.hasText((String)request.getDuplicateCheck())) {
            requestBody.add((Object)"duplicate_check", (Object)request.getDuplicateCheck());
        }
        if (request.getMaxTokens() != null || request.getChunkOverlap() != null || StringUtils.hasText((String)request.getSeparator())) {
            HashMap<String, Object> rules = new HashMap<String, Object>();
            if (request.getMaxTokens() != null) {
                rules.put("max_tokens", request.getMaxTokens());
            }
            if (request.getChunkOverlap() != null) {
                rules.put("chunk_overlap", request.getChunkOverlap());
            }
            if (StringUtils.hasText((String)request.getSeparator())) {
                rules.put("separator", request.getSeparator());
            }
            requestBody.add((Object)"rules", (Object)this.objectMapper.writeValueAsString(rules));
        }
        return requestBody;
    }

    private MultiValueMap<String, Object> buildUpdateDocumentRequestBody(DifyDocumentRequest request) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        if (request.getFile() != null && !request.getFile().isEmpty()) {
            MultipartFile file = request.getFile();
            2 fileResource = new /* Unavailable Anonymous Inner Class!! */;
            requestBody.add((Object)"file", (Object)fileResource);
        }
        if (StringUtils.hasText((String)request.getIndexingTechnique())) {
            requestBody.add((Object)"indexing_technique", (Object)request.getIndexingTechnique());
        }
        if (StringUtils.hasText((String)request.getProcessRule())) {
            requestBody.add((Object)"process_rule", (Object)request.getProcessRule());
        }
        return requestBody;
    }

    private DifyDataset parseDatasetFromResponse(JsonNode jsonResponse, String hospitalId, String operatedBy) {
        long timestamp;
        DifyDataset dataset = new DifyDataset();
        if (jsonResponse.has("id")) {
            dataset.setId(jsonResponse.get("id").asText());
        }
        if (jsonResponse.has("name")) {
            dataset.setName(jsonResponse.get("name").asText());
        }
        if (jsonResponse.has("description")) {
            dataset.setDescription(jsonResponse.get("description").asText());
        }
        if (jsonResponse.has("provider")) {
            dataset.setProvider(jsonResponse.get("provider").asText());
        }
        if (jsonResponse.has("permission")) {
            dataset.setPermissionType(jsonResponse.get("permission").asText());
        }
        if (jsonResponse.has("indexing_technique")) {
            dataset.setIndexingTechnique(jsonResponse.get("indexing_technique").asText());
        }
        if (jsonResponse.has("embedding_model")) {
            dataset.setEmbeddingModel(jsonResponse.get("embedding_model").asText());
        }
        if (jsonResponse.has("embedding_model_provider")) {
            dataset.setEmbeddingModelProvider(jsonResponse.get("embedding_model_provider").asText());
        }
        if (jsonResponse.has("document_count")) {
            dataset.setDocumentCount(Integer.valueOf(jsonResponse.get("document_count").asInt()));
        }
        if (jsonResponse.has("word_count")) {
            dataset.setWordCount(Integer.valueOf(jsonResponse.get("word_count").asInt()));
        }
        if (jsonResponse.has("created_at")) {
            try {
                timestamp = jsonResponse.get("created_at").asLong();
                dataset.setCreatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u521b\u5efa\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        if (jsonResponse.has("updated_at")) {
            try {
                timestamp = jsonResponse.get("updated_at").asLong();
                dataset.setUpdatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u66f4\u65b0\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        dataset.setHospitalId(hospitalId);
        if (operatedBy != null) {
            dataset.setCreatedBy(operatedBy);
            dataset.setUpdatedBy(operatedBy);
        }
        return dataset;
    }

    private List<DifyDataset> parseDatasetListFromResponse(JsonNode jsonResponse, String hospitalId) {
        ArrayList<DifyDataset> datasets = new ArrayList<DifyDataset>();
        if (jsonResponse.has("data") && jsonResponse.get("data").isArray()) {
            for (JsonNode datasetNode : jsonResponse.get("data")) {
                DifyDataset dataset = this.parseDatasetFromResponse(datasetNode, hospitalId, null);
                datasets.add(dataset);
            }
        }
        return datasets;
    }

    private DifyDocument parseDocumentFromResponse(JsonNode jsonResponse, String datasetId, String operatedBy) {
        long timestamp;
        DifyDocument document = new DifyDocument();
        if (jsonResponse.has("id")) {
            document.setId(jsonResponse.get("id").asText());
        }
        if (jsonResponse.has("name")) {
            document.setName(jsonResponse.get("name").asText());
        }
        if (jsonResponse.has("file_name")) {
            document.setFileName(jsonResponse.get("file_name").asText());
        }
        if (jsonResponse.has("data_source_type")) {
            document.setDataSourceType(jsonResponse.get("data_source_type").asText());
        }
        if (jsonResponse.has("data_source_info")) {
            document.setDataSourceInfo(jsonResponse.get("data_source_info").toString());
        }
        if (jsonResponse.has("position")) {
            document.setPosition(Integer.valueOf(jsonResponse.get("position").asInt()));
        }
        if (jsonResponse.has("indexing_status")) {
            document.setStatus(jsonResponse.get("indexing_status").asText());
        }
        if (jsonResponse.has("error")) {
            document.setError(jsonResponse.get("error").asText());
        }
        if (jsonResponse.has("enabled")) {
            document.setEnabled(Boolean.valueOf(jsonResponse.get("enabled").asBoolean()));
        }
        if (jsonResponse.has("archived")) {
            document.setArchived(Boolean.valueOf(jsonResponse.get("archived").asBoolean()));
        }
        if (jsonResponse.has("word_count")) {
            document.setWordCount(Integer.valueOf(jsonResponse.get("word_count").asInt()));
        }
        if (jsonResponse.has("token_count")) {
            document.setTokenCount(Integer.valueOf(jsonResponse.get("token_count").asInt()));
        }
        if (jsonResponse.has("indexing_latency")) {
            document.setIndexingLatency(jsonResponse.get("indexing_latency").asText());
        }
        if (jsonResponse.has("created_at")) {
            try {
                timestamp = jsonResponse.get("created_at").asLong();
                document.setCreatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u521b\u5efa\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        if (jsonResponse.has("updated_at")) {
            try {
                timestamp = jsonResponse.get("updated_at").asLong();
                document.setUpdatedAt(new Date(timestamp * 1000L));
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790\u66f4\u65b0\u65f6\u95f4\u5931\u8d25", (Throwable)e);
            }
        }
        if (datasetId != null) {
            document.setDatasetId(datasetId);
        }
        if (operatedBy != null) {
            document.setCreatedBy(operatedBy);
            document.setUpdatedBy(operatedBy);
        }
        return document;
    }

    private List<DifyDocument> parseDocumentListFromResponse(JsonNode jsonResponse, String datasetId) {
        ArrayList<DifyDocument> documents = new ArrayList<DifyDocument>();
        if (jsonResponse.has("data") && jsonResponse.get("data").isArray()) {
            for (JsonNode documentNode : jsonResponse.get("data")) {
                DifyDocument document = this.parseDocumentFromResponse(documentNode, datasetId, null);
                documents.add(document);
            }
        }
        return documents;
    }
}

