/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.DifyChatRequest;
import com.chdu.ai.model.MultiWorkflowChatRequest;
import com.chdu.ai.service.MultiWorkflowDifyService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/multi-workflow"})
@CrossOrigin(origins={"*"})
public class MultiWorkflowChatController {
    private static final Logger logger = LoggerFactory.getLogger(MultiWorkflowChatController.class);
    @Autowired
    private MultiWorkflowDifyService multiWorkflowDifyService;

    @PostMapping(value={"/chat/stream"}, produces={"text/event-stream"})
    public SseEmitter chatStream(@RequestBody MultiWorkflowChatRequest request, HttpServletRequest httpRequest) {
        try {
            logger.info("\u6536\u5230\u591a\u5de5\u4f5c\u6d41\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42: hospitalId={}, \u7528\u6237={}, \u67e5\u8be2={}", new Object[]{request.getHospitalId(), request.getUser(), request.getQuery()});
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (!this.multiWorkflowDifyService.hasWorkflowConfig(request.getHospitalId())) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u533b\u9662\u672a\u914d\u7f6e\u5de5\u4f5c\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
                return emitter;
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            return this.multiWorkflowDifyService.chatWithDify((DifyChatRequest)request);
        }
        catch (Exception e) {
            logger.error("\u591a\u5de5\u4f5c\u6d41\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
            SseEmitter emitter = new SseEmitter();
            emitter.completeWithError((Throwable)e);
            return emitter;
        }
    }

    @PostMapping(value={"/chat/blocking"})
    public BaseResponse<Map<String, Object>> chatBlocking(@RequestBody MultiWorkflowChatRequest request) {
        try {
            logger.info("\u6536\u5230\u591a\u5de5\u4f5c\u6d41\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42: hospitalId={}, \u7528\u6237={}, \u67e5\u8be2={}", new Object[]{request.getHospitalId(), request.getUser(), request.getQuery()});
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.multiWorkflowDifyService.hasWorkflowConfig(request.getHospitalId())) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662\u672a\u914d\u7f6e\u5de5\u4f5c\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String answer = this.multiWorkflowDifyService.chatWithDifyBlocking((DifyChatRequest)request);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("answer", answer);
            result.put("conversation_id", request.getConversationId());
            result.put("user", request.getUser());
            result.put("hospital_id", request.getHospitalId());
            result.put("workflow_info", this.multiWorkflowDifyService.getWorkflowInfo(request.getHospitalId()));
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u591a\u5de5\u4f5c\u6d41\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25: hospitalId={}", (Object)request.getHospitalId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5904\u7406\u804a\u5929\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/chat/type/stream"}, produces={"text/event-stream"})
    public SseEmitter chatStreamWithType(@RequestBody MultiWorkflowChatRequest request, HttpServletRequest httpRequest) {
        try {
            logger.info("\u6536\u5230\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42: hospitalId={}, workflowType={}, \u7528\u6237={}, \u67e5\u8be2={}", new Object[]{request.getHospitalId(), request.getWorkflowType(), request.getUser(), request.getQuery()});
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                SseEmitter emitter = new SseEmitter();
                emitter.completeWithError((Throwable)new IllegalArgumentException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a"));
                return emitter;
            }
            return this.multiWorkflowDifyService.chatWithDify((DifyChatRequest)request);
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u6d41\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{request.getHospitalId(), request.getWorkflowType(), e});
            SseEmitter emitter = new SseEmitter();
            emitter.completeWithError((Throwable)e);
            return emitter;
        }
    }

    @PostMapping(value={"/chat/type/blocking"})
    public BaseResponse<Map<String, Object>> chatBlockingWithType(@RequestBody MultiWorkflowChatRequest request) {
        try {
            logger.info("\u6536\u5230\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42: hospitalId={}, workflowType={}, \u7528\u6237={}, \u67e5\u8be2={}", new Object[]{request.getHospitalId(), request.getWorkflowType(), request.getUser(), request.getQuery()});
            if (request.getHospitalId() == null || request.getHospitalId().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u533b\u9662ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getWorkflowType() == null || request.getWorkflowType().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u5de5\u4f5c\u6d41\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getQuery() == null || request.getQuery().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u67e5\u8be2\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getUser() == null || request.getUser().trim().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String answer = this.multiWorkflowDifyService.chatWithDifyBlocking((DifyChatRequest)request);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("answer", answer);
            result.put("conversation_id", request.getConversationId());
            result.put("user", request.getUser());
            result.put("hospital_id", request.getHospitalId());
            result.put("workflow_type", request.getWorkflowType());
            result.put("workflow_info", this.multiWorkflowDifyService.getWorkflowInfo(request.getHospitalId()));
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u6307\u5b9a\u7c7b\u578b\u5de5\u4f5c\u6d41\u963b\u585e\u5f0f\u804a\u5929\u8bf7\u6c42\u5904\u7406\u5931\u8d25: hospitalId={}, workflowType={}", new Object[]{request.getHospitalId(), request.getWorkflowType(), e});
            return BaseResponse.error((String)"500", (String)("\u5904\u7406\u804a\u5929\u8bf7\u6c42\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/hospital/{hospitalId}/info"})
    public BaseResponse<Map<String, Object>> getHospitalWorkflowInfo(@PathVariable String hospitalId) {
        try {
            logger.info("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u4fe1\u606f: hospitalId={}", (Object)hospitalId);
            boolean hasConfig = this.multiWorkflowDifyService.hasWorkflowConfig(hospitalId);
            String workflowInfo = this.multiWorkflowDifyService.getWorkflowInfo(hospitalId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("hospital_id", hospitalId);
            result.put("has_config", hasConfig);
            result.put("workflow_info", workflowInfo);
            result.put("timestamp", System.currentTimeMillis());
            return BaseResponse.success(result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u533b\u9662\u5de5\u4f5c\u6d41\u4fe1\u606f\u5931\u8d25: hospitalId={}", (Object)hospitalId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/health"})
    public BaseResponse<Map<String, Object>> health() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("status", "UP");
        status.put("service", "Multi-Workflow Dify Service");
        status.put("timestamp", System.currentTimeMillis());
        return BaseResponse.success(status);
    }
}

