/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.service.impl;

import com.chdu.ai.mapper.STTVoiceCacheMapper;
import com.chdu.ai.model.STTVoiceCache;
import com.chdu.ai.service.STTVoiceCacheService;
import java.security.MessageDigest;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class STTVoiceCacheServiceImpl
implements STTVoiceCacheService {
    private static final Logger logger = LoggerFactory.getLogger(STTVoiceCacheServiceImpl.class);
    @Autowired
    private STTVoiceCacheMapper sttVoiceCacheMapper;

    public STTVoiceCache cacheSTTVoice(String difyMessageId, String userId, String hospitalId, String workflowType, String conversationId, String audioUrl, String fileName, String contentType, Long fileSize, Double duration, String language, String recognizedText) {
        try {
            String cacheKey = this.generateCacheKey(userId, hospitalId, workflowType, conversationId, audioUrl);
            STTVoiceCache existingCache = this.sttVoiceCacheMapper.findByCacheKey(cacheKey);
            if (existingCache != null) {
                existingCache.setDifyMessageId(difyMessageId);
                existingCache.setAudioUrl(audioUrl);
                existingCache.setFileName(fileName);
                existingCache.setContentType(contentType);
                existingCache.setFileSize(fileSize);
                existingCache.setDuration(duration);
                existingCache.setLanguage(language);
                existingCache.setRecognizedText(recognizedText);
                existingCache.setLastHitTime(new Date());
                existingCache.setUpdateTime(new Date());
                this.sttVoiceCacheMapper.updateById(existingCache);
                logger.info("STT\u8bed\u97f3\u7f13\u5b58\u66f4\u65b0\u6210\u529f: difyMessageId={}, cacheKey={}, audioUrl={}", new Object[]{difyMessageId, cacheKey, audioUrl});
                return existingCache;
            }
            STTVoiceCache cache = new STTVoiceCache();
            cache.setCacheKey(cacheKey);
            cache.setDifyMessageId(difyMessageId);
            cache.setUserId(userId);
            cache.setHospitalId(hospitalId);
            cache.setWorkflowType(workflowType);
            cache.setConversationId(conversationId);
            cache.setAudioUrl(audioUrl);
            cache.setFileName(fileName);
            cache.setContentType(contentType);
            cache.setFileSize(fileSize);
            cache.setDuration(duration);
            cache.setLanguage(language);
            cache.setRecognizedText(recognizedText);
            cache.setHitCount(Integer.valueOf(1));
            cache.setLastHitTime(new Date());
            cache.setCreateTime(new Date());
            cache.setUpdateTime(new Date());
            cache.setStatus(Integer.valueOf(1));
            this.sttVoiceCacheMapper.insert(cache);
            logger.info("STT\u8bed\u97f3\u7f13\u5b58\u6210\u529f: difyMessageId={}, cacheKey={}, audioUrl={}, duration={}s", new Object[]{difyMessageId, cacheKey, audioUrl, duration});
            return cache;
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58STT\u8bed\u97f3\u5931\u8d25: difyMessageId={}, userId={}, hospitalId={}, workflowType={}", new Object[]{difyMessageId, userId, hospitalId, workflowType, e});
            throw new RuntimeException("\u7f13\u5b58STT\u8bed\u97f3\u5931\u8d25: " + e.getMessage());
        }
    }

    public STTVoiceCache findByDifyMessageId(String difyMessageId) {
        try {
            return this.sttVoiceCacheMapper.findByDifyMessageId(difyMessageId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u627eSTT\u8bed\u97f3\u7f13\u5b58\u5931\u8d25: difyMessageId={}", (Object)difyMessageId, (Object)e);
            return null;
        }
    }

    public List<STTVoiceCache> findByConversationId(String conversationId) {
        try {
            return this.sttVoiceCacheMapper.findByConversationId(conversationId);
        }
        catch (Exception e) {
            logger.error("\u67e5\u627e\u5bf9\u8bddSTT\u8bed\u97f3\u7f13\u5b58\u5931\u8d25: conversationId={}", (Object)conversationId, (Object)e);
            return null;
        }
    }

    public void updateHitCount(Long cacheId) {
        try {
            this.sttVoiceCacheMapper.updateHitCount(cacheId);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0STT\u8bed\u97f3\u7f13\u5b58\u547d\u4e2d\u6b21\u6570\u5931\u8d25: cacheId={}", (Object)cacheId, (Object)e);
        }
    }

    public boolean deleteCache(Long cacheId) {
        try {
            this.sttVoiceCacheMapper.deleteById(cacheId);
            return true;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664STT\u8bed\u97f3\u7f13\u5b58\u5931\u8d25: cacheId={}", (Object)cacheId, (Object)e);
            return false;
        }
    }

    public String generateCacheKey(String userId, String hospitalId, String workflowType, String conversationId, String audioUrl) {
        try {
            String input = userId + "|" + hospitalId + "|" + workflowType + "|" + conversationId + "|" + audioUrl;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md.digest(input.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error("\u751f\u6210STT\u8bed\u97f3\u7f13\u5b58\u952e\u5931\u8d25", (Throwable)e);
            return "stt_" + System.currentTimeMillis();
        }
    }
}

