/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.alibaba.fastjson.JSONObject;
import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.PayCallbackVo;
import com.chdu.ai.model.PayParamVo;
import com.chdu.ai.model.RefundCallbackVo;
import com.chdu.ai.model.RefundVo;
import com.chdu.ai.service.PayService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pay"})
@CrossOrigin(origins={"*"})
public class PayController {
    private static final Logger logger = LoggerFactory.getLogger(PayController.class);
    @Autowired
    private PayService payService;

    @PostMapping(value={"/pricePay"})
    public BaseResponse<JSONObject> pricePay(@RequestHeader(value="organId", required=false) Integer organId, @RequestBody PayParamVo payParamVo) {
        try {
            logger.info("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355: orderNo={}, organId={}", (Object)payParamVo.getOrderNo(), (Object)organId);
            if (payParamVo.getOrderNo() == null || payParamVo.getOrderNo().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (payParamVo.getPayChannel() == null || payParamVo.getPayChannel().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (organId != null) {
                payParamVo.setOrganId(organId);
            }
            BaseResponse result = this.payService.pricePay(payParamVo);
            logger.info("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u5b8c\u6210: orderNo={}", (Object)payParamVo.getOrderNo());
            return result;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: orderNo={}", (Object)payParamVo.getOrderNo(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/callback/payNotify"})
    public BaseResponse<String> payCallback(@RequestBody PayCallbackVo payCallbackVo) {
        try {
            logger.info("\u652f\u4ed8\u56de\u8c03: outTradeNo={}", (Object)payCallbackVo.getOutTradeNo());
            Boolean flag = this.payService.payCallback(payCallbackVo);
            if (flag.booleanValue()) {
                logger.info("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u6210\u529f: outTradeNo={}", (Object)payCallbackVo.getOutTradeNo());
                return BaseResponse.success((Object)"SUCCESS");
            }
            logger.error("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25: outTradeNo={}", (Object)payCallbackVo.getOutTradeNo());
            return BaseResponse.success((Object)"FAIL");
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5f02\u5e38: outTradeNo={}", (Object)payCallbackVo.getOutTradeNo(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/refund"})
    public BaseResponse<String> refund(@RequestBody RefundVo refundVo) {
        try {
            logger.info("\u9000\u6b3e\u8bf7\u6c42: orderNo={}, refundAmount={}", (Object)refundVo.getOrderNo(), (Object)refundVo.getPrice());
            if (refundVo.getOrderNo() == null || refundVo.getOrderNo().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (refundVo.getPrice() == null || refundVo.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
                return BaseResponse.error((String)"400", (String)"\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            Boolean flag = this.payService.refund(refundVo);
            if (flag.booleanValue()) {
                logger.info("\u9000\u6b3e\u8bf7\u6c42\u6210\u529f: orderNo={}", (Object)refundVo.getOrderNo());
                return BaseResponse.success((Object)"\u9000\u6b3e\u8bf7\u6c42\u5df2\u63d0\u4ea4");
            }
            logger.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25: orderNo={}", (Object)refundVo.getOrderNo());
            return BaseResponse.error((String)"400", (String)"\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("\u9000\u6b3e\u8bf7\u6c42\u5f02\u5e38: orderNo={}", (Object)refundVo.getOrderNo(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/refundCallback"})
    public BaseResponse<String> refundCallback(@RequestBody RefundCallbackVo refundCallbackVo) {
        try {
            logger.info("\u9000\u6b3e\u56de\u8c03: outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo());
            Boolean flag = this.payService.refundCallback(refundCallbackVo);
            if (flag.booleanValue()) {
                logger.info("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u6210\u529f: outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo());
                return BaseResponse.success((Object)"SUCCESS");
            }
            logger.error("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u5931\u8d25: outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo());
            return BaseResponse.success((Object)"FAIL");
        }
        catch (Exception e) {
            logger.error("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u5f02\u5e38: outTradeNo={}", (Object)refundCallbackVo.getOutTradeNo(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u5931\u8d25: " + e.getMessage()));
        }
    }
}

