/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.controller;

import com.chdu.ai.model.BaseResponse;
import com.chdu.ai.model.PatientOrderTodo;
import com.chdu.ai.model.PatientOrderTodoRequest;
import com.chdu.ai.service.PatientOrderTodoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/patient-order-todo"})
@CrossOrigin(origins={"*"})
public class PatientOrderTodoController {
    private static final Logger logger = LoggerFactory.getLogger(PatientOrderTodoController.class);
    @Autowired
    private PatientOrderTodoService patientOrderTodoService;

    @PostMapping
    public BaseResponse<PatientOrderTodo> create(@RequestBody PatientOrderTodo patientOrderTodo) {
        try {
            logger.info("\u521b\u5efa\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: orderType={}, sourceId={}, patientId={}", new Object[]{patientOrderTodo.getOrderType(), patientOrderTodo.getSourceId(), patientOrderTodo.getPatientId()});
            if (patientOrderTodo.getOrderType() == null || patientOrderTodo.getOrderType().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (patientOrderTodo.getSourceId() == null || patientOrderTodo.getSourceId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u6e90\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (patientOrderTodo.getPatientId() == null || patientOrderTodo.getPatientId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u60a3\u8005ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PatientOrderTodo result = this.patientOrderTodoService.create(patientOrderTodo);
            logger.info("\u521b\u5efa\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: id={}", (Object)result.getId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u521b\u5efa\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/{id}"})
    public BaseResponse<PatientOrderTodo> getById(@PathVariable Long id) {
        try {
            logger.info("\u6839\u636eID\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: id={}", (Object)id);
            PatientOrderTodo result = this.patientOrderTodoService.getById(id);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: id={}", (Object)id);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: id={}", (Object)id, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/order"})
    public BaseResponse<PatientOrderTodo> getByOrderTypeAndSourceId(@RequestParam String orderType, @RequestParam String sourceId) {
        try {
            logger.info("\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u548c\u6e90\u8ba2\u5355ID\u67e5\u8be2: orderType={}, sourceId={}", (Object)orderType, (Object)sourceId);
            PatientOrderTodo result = this.patientOrderTodoService.getByOrderTypeAndSourceId(orderType, sourceId);
            if (result == null) {
                return BaseResponse.error((String)"404", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            logger.info("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: orderType={}, sourceId={}", (Object)orderType, (Object)sourceId);
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: orderType={}, sourceId={}", new Object[]{orderType, sourceId, e});
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/patient/{patientId}"})
    public BaseResponse<List<PatientOrderTodo>> getByPatientId(@PathVariable String patientId) {
        try {
            logger.info("\u6839\u636e\u60a3\u8005ID\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: patientId={}", (Object)patientId);
            List result = this.patientOrderTodoService.getByPatientId(patientId);
            logger.info("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: patientId={}, \u6570\u91cf={}", (Object)patientId, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: patientId={}", (Object)patientId, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/patient/{patientId}/status/{status}"})
    public BaseResponse<List<PatientOrderTodo>> getByPatientIdAndStatus(@PathVariable String patientId, @PathVariable Integer status) {
        try {
            logger.info("\u6839\u636e\u60a3\u8005ID\u548c\u72b6\u6001\u67e5\u8be2: patientId={}, status={}", (Object)patientId, (Object)status);
            List result = this.patientOrderTodoService.getByPatientIdAndStatus(patientId, status);
            logger.info("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: patientId={}, status={}, \u6570\u91cf={}", new Object[]{patientId, status, result.size()});
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: patientId={}, status={}", new Object[]{patientId, status, e});
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/status/{status}"})
    public BaseResponse<List<PatientOrderTodo>> getByStatus(@PathVariable Integer status) {
        try {
            logger.info("\u6839\u636e\u72b6\u6001\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: status={}", (Object)status);
            List result = this.patientOrderTodoService.getByStatus(status);
            logger.info("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: status={}, \u6570\u91cf={}", (Object)status, (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: status={}", (Object)status, (Object)e);
            return BaseResponse.error((String)"500", (String)("\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/query"})
    public BaseResponse<List<PatientOrderTodo>> getByCondition(@RequestBody PatientOrderTodoRequest request) {
        try {
            int page = request.getPage() != null ? request.getPage() : 0;
            int size = request.getSize() != null ? request.getSize() : 20;
            logger.info("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: patientId={}, status={}, page={}, size={}", new Object[]{request.getPatientId(), request.getStatus(), page, size});
            List result = this.patientOrderTodoService.getByCondition(request.getPatientId(), request.getStatus(), page, size);
            logger.info("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping
    public BaseResponse<List<PatientOrderTodo>> getByConditionGet(@RequestParam(required=false) String patientId, @RequestParam(required=false) Integer status, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="20") int size) {
        try {
            logger.info("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: patientId={}, status={}, page={}, size={}", new Object[]{patientId, status, page, size});
            List result = this.patientOrderTodoService.getByCondition(patientId, status, page, size);
            logger.info("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: \u6570\u91cf={}", (Object)result.size());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u5206\u9875\u67e5\u8be2\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update"})
    public BaseResponse<PatientOrderTodo> update(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PatientOrderTodo patientOrderTodo = new PatientOrderTodo();
            patientOrderTodo.setId(request.getId());
            patientOrderTodo.setOrderType(request.getOrderType());
            patientOrderTodo.setSourceId(request.getSourceId());
            patientOrderTodo.setPatientId(request.getPatientId());
            patientOrderTodo.setStatus(request.getStatus());
            boolean success = this.patientOrderTodoService.update(patientOrderTodo);
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            PatientOrderTodo result = this.patientOrderTodoService.getById(request.getId());
            logger.info("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)result);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-status"})
    public BaseResponse<String> updateStatus(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001: id={}, status={}", (Object)request.getId(), (Object)request.getStatus());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() == null) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() != 0 && request.getStatus() != 1) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u503c\u65e0\u6548\uff0c\u53ea\u80fd\u662f0\uff08\u5f85\u5904\u7406\uff09\u62161\uff08\u5df2\u5904\u7406\uff09");
            }
            boolean success = this.patientOrderTodoService.updateStatus(request.getId(), request.getStatus());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u6210\u529f: id={}, status={}", (Object)request.getId(), (Object)request.getStatus());
            return BaseResponse.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u5931\u8d25: id={}, status={}", new Object[]{request.getId(), request.getStatus(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/update-status-by-order"})
    public BaseResponse<String> updateStatusByOrderTypeAndSourceId(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u548c\u6e90\u8ba2\u5355ID\u66f4\u65b0\u72b6\u6001: orderType={}, sourceId={}, status={}", new Object[]{request.getOrderType(), request.getSourceId(), request.getStatus()});
            if (request.getOrderType() == null || request.getOrderType().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getSourceId() == null || request.getSourceId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u6e90\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() == null) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getStatus() != 0 && request.getStatus() != 1) {
                return BaseResponse.error((String)"400", (String)"\u72b6\u6001\u503c\u65e0\u6548\uff0c\u53ea\u80fd\u662f0\uff08\u5f85\u5904\u7406\uff09\u62161\uff08\u5df2\u5904\u7406\uff09");
            }
            boolean success = this.patientOrderTodoService.updateStatusByOrderTypeAndSourceId(request.getOrderType(), request.getSourceId(), request.getStatus());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u66f4\u65b0\u5931\u8d25\uff0c\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u6210\u529f: orderType={}, sourceId={}, status={}", new Object[]{request.getOrderType(), request.getSourceId(), request.getStatus()});
            return BaseResponse.success((Object)"\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u5931\u8d25: orderType={}, sourceId={}, status={}", new Object[]{request.getOrderType(), request.getSourceId(), request.getStatus(), e});
            return BaseResponse.error((String)"500", (String)("\u66f4\u65b0\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<String> deleteById(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55: id={}", (Object)request.getId());
            if (request.getId() == null) {
                return BaseResponse.error((String)"400", (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.patientOrderTodoService.deleteById(request.getId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: id={}", (Object)request.getId());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: id={}", (Object)request.getId(), (Object)e);
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete-by-order"})
    public BaseResponse<String> deleteByOrderTypeAndSourceId(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u6839\u636e\u8ba2\u5355\u7c7b\u578b\u548c\u6e90\u8ba2\u5355ID\u5220\u9664: orderType={}, sourceId={}", (Object)request.getOrderType(), (Object)request.getSourceId());
            if (request.getOrderType() == null || request.getOrderType().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (request.getSourceId() == null || request.getSourceId().isEmpty()) {
                return BaseResponse.error((String)"400", (String)"\u6e90\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean success = this.patientOrderTodoService.deleteByOrderTypeAndSourceId(request.getOrderType(), request.getSourceId());
            if (!success) {
                return BaseResponse.error((String)"400", (String)"\u5220\u9664\u5931\u8d25\uff0c\u8bb0\u5f55\u53ef\u80fd\u4e0d\u5b58\u5728");
            }
            logger.info("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u6210\u529f: orderType={}, sourceId={}", (Object)request.getOrderType(), (Object)request.getSourceId());
            return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: orderType={}, sourceId={}", new Object[]{request.getOrderType(), request.getSourceId(), e});
            return BaseResponse.error((String)"500", (String)("\u5220\u9664\u60a3\u8005\u8ba2\u5355\u5f85\u529e\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/count"})
    public BaseResponse<Long> count(@RequestBody PatientOrderTodoRequest request) {
        try {
            logger.info("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570: patientId={}, status={}", (Object)request.getPatientId(), (Object)request.getStatus());
            long count = this.patientOrderTodoService.countByCondition(request.getPatientId(), request.getStatus());
            logger.info("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u6210\u529f: count={}", (Object)count);
            return BaseResponse.success((Object)count);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/count"})
    public BaseResponse<Long> countGet(@RequestParam(required=false) String patientId, @RequestParam(required=false) Integer status) {
        try {
            logger.info("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570: patientId={}, status={}", (Object)patientId, (Object)status);
            long count = this.patientOrderTodoService.countByCondition(patientId, status);
            logger.info("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u6210\u529f: count={}", (Object)count);
            return BaseResponse.success((Object)count);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u5931\u8d25", (Throwable)e);
            return BaseResponse.error((String)"500", (String)("\u7edf\u8ba1\u60a3\u8005\u5f85\u529e\u4e8b\u9879\u603b\u6570\u5931\u8d25: " + e.getMessage()));
        }
    }
}

