/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.rong.common.RLog;
import io.rong.imkit.IExtensionClickListener;
import io.rong.imkit.IExtensionModule;
import io.rong.imkit.IExtensionProxy;
import io.rong.imkit.InputBar;
import io.rong.imkit.InputMenu;
import io.rong.imkit.R;
import io.rong.imkit.RongExtensionManager;
import io.rong.imkit.actions.IClickActions;
import io.rong.imkit.actions.IMoreClickAdapter;
import io.rong.imkit.actions.MoreClickAdapter;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.emoticon.EmoticonTabAdapter;
import io.rong.imkit.emoticon.IEmoticonClickListener;
import io.rong.imkit.emoticon.IEmoticonSettingClickListener;
import io.rong.imkit.emoticon.IEmoticonTab;
import io.rong.imkit.menu.ISubMenuItemClickListener;
import io.rong.imkit.menu.InputSubMenu;
import io.rong.imkit.plugin.CombineLocationPlugin;
import io.rong.imkit.plugin.DefaultLocationPlugin;
import io.rong.imkit.plugin.IPluginClickListener;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.plugin.ImagePlugin;
import io.rong.imkit.plugin.PluginAdapter;
import io.rong.imkit.utilities.ExtensionHistoryUtil;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.CustomServiceMode;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;

public class RongExtension
extends LinearLayout {
    private static final String TAG = "RongExtension";
    private ImageView mPSMenu;
    private View mPSDivider;
    private List<InputMenu> mInputMenuList;
    private LinearLayout mMainBar;
    private ViewGroup mExtensionBar;
    private ViewGroup mSwitchLayout;
    private ViewGroup mContainerLayout;
    private ViewGroup mPluginLayout;
    private ViewGroup mMenuContainer;
    private View mEditTextLayout;
    private EditText mEditText;
    private View mVoiceInputToggle;
    private PluginAdapter mPluginAdapter;
    private EmoticonTabAdapter mEmotionTabAdapter;
    private IMoreClickAdapter moreClickAdapter;
    private FrameLayout mSendToggle;
    private ImageView mEmoticonToggle;
    private ImageView mPluginToggle;
    private ImageView mVoiceToggle;
    private View.OnClickListener mVoiceToggleClickListener;
    private Fragment mFragment;
    private IExtensionClickListener mExtensionClickListener;
    private Conversation.ConversationType mConversationType;
    private String mTargetId;
    private List<IExtensionModule> mExtensionModuleList;
    private InputBar.Style mStyle;
    private VisibilityState lastState = VisibilityState.EXTENSION_VISIBLE;
    private boolean hasEverDrawn = false;
    private String mUserId;
    boolean isKeyBoardActive = false;
    boolean collapsed = true;
    int originalTop = 0;
    int originalBottom = 0;

    public RongExtension(Context context) {
        super(context);
        this.initView();
        this.initData();
    }

    public RongExtension(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RongExtension);
        int attr = a.getInt(R.styleable.RongExtension_RCStyle, 291);
        a.recycle();
        this.initView();
        this.initData();
        this.mStyle = InputBar.Style.getStyle(attr);
        if (this.mStyle != null) {
            this.setInputBarStyle(this.mStyle);
        }
    }

    public void onDestroy() {
        RLog.d((String)TAG, (String)"onDestroy");
        for (IExtensionModule module : this.mExtensionModuleList) {
            module.onDetachedFromExtension();
        }
        this.mExtensionClickListener = null;
        this.hideInputKeyBoard();
    }

    public void collapseExtension() {
        this.hidePluginBoard();
        this.hideEmoticonBoard();
        this.hideInputKeyBoard();
    }

    public void showSoftInput() {
        this.showInputKeyBoard();
        this.mContainerLayout.setSelected(true);
    }

    public boolean isExtensionExpanded() {
        return this.mPluginAdapter != null && this.mPluginAdapter.getVisibility() == 0 || this.mEmotionTabAdapter != null && this.mEmotionTabAdapter.getVisibility() == 0;
    }

    public void setInputBarStyle(InputBar.Style style2) {
        switch (style2) {
            case STYLE_SWITCH_CONTAINER_EXTENSION: {
                this.setSCE();
                break;
            }
            case STYLE_CONTAINER: {
                this.setC();
                break;
            }
            case STYLE_CONTAINER_EXTENSION: {
                this.setCE();
                break;
            }
            case STYLE_EXTENSION_CONTAINER: {
                this.setEC();
                break;
            }
            case STYLE_SWITCH_CONTAINER: {
                this.setSC();
            }
        }
    }

    public void setConversation(Conversation.ConversationType conversationType, String targetId) {
        if (this.mConversationType == null && this.mTargetId == null) {
            this.mConversationType = conversationType;
            this.mTargetId = targetId;
            for (IExtensionModule module : this.mExtensionModuleList) {
                module.onAttachedToExtension(this);
            }
            this.initPlugins();
            this.initEmoticons();
            this.initPanelStyle();
        }
        this.mConversationType = conversationType;
        this.mTargetId = targetId;
    }

    private void initPlugins() {
        for (IExtensionModule module : this.mExtensionModuleList) {
            List<IPluginModule> pluginModules = module.getPluginModules(this.mConversationType);
            if (pluginModules == null || this.mPluginAdapter == null) continue;
            this.mPluginAdapter.addPlugins(pluginModules);
        }
        IExtensionProxy proxy = RongExtensionManager.getExtensionProxy();
        if (proxy != null && this.mPluginAdapter != null) {
            proxy.onPreLoadPlugins(this.mConversationType, this.mTargetId, this.mPluginAdapter.getPluginModules());
        }
    }

    private void initEmoticons() {
        IExtensionProxy proxy = RongExtensionManager.getExtensionProxy();
        for (IExtensionModule module : this.mExtensionModuleList) {
            List<IEmoticonTab> tabs;
            IExtensionModule handledResult = null;
            if (proxy != null) {
                handledResult = proxy.onPreLoadEmoticons(this.mConversationType, this.mTargetId, module);
                if (handledResult == null) continue;
                tabs = module.getEmoticonTabs();
                this.mEmotionTabAdapter.initTabs(tabs, module.getClass().getCanonicalName());
                continue;
            }
            tabs = module.getEmoticonTabs();
            this.mEmotionTabAdapter.initTabs(tabs, module.getClass().getCanonicalName());
        }
    }

    public void setInputMenu(List<InputMenu> inputMenuList, boolean showFirst) {
        if (inputMenuList == null || inputMenuList.size() <= 0) {
            RLog.e((String)TAG, (String)"setInputMenu no item");
            return;
        }
        this.mPSMenu.setVisibility(0);
        this.mPSDivider.setVisibility(0);
        this.mInputMenuList = inputMenuList;
        if (showFirst) {
            this.setExtensionBarVisibility(8);
            this.setMenuVisibility(0, inputMenuList);
        }
    }

    private void setExtensionBarVisibility(int visibility) {
        if (visibility == 8) {
            this.hideEmoticonBoard();
            this.hidePluginBoard();
            this.hideInputKeyBoard();
        }
        this.mExtensionBar.setVisibility(visibility);
    }

    private void setMenuVisibility(int visibility, List<InputMenu> inputMenuList) {
        if (this.mMenuContainer == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
            this.mMenuContainer = (ViewGroup)inflater.inflate(R.layout.rc_ext_menu_container, null);
            this.mMenuContainer.findViewById(R.id.rc_switch_to_keyboard).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RongExtension.this.setExtensionBarVisibility(0);
                    RongExtension.this.mMenuContainer.setVisibility(8);
                }
            });
            int i = 0;
            while (i < inputMenuList.size()) {
                final InputMenu menu = inputMenuList.get(i);
                LinearLayout rootMenu = (LinearLayout)inflater.inflate(R.layout.rc_ext_root_menu_item, null);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1, 1.0f);
                rootMenu.setLayoutParams((ViewGroup.LayoutParams)lp);
                TextView title = (TextView)rootMenu.findViewById(R.id.rc_menu_title);
                title.setText((CharSequence)menu.title);
                ImageView iv = (ImageView)rootMenu.findViewById(R.id.rc_menu_icon);
                if (menu.subMenuList != null && menu.subMenuList.size() > 0) {
                    iv.setVisibility(0);
                    iv.setImageResource(R.drawable.rc_menu_trangle);
                }
                final int rootIndex = i++;
                rootMenu.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        List<String> subMenuList = menu.subMenuList;
                        if (subMenuList != null && subMenuList.size() > 0) {
                            InputSubMenu subMenu = new InputSubMenu(RongExtension.this.getContext(), subMenuList);
                            subMenu.setOnItemClickListener(new ISubMenuItemClickListener(){

                                @Override
                                public void onClick(int index) {
                                    if (RongExtension.this.mExtensionClickListener != null) {
                                        RongExtension.this.mExtensionClickListener.onMenuClick(rootIndex, index);
                                    }
                                }
                            });
                            subMenu.showAtLocation(v);
                        } else if (RongExtension.this.mExtensionClickListener != null) {
                            RongExtension.this.mExtensionClickListener.onMenuClick(rootIndex, -1);
                        }
                    }
                });
                ViewGroup menuBar = (ViewGroup)this.mMenuContainer.findViewById(R.id.rc_menu_bar);
                menuBar.addView((View)rootMenu);
            }
            this.addView((View)this.mMenuContainer);
        }
        if (visibility == 8) {
            this.mMenuContainer.setVisibility(8);
        } else {
            this.mMenuContainer.setVisibility(0);
        }
    }

    public void setMenuVisibility(int visibility) {
        if (this.mMenuContainer != null) {
            this.mMenuContainer.setVisibility(visibility);
        }
    }

    public int getMenuVisibility() {
        if (this.mMenuContainer != null) {
            return this.mMenuContainer.getVisibility();
        }
        return 8;
    }

    public void setExtensionBarMode(CustomServiceMode mode) {
        switch (mode) {
            case CUSTOM_SERVICE_MODE_NO_SERVICE: {
                this.setC();
                break;
            }
            case CUSTOM_SERVICE_MODE_HUMAN: 
            case CUSTOM_SERVICE_MODE_HUMAN_FIRST: {
                if (this.mStyle != null) {
                    this.setInputBarStyle(this.mStyle);
                }
                this.mVoiceToggle.setImageResource(R.drawable.rc_voice_toggle_selector);
                this.mVoiceToggle.setOnClickListener(this.mVoiceToggleClickListener);
                break;
            }
            case CUSTOM_SERVICE_MODE_ROBOT: {
                this.setC();
                break;
            }
            case CUSTOM_SERVICE_MODE_ROBOT_FIRST: {
                this.mVoiceToggle.setImageResource(R.drawable.rc_cs_admin_selector);
                this.mVoiceToggle.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (RongExtension.this.mExtensionClickListener != null) {
                            RongExtension.this.mExtensionClickListener.onSwitchToggleClick(v, RongExtension.this.mContainerLayout);
                        }
                    }
                });
                this.setSC();
            }
        }
    }

    public EditText getInputEditText() {
        return this.mEditText;
    }

    public void refreshEmoticonTabIcon(IEmoticonTab tab, Drawable icon) {
        if (icon != null && this.mEmotionTabAdapter != null && tab != null) {
            this.mEmotionTabAdapter.refreshTabIcon(tab, icon);
        }
    }

    public void addPlugin(IPluginModule pluginModule) {
        if (pluginModule != null) {
            this.mPluginAdapter.addPlugin(pluginModule);
        }
    }

    public void removePlugin(IPluginModule pluginModule) {
        if (pluginModule != null) {
            this.mPluginAdapter.removePlugin(pluginModule);
        }
    }

    public List<IPluginModule> getPluginModules() {
        return this.mPluginAdapter.getPluginModules();
    }

    public void addPluginPager(View v) {
        if (null != this.mPluginAdapter) {
            this.mPluginAdapter.addPager(v);
        }
    }

    public void removePluginPager(View v) {
        if (this.mPluginAdapter != null && v != null) {
            this.mPluginAdapter.removePager(v);
        }
    }

    public boolean addEmoticonTab(int index, IEmoticonTab tab, String tag) {
        if (this.mEmotionTabAdapter != null && tab != null && !TextUtils.isEmpty((CharSequence)tag)) {
            return this.mEmotionTabAdapter.addTab(index, tab, tag);
        }
        RLog.e((String)TAG, (String)"addEmoticonTab Failure");
        return false;
    }

    public void addEmoticonTab(IEmoticonTab tab, String tag) {
        if (this.mEmotionTabAdapter != null && tab != null && !TextUtils.isEmpty((CharSequence)tag)) {
            this.mEmotionTabAdapter.addTab(tab, tag);
        }
    }

    public List<IEmoticonTab> getEmoticonTabs(String tag) {
        if (this.mEmotionTabAdapter != null && !TextUtils.isEmpty((CharSequence)tag)) {
            return this.mEmotionTabAdapter.getTagTabs(tag);
        }
        return null;
    }

    public int getEmoticonTabIndex(String tag) {
        if (this.mEmotionTabAdapter != null && !TextUtils.isEmpty((CharSequence)tag)) {
            return this.mEmotionTabAdapter.getTagTabIndex(tag);
        }
        return -1;
    }

    public boolean removeEmoticonTab(IEmoticonTab tab, String tag) {
        boolean result = false;
        if (this.mEmotionTabAdapter != null && tab != null && !TextUtils.isEmpty((CharSequence)tag)) {
            result = this.mEmotionTabAdapter.removeTab(tab, tag);
        }
        return result;
    }

    public void setCurrentEmoticonTab(IEmoticonTab tab, String tag) {
        if (this.mEmotionTabAdapter != null && tab != null && !TextUtils.isEmpty((CharSequence)tag)) {
            this.mEmotionTabAdapter.setCurrentTab(tab, tag);
        }
    }

    public void setEmoticonTabBarEnable(boolean enable) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.setTabViewEnable(enable);
        }
    }

    public void setEmoticonTabBarAddEnable(boolean enable) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.setAddEnable(enable);
        }
    }

    public void setEmoticonTabBarAddClickListener(IEmoticonClickListener listener) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.setOnEmoticonClickListener(listener);
        }
    }

    public void setEmoticonTabBarSettingEnable(boolean enable) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.setSettingEnable(enable);
        }
    }

    public void setEmoticonTabBarSettingClickListener(IEmoticonSettingClickListener listener) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.setOnEmoticonSettingClickListener(listener);
        }
    }

    public void addEmoticonExtraTab(Context context, Drawable drawable2, View.OnClickListener clickListener) {
        if (this.mEmotionTabAdapter != null) {
            this.mEmotionTabAdapter.addExtraTab(context, drawable2, clickListener);
        }
    }

    public void setFragment(Fragment fragment) {
        this.mFragment = fragment;
    }

    public Fragment getFragment() {
        return this.mFragment;
    }

    public Conversation.ConversationType getConversationType() {
        return this.mConversationType;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public void setExtensionClickListener(IExtensionClickListener clickListener) {
        this.mExtensionClickListener = clickListener;
    }

    public void onActivityPluginResult(int requestCode, int resultCode, Intent data) {
        int position = (requestCode >> 8) - 1;
        int reqCode = requestCode & 0xFF;
        IPluginModule pluginModule = this.mPluginAdapter.getPluginModule(position);
        if (pluginModule != null) {
            if (this.mExtensionClickListener != null && resultCode == -1) {
                if (pluginModule instanceof ImagePlugin) {
                    boolean sendOrigin = data.getBooleanExtra("sendOrigin", false);
                    String mediaList = data.getStringExtra("android.intent.extra.RETURN_RESULT");
                    Gson gson = new Gson();
                    Type entityType = new TypeToken<LinkedHashMap<String, Integer>>(){}.getType();
                    LinkedHashMap mLinkedHashMap = (LinkedHashMap)gson.fromJson(mediaList, entityType);
                    this.mExtensionClickListener.onImageResult(mLinkedHashMap, sendOrigin);
                } else if (pluginModule instanceof DefaultLocationPlugin || pluginModule instanceof CombineLocationPlugin) {
                    double lat = data.getDoubleExtra("lat", 0.0);
                    double lng = data.getDoubleExtra("lng", 0.0);
                    String poi = data.getStringExtra("poi");
                    String thumb = data.getStringExtra("thumb");
                    this.mExtensionClickListener.onLocationResult(lat, lng, poi, Uri.parse((String)thumb));
                }
            }
            pluginModule.onActivityResult(reqCode, resultCode, data);
        }
    }

    public boolean onRequestPermissionResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        int position = (requestCode >> 8) - 1;
        int reqCode = requestCode & 0xFF;
        IPluginModule pluginModule = this.mPluginAdapter.getPluginModule(position);
        if (pluginModule instanceof IPluginRequestPermissionResultCallback) {
            return ((IPluginRequestPermissionResultCallback)((Object)pluginModule)).onRequestPermissionResult(this.mFragment, this, reqCode, permissions, grantResults);
        }
        return false;
    }

    public void startActivityForPluginResult(Intent intent, int requestCode, IPluginModule pluginModule) {
        if ((requestCode & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("requestCode must less than 256.");
        }
        int position = this.mPluginAdapter.getPluginPosition(pluginModule);
        this.mFragment.startActivityForResult(intent, (position + 1 << 8) + (requestCode & 0xFF));
    }

    public void requestPermissionForPluginResult(String[] permissions, int requestCode, IPluginModule pluginModule) {
        if ((requestCode & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("requestCode must less than 256");
        }
        int position = this.mPluginAdapter.getPluginPosition(pluginModule);
        int req = (position + 1 << 8) + (requestCode & 0xFF);
        PermissionCheckUtil.requestPermissions(this.mFragment, permissions, req);
    }

    private void initData() {
        this.mExtensionModuleList = RongExtensionManager.getInstance().getExtensionModules();
        this.mPluginAdapter = new PluginAdapter();
        this.mPluginAdapter.setOnPluginClickListener(new IPluginClickListener(){

            @Override
            public void onClick(IPluginModule pluginModule, int position) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onPluginClicked(pluginModule, position);
                }
                pluginModule.onClick(RongExtension.this.mFragment, RongExtension.this);
            }
        });
        this.mEmotionTabAdapter = new EmoticonTabAdapter();
        this.moreClickAdapter = new MoreClickAdapter();
        this.mUserId = RongIMClient.getInstance().getCurrentUserId();
        try {
            boolean enable = this.getResources().getBoolean(this.getResources().getIdentifier("rc_extension_history", "bool", this.getContext().getPackageName()));
            ExtensionHistoryUtil.setEnableHistory(enable);
            ExtensionHistoryUtil.addExceptConversationType(Conversation.ConversationType.CUSTOMER_SERVICE);
        }
        catch (Resources.NotFoundException e) {
            RLog.i((String)TAG, (String)"rc_extension_history not configure in rc_configuration.xml");
        }
    }

    private void initView() {
        this.setOrientation(1);
        this.setBackgroundColor(this.getContext().getResources().getColor(R.color.rc_extension_normal));
        this.mExtensionBar = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rc_ext_extension_bar, null);
        this.mMainBar = (LinearLayout)this.mExtensionBar.findViewById(R.id.ext_main_bar);
        this.mSwitchLayout = (ViewGroup)this.mExtensionBar.findViewById(R.id.rc_switch_layout);
        this.mContainerLayout = (ViewGroup)this.mExtensionBar.findViewById(R.id.rc_container_layout);
        this.mPluginLayout = (ViewGroup)this.mExtensionBar.findViewById(R.id.rc_plugin_layout);
        this.mEditTextLayout = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rc_ext_input_edit_text, null);
        this.mEditTextLayout.setVisibility(0);
        this.mContainerLayout.addView(this.mEditTextLayout);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.rc_ext_voice_input, this.mContainerLayout, true);
        this.mVoiceInputToggle = this.mContainerLayout.findViewById(R.id.rc_audio_input_toggle);
        this.mVoiceInputToggle.setVisibility(8);
        this.mEditText = (EditText)this.mExtensionBar.findViewById(R.id.rc_edit_text);
        this.mSendToggle = (FrameLayout)this.mExtensionBar.findViewById(R.id.rc_send_toggle);
        this.mPluginToggle = (ImageView)this.mExtensionBar.findViewById(R.id.rc_plugin_toggle);
        this.mEditText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (0 == event.getAction()) {
                    if (RongExtension.this.mExtensionClickListener != null) {
                        RongExtension.this.mExtensionClickListener.onEditTextClick(RongExtension.this.mEditText);
                    }
                    if (Build.BRAND.toLowerCase().contains("meizu")) {
                        RongExtension.this.mEditText.requestFocus();
                        RongExtension.this.mEmoticonToggle.setSelected(false);
                        RongExtension.this.isKeyBoardActive = true;
                    } else {
                        RongExtension.this.showInputKeyBoard();
                    }
                    RongExtension.this.mContainerLayout.setSelected(true);
                    RongExtension.this.hidePluginBoard();
                    RongExtension.this.hideEmoticonBoard();
                }
                return false;
            }
        });
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus && !TextUtils.isEmpty((CharSequence)RongExtension.this.mEditText.getText())) {
                    RongExtension.this.mSendToggle.setVisibility(0);
                    RongExtension.this.mPluginLayout.setVisibility(8);
                }
            }
        });
        this.mEditText.addTextChangedListener(new TextWatcher(){
            private int start;
            private int count;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.beforeTextChanged(s, start, count, after);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                this.start = start;
                this.count = count;
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onTextChanged(s, start, before, count);
                }
                if (RongExtension.this.mVoiceInputToggle.getVisibility() == 0) {
                    RongExtension.this.mSendToggle.setVisibility(8);
                    RongExtension.this.mPluginLayout.setVisibility(0);
                } else if (s == null || s.length() == 0) {
                    RongExtension.this.mSendToggle.setVisibility(8);
                    RongExtension.this.mPluginLayout.setVisibility(0);
                } else {
                    RongExtension.this.mSendToggle.setVisibility(0);
                    RongExtension.this.mPluginLayout.setVisibility(8);
                }
            }

            public void afterTextChanged(Editable s) {
                if (AndroidEmoji.isEmoji(s.subSequence(this.start, this.start + this.count).toString())) {
                    RongExtension.this.mEditText.removeTextChangedListener((TextWatcher)this);
                    String resultStr = AndroidEmoji.replaceEmojiWithText(s.toString());
                    RongExtension.this.mEditText.setText(AndroidEmoji.ensure(resultStr), TextView.BufferType.SPANNABLE);
                    RongExtension.this.mEditText.setSelection(RongExtension.this.mEditText.getText().length());
                    RongExtension.this.mEditText.addTextChangedListener((TextWatcher)this);
                }
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.afterTextChanged(s);
                }
            }
        });
        this.mEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return RongExtension.this.mExtensionClickListener != null && RongExtension.this.mExtensionClickListener.onKey((View)RongExtension.this.mEditText, keyCode, event);
            }
        });
        this.mEditText.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (RongExtension.this.mEditText.getText().length() > 0 && RongExtension.this.mEditText.isFocused() && !RongExtension.this.hasEverDrawn) {
                    Rect rect = new Rect();
                    RongExtension.this.mEditText.getWindowVisibleDisplayFrame(rect);
                    int keypadHeight = RongExtension.this.mEditText.getRootView().getHeight() - rect.bottom;
                    int inputbarHeight = (int)RongExtension.this.mEditText.getContext().getResources().getDimension(R.dimen.rc_extension_bar_min_height);
                    if (keypadHeight > inputbarHeight * 2) {
                        RongExtension.this.hasEverDrawn = true;
                    }
                    if (RongExtension.this.mExtensionClickListener != null) {
                        RongExtension.this.mExtensionClickListener.onEditTextClick(RongExtension.this.mEditText);
                    }
                    RongExtension.this.showInputKeyBoard();
                    RongExtension.this.mContainerLayout.setSelected(true);
                    RongExtension.this.hidePluginBoard();
                    RongExtension.this.hideEmoticonBoard();
                }
            }
        });
        this.mVoiceToggle = (ImageView)this.mExtensionBar.findViewById(R.id.rc_voice_toggle);
        this.mVoiceToggleClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onSwitchToggleClick(v, RongExtension.this.mContainerLayout);
                }
                if (RongExtension.this.mVoiceInputToggle.getVisibility() == 8) {
                    RongExtension.this.mEditTextLayout.setVisibility(8);
                    RongExtension.this.mSendToggle.setVisibility(8);
                    RongExtension.this.mPluginLayout.setVisibility(0);
                    RongExtension.this.hideInputKeyBoard();
                    RongExtension.this.showVoiceInputToggle();
                    RongExtension.this.mContainerLayout.setClickable(true);
                    RongExtension.this.mContainerLayout.setSelected(false);
                } else {
                    RongExtension.this.mEditTextLayout.setVisibility(0);
                    RongExtension.this.hideVoiceInputToggle();
                    RongExtension.this.mEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
                    if (RongExtension.this.mEditText.getText().length() > 0) {
                        RongExtension.this.mSendToggle.setVisibility(0);
                        RongExtension.this.mPluginLayout.setVisibility(8);
                    } else {
                        RongExtension.this.mSendToggle.setVisibility(8);
                        RongExtension.this.mPluginLayout.setVisibility(0);
                    }
                    RongExtension.this.showInputKeyBoard();
                    RongExtension.this.mContainerLayout.setSelected(true);
                }
                RongExtension.this.hidePluginBoard();
                RongExtension.this.hideEmoticonBoard();
            }
        };
        this.mVoiceToggle.setOnClickListener(this.mVoiceToggleClickListener);
        this.mVoiceInputToggle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onVoiceInputToggleTouch(v, event);
                }
                return false;
            }
        });
        this.mSendToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String text = RongExtension.this.mEditText.getText().toString();
                RongExtension.this.mEditText.setText((CharSequence)"");
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onSendToggleClick(v, text);
                }
            }
        });
        this.mPluginToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onPluginToggleClick(v, (ViewGroup)RongExtension.this);
                }
                RongExtension.this.setPluginBoard();
            }
        });
        this.mEmoticonToggle = (ImageView)this.mExtensionBar.findViewById(R.id.rc_emoticon_toggle);
        this.mEmoticonToggle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RongExtension.this.mExtensionClickListener != null) {
                    RongExtension.this.mExtensionClickListener.onEmoticonToggleClick(v, (ViewGroup)RongExtension.this);
                }
                if (RongExtension.this.isKeyBoardActive()) {
                    RongExtension.this.hideInputKeyBoard();
                    RongExtension.this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            RongExtension.this.setEmoticonBoard();
                        }
                    }, 200L);
                } else {
                    RongExtension.this.setEmoticonBoard();
                }
                RongExtension.this.hidePluginBoard();
            }
        });
        this.mPSMenu = (ImageView)this.mExtensionBar.findViewById(R.id.rc_switch_to_menu);
        this.mPSMenu.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RongExtension.this.setExtensionBarVisibility(8);
                RongExtension.this.setMenuVisibility(0, RongExtension.this.mInputMenuList);
            }
        });
        this.mPSDivider = this.mExtensionBar.findViewById(R.id.rc_switch_divider);
        this.addView((View)this.mExtensionBar);
    }

    public void showMoreActionLayout(List<IClickActions> actions) {
        this.lastState = this.getMenuVisibility() == 0 ? VisibilityState.MENUCONTAINER_VISIBLE : VisibilityState.EXTENSION_VISIBLE;
        this.setExtensionBarVisibility(8);
        this.setMenuVisibility(8);
        this.moreClickAdapter.bindView((ViewGroup)this, this.mFragment, actions);
    }

    public void hideMoreActionLayout() {
        if (this.getConversationType().equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE) || this.getConversationType().equals((Object)Conversation.ConversationType.PUBLIC_SERVICE)) {
            if (this.mInputMenuList != null) {
                if (this.lastState == VisibilityState.MENUCONTAINER_VISIBLE) {
                    this.setExtensionBarVisibility(8);
                    this.setMenuVisibility(0);
                } else {
                    this.setExtensionBarVisibility(0);
                    this.mPSMenu.setVisibility(0);
                    this.mPSDivider.setVisibility(0);
                }
            } else {
                this.setExtensionBarVisibility(0);
            }
        } else {
            this.setExtensionBarVisibility(0);
        }
        this.moreClickAdapter.hideMoreActionLayout();
    }

    public void setMoreActionEnable(boolean enable) {
        this.moreClickAdapter.setMoreActionEnable(enable);
    }

    public boolean isMoreActionShown() {
        return this.moreClickAdapter.isMoreActionShown();
    }

    private void hideVoiceInputToggle() {
        this.mVoiceToggle.setImageResource(R.drawable.rc_voice_toggle_selector);
        this.mVoiceInputToggle.setVisibility(8);
        String saveId = DeviceUtils.ShortMD5((String[])new String[]{this.mUserId, this.mTargetId, this.mConversationType.getName()});
        ExtensionHistoryUtil.setExtensionBarState(this.getContext(), saveId, this.mConversationType, ExtensionHistoryUtil.ExtensionBarState.NORMAL);
    }

    private void showVoiceInputToggle() {
        this.mVoiceInputToggle.setVisibility(0);
        this.mVoiceToggle.setImageResource(R.drawable.rc_keyboard_selector);
        String saveId = DeviceUtils.ShortMD5((String[])new String[]{this.mUserId, this.mTargetId, this.mConversationType.getName()});
        ExtensionHistoryUtil.setExtensionBarState(this.getContext(), saveId, this.mConversationType, ExtensionHistoryUtil.ExtensionBarState.VOICE);
    }

    private void hideEmoticonBoard() {
        this.mEmotionTabAdapter.setVisibility(8);
        this.mEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
    }

    private void setEmoticonBoard() {
        if (this.mEmotionTabAdapter.isInitialized()) {
            if (this.mEmotionTabAdapter.getVisibility() == 0) {
                this.mEmotionTabAdapter.setVisibility(8);
                this.mEmoticonToggle.setSelected(false);
                this.mEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
                this.showInputKeyBoard();
            } else {
                this.mEmotionTabAdapter.setVisibility(0);
                this.mContainerLayout.setSelected(true);
                this.mEmoticonToggle.setSelected(true);
                this.mEmoticonToggle.setImageResource(R.drawable.rc_keyboard_selector);
            }
        } else {
            this.mEmotionTabAdapter.bindView((ViewGroup)this);
            this.mEmotionTabAdapter.setVisibility(0);
            this.mContainerLayout.setSelected(true);
            this.mEmoticonToggle.setSelected(true);
            this.mEmoticonToggle.setImageResource(R.drawable.rc_keyboard_selector);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mEditText.getText())) {
            this.mSendToggle.setVisibility(0);
            this.mPluginLayout.setVisibility(8);
        }
    }

    private void hidePluginBoard() {
        if (this.mPluginAdapter != null) {
            this.mPluginAdapter.setVisibility(8);
            View pager = this.mPluginAdapter.getPager();
            this.mPluginAdapter.removePager(pager);
        }
    }

    private void setPluginBoard() {
        if (this.mPluginAdapter.isInitialized()) {
            if (this.mPluginAdapter.getVisibility() == 0) {
                View pager = this.mPluginAdapter.getPager();
                if (pager != null) {
                    pager.setVisibility(pager.getVisibility() == 8 ? 0 : 8);
                } else {
                    this.mPluginAdapter.setVisibility(8);
                    this.mContainerLayout.setSelected(true);
                    this.showInputKeyBoard();
                }
            } else {
                this.mEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
                if (this.isKeyBoardActive()) {
                    this.getHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            RongExtension.this.mPluginAdapter.setVisibility(0);
                        }
                    }, 200L);
                } else {
                    this.mPluginAdapter.setVisibility(0);
                }
                this.hideInputKeyBoard();
                this.hideEmoticonBoard();
                this.mContainerLayout.setSelected(false);
            }
        } else {
            this.mEmoticonToggle.setImageResource(R.drawable.rc_emotion_toggle_selector);
            this.mPluginAdapter.bindView((ViewGroup)this);
            this.mPluginAdapter.setVisibility(0);
            this.mContainerLayout.setSelected(false);
            this.hideInputKeyBoard();
            this.hideEmoticonBoard();
        }
        this.hideVoiceInputToggle();
        this.mEditTextLayout.setVisibility(0);
    }

    private boolean isKeyBoardActive() {
        return this.isKeyBoardActive;
    }

    private void hideInputKeyBoard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mEditText.getWindowToken(), 0);
        this.mEditText.clearFocus();
        this.isKeyBoardActive = false;
    }

    private void showInputKeyBoard() {
        this.mEditText.requestFocus();
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.showSoftInput((View)this.mEditText, 0);
        this.mEmoticonToggle.setSelected(false);
        this.isKeyBoardActive = true;
    }

    private void setSCE() {
        this.mSwitchLayout.setVisibility(0);
        if (this.mSendToggle.getVisibility() == 0) {
            this.mPluginLayout.setVisibility(8);
        } else {
            this.mPluginLayout.setVisibility(0);
        }
        this.mMainBar.removeAllViews();
        this.mMainBar.addView((View)this.mSwitchLayout);
        this.mMainBar.addView((View)this.mContainerLayout);
        this.mMainBar.addView((View)this.mPluginLayout);
    }

    private void setSC() {
        this.mSwitchLayout.setVisibility(0);
        this.mMainBar.removeAllViews();
        this.mMainBar.addView((View)this.mSwitchLayout);
        this.mMainBar.addView((View)this.mContainerLayout);
    }

    private void setCE() {
        if (this.mSendToggle.getVisibility() == 0) {
            this.mPluginLayout.setVisibility(8);
        } else {
            this.mPluginLayout.setVisibility(0);
        }
        this.mMainBar.removeAllViews();
        this.mMainBar.addView((View)this.mContainerLayout);
        this.mMainBar.addView((View)this.mPluginLayout);
    }

    private void setEC() {
        if (this.mSendToggle.getVisibility() == 0) {
            this.mPluginLayout.setVisibility(8);
        } else {
            this.mPluginLayout.setVisibility(0);
        }
        this.mMainBar.removeAllViews();
        this.mMainBar.addView((View)this.mPluginLayout);
        this.mMainBar.addView((View)this.mContainerLayout);
    }

    private void setC() {
        this.mMainBar.removeAllViews();
        this.mMainBar.addView((View)this.mContainerLayout);
    }

    private void initPanelStyle() {
        String saveId = DeviceUtils.ShortMD5((String[])new String[]{this.mUserId, this.mTargetId, this.mConversationType.getName()});
        ExtensionHistoryUtil.ExtensionBarState state = ExtensionHistoryUtil.getExtensionBarState(this.getContext(), saveId, this.mConversationType);
        if (state == ExtensionHistoryUtil.ExtensionBarState.NORMAL) {
            this.mVoiceToggle.setImageResource(R.drawable.rc_voice_toggle_selector);
            this.mEditTextLayout.setVisibility(0);
            this.mVoiceInputToggle.setVisibility(8);
        } else {
            this.mVoiceToggle.setImageResource(R.drawable.rc_keyboard_selector);
            this.mEditTextLayout.setVisibility(8);
            this.mVoiceInputToggle.setVisibility(0);
            this.mSendToggle.setVisibility(8);
            this.mPluginLayout.setVisibility(0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.originalTop != 0) {
            if (this.originalTop > t) {
                if (this.originalBottom > b && this.mExtensionClickListener != null && this.collapsed) {
                    this.collapsed = false;
                    this.mExtensionClickListener.onExtensionExpanded(this.originalBottom - t);
                } else if (this.collapsed && this.mExtensionClickListener != null) {
                    this.collapsed = false;
                    this.mExtensionClickListener.onExtensionExpanded(b - t);
                }
            } else if (!this.collapsed && this.mExtensionClickListener != null) {
                this.collapsed = true;
                this.mExtensionClickListener.onExtensionCollapsed();
            }
        }
        if (this.originalTop == 0) {
            this.originalTop = t;
            this.originalBottom = b;
        }
    }

    public void resetEditTextLayoutDrawnStatus() {
        this.hasEverDrawn = false;
    }

    public void showRequestPermissionFailedAlter(String content) {
        FragmentActivity context = this.mFragment.getActivity();
        PermissionCheckUtil.showRequestPermissionFailedAlter((Context)context, content);
    }

    static enum VisibilityState {
        EXTENSION_VISIBLE,
        MENUCONTAINER_VISIBLE;

    }
}

