/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.Event;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.CSLMessageItem;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import io.rong.message.InformationNotificationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSLeaveMessageActivity
extends RongBaseNoActionbarActivity {
    private static final String TAG = "CSLeaveMessageActivity";
    private ArrayList<EditText> mEditList = new ArrayList();
    private String mTargetId;
    private ArrayList<CSLMessageItem> mItemList;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_cs_leave_message);
        this.mTargetId = this.getIntent().getStringExtra("targetId");
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            this.mItemList = bundle.getParcelableArrayList("itemList");
        }
        TextView cancelBtn = (TextView)this.findViewById(R.id.rc_btn_cancel);
        LinearLayout container = (LinearLayout)this.findViewById(R.id.rc_content);
        this.addItemToContainer(container);
        TextView submitBtn = (TextView)this.findViewById(R.id.rc_submit_message);
        submitBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CSLeaveMessageActivity.this.isContentValid()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (EditText editText : CSLeaveMessageActivity.this.mEditList) {
                        String name = (String)editText.getTag();
                        map.put(name, editText.getText().toString());
                    }
                    RongIMClient.getInstance().leaveMessageCustomService(CSLeaveMessageActivity.this.mTargetId, map, new RongIMClient.OperationCallback(){

                        public void onSuccess() {
                            InformationNotificationMessage notificationMessage = new InformationNotificationMessage(CSLeaveMessageActivity.this.getResources().getString(R.string.rc_cs_message_submited));
                            RongIM.getInstance().insertMessage(Conversation.ConversationType.CUSTOMER_SERVICE, CSLeaveMessageActivity.this.mTargetId, RongIMClient.getInstance().getCurrentUserId(), (MessageContent)notificationMessage, null);
                            CSLeaveMessageActivity.this.finish();
                        }

                        public void onError(RongIMClient.ErrorCode errorCode) {
                        }
                    });
                }
            }
        });
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CSLeaveMessageActivity.this.hideSoftInputKeyboard();
                CSLeaveMessageActivity.this.finish();
            }
        });
        EventBus.getDefault().register((Object)this);
    }

    private void addItemToContainer(LinearLayout parent) {
        if (this.mItemList == null) {
            return;
        }
        for (int i = 0; i < this.mItemList.size(); ++i) {
            LinearLayout.LayoutParams params;
            CSLMessageItem item = this.mItemList.get(i);
            LinearLayout itemContainer = new LinearLayout((Context)this);
            if (item.getType().equals("text")) {
                params = new LinearLayout.LayoutParams(-1, RongUtils.dip2px(45.0f));
                itemContainer.setOrientation(0);
            } else {
                params = new LinearLayout.LayoutParams(-1, -2);
                itemContainer.setOrientation(1);
            }
            if (i > 0) {
                params.setMargins(0, RongUtils.dip2px(1.0f), 0, 0);
            }
            itemContainer.setBackgroundColor(-1);
            itemContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            TextView view = new TextView((Context)this);
            params = new LinearLayout.LayoutParams(-2, RongUtils.dip2px(45.0f));
            params.setMargins(RongUtils.dip2px(14.0f), 0, 0, 0);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            view.setTextColor(this.getResources().getColor(R.color.rc_text_color_primary));
            view.setTextSize(16.0f);
            view.setGravity(16);
            view.setText((CharSequence)item.getTitle());
            itemContainer.addView((View)view);
            EditText editText = new EditText((Context)this);
            params = new LinearLayout.LayoutParams(-1, -1);
            editText.setHint((CharSequence)item.getDefaultText());
            editText.setBackgroundColor(0);
            if (item.getType().equals("text")) {
                params.setMargins(RongUtils.dip2px(10.0f), 0, RongUtils.dip2px(14.0f), 0);
                editText.setGravity(19);
                editText.setMaxLines(1);
                editText.setMaxEms(20);
                editText.setSingleLine();
            } else {
                params.setMargins(0, 0, 0, 0);
                editText.setGravity(51);
                editText.setPadding(RongUtils.dip2px(14.0f), 0, 0, 0);
                editText.setInputType(131073);
                editText.setMinLines(3);
                editText.setMaxEms(item.getMax());
                editText.setVerticalScrollBarEnabled(true);
                editText.setMaxLines(3);
                editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(item.getMax())});
            }
            editText.setTextSize(0, this.getResources().getDimension(R.dimen.rc_conversation_item_name_size));
            editText.setTextColor(this.getResources().getColor(R.color.rc_text_color_primary));
            editText.setTag((Object)item.getName());
            editText.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mEditList.add(editText);
            itemContainer.addView((View)editText);
            parent.addView((View)itemContainer);
        }
    }

    public boolean isContentValid() {
        for (EditText editText : this.mEditList) {
            String tag = (String)editText.getTag();
            if (tag == null) {
                RLog.i((String)TAG, (String)"tag is null !");
                return false;
            }
            CSLMessageItem config = this.getItemConfig(tag);
            if (config == null) {
                RLog.i((String)TAG, (String)"config is null !");
                return false;
            }
            if (config.isRequired() && TextUtils.isEmpty((CharSequence)editText.getText().toString())) {
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)((CharSequence)config.getMessage().get(CSLMessageItem.RemindType.EMPTY.getName())), (int)0).show();
                return false;
            }
            if (config.getVerification() != null && editText.getText().length() > 0) {
                boolean isValid = true;
                if (config.getVerification().equals("phone")) {
                    isValid = this.isMobile(editText.getText().toString());
                } else if (config.getVerification().equals("email")) {
                    isValid = this.isEmail(editText.getText().toString());
                }
                if (isValid) continue;
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)((CharSequence)config.getMessage().get(CSLMessageItem.RemindType.WRONG_FORMAT.getName())), (int)0).show();
                return false;
            }
            if (config.getMax() <= 0 || editText.length() <= config.getMax()) continue;
            Toast.makeText((Context)this.getBaseContext(), (CharSequence)((CharSequence)config.getMessage().get(CSLMessageItem.RemindType.OVER_LENGTH.getName())), (int)0).show();
            return false;
        }
        return true;
    }

    public CSLMessageItem getItemConfig(String name) {
        for (CSLMessageItem item : this.mItemList) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    private boolean isMobile(String phoneNumber) {
        String MOBLIE_PHONE_PATTERN = "^((13[0-9])|(15[0-9])|(18[0-9])|(14[7])|(17[0|6|7|8]))\\d{8}$";
        Pattern p = Pattern.compile(MOBLIE_PHONE_PATTERN);
        Matcher m = p.matcher(phoneNumber);
        return m.matches();
    }

    public boolean isEmail(String email) {
        String str = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public final void onEventMainThread(final Event.CSTerminateEvent event) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(false);
        final AlertDialog alertDialog = builder.create();
        alertDialog.show();
        Window window = alertDialog.getWindow();
        if (window != null) {
            window.setContentView(R.layout.rc_cs_alert_warning);
            TextView tv = (TextView)window.findViewById(R.id.rc_cs_msg);
            tv.setText((CharSequence)event.getText());
            window.findViewById(R.id.rc_btn_ok).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    alertDialog.dismiss();
                    CSLeaveMessageActivity.this.hideSoftInputKeyboard();
                    event.getActivity().finish();
                    CSLeaveMessageActivity.this.finish();
                }
            });
        }
    }

    private void hideSoftInputKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm.isActive() && this.getCurrentFocus() != null && this.getCurrentFocus().getWindowToken() != null) {
            imm.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }
}

