/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.activity;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongBaseActivity;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.Event;
import io.rong.imkit.tools.RongWebviewActivity;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.utils.FileTypeUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.FileInfo;
import io.rong.imlib.model.Message;
import io.rong.message.FileMessage;
import io.rong.message.MediaMessageContent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class FilePreviewActivity
extends RongBaseActivity
implements View.OnClickListener {
    private static final String TAG = "FilePreviewActivity";
    public static final int NOT_DOWNLOAD = 0;
    public static final int DOWNLOADED = 1;
    public static final int DOWNLOADING = 2;
    public static final int DELETED = 3;
    public static final int DOWNLOAD_ERROR = 4;
    public static final int DOWNLOAD_CANCEL = 5;
    public static final int DOWNLOAD_SUCCESS = 6;
    public static final int DOWNLOAD_PAUSE = 7;
    public static final int ON_SUCCESS_CALLBACK = 100;
    public static final int ON_PROGRESS_CALLBACK = 101;
    public static final int ON_CANCEL_CALLBACK = 102;
    public static final int ON_ERROR_CALLBACK = 103;
    public static final int REQUEST_CODE_PERMISSION = 104;
    private static final String TXT_FILE = ".txt";
    private static final String APK_FILE = ".apk";
    private ImageView mFileTypeImage;
    private TextView mFileNameView;
    private TextView mFileSizeView;
    private Button mFileButton;
    private ProgressBar mFileDownloadProgressBar;
    private LinearLayout mDownloadProgressView;
    protected TextView mDownloadProgressTextView;
    protected View mCancel;
    protected FileDownloadInfo mFileDownloadInfo;
    protected FileMessage mFileMessage;
    protected Message mMessage;
    private int mProgress;
    private String mFileName;
    private long mFileSize;
    private List<Toast> mToasts;
    private FrameLayout contentContainer;
    private SupportResumeStatus supportResumeTransfer = SupportResumeStatus.NOT_SET;
    private FileInfo info = null;
    private String pausedPath;
    private long downloadedFileLength;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.rc_ac_file_download);
        this.mFileMessage = (FileMessage)this.getIntent().getParcelableExtra("FileMessage");
        this.mMessage = (Message)this.getIntent().getParcelableExtra("Message");
        this.mProgress = this.getIntent().getIntExtra("Progress", 0);
        this.initView();
        this.initData();
        this.getFileMessageStatus();
    }

    private void getFileMessageStatus() {
        File file;
        Uri fileUrl = this.mFileMessage.getFileUrl();
        Uri localUri = this.mFileMessage.getLocalPath();
        boolean isLocalPathExist = false;
        if (localUri != null && localUri.toString().length() > 7 && (file = new File(this.mFileMessage.getLocalPath().toString().substring(7))).exists()) {
            isLocalPathExist = true;
        }
        if (!isLocalPathExist && fileUrl != null && !TextUtils.isEmpty((CharSequence)fileUrl.toString())) {
            String url = fileUrl.toString();
            this.pausedPath = FileUtils.getTempFilePath((Context)this, (int)this.mMessage.getMessageId());
            RongIM.getInstance().supportResumeBrokenTransfer(url, new RongIMClient.ResultCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean) {
                    FilePreviewActivity.this.supportResumeTransfer = aBoolean != false ? SupportResumeStatus.SUPPORT : SupportResumeStatus.NOT_SUPPORT;
                    if (FilePreviewActivity.this.supportResumeTransfer == SupportResumeStatus.NOT_SUPPORT) {
                        FilePreviewActivity.this.setViewStatus();
                        FilePreviewActivity.this.getFileDownloadInfo();
                    } else {
                        FilePreviewActivity.this.getFileDownloadInfoInSubThread();
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                    FilePreviewActivity.this.setViewStatus();
                    FilePreviewActivity.this.getFileDownloadInfo();
                }
            });
        } else {
            this.setViewStatus();
            this.getFileDownloadInfo();
        }
    }

    @Override
    public void setContentView(int resId) {
        this.contentContainer.removeAllViews();
        View view = LayoutInflater.from((Context)this).inflate(resId, null);
        this.contentContainer.addView(view);
    }

    private void initData() {
        this.mToasts = new ArrayList<Toast>();
        this.mFileName = this.mFileMessage.getName();
        this.mFileTypeImage.setImageResource(FileTypeUtils.fileTypeImageId(this.mFileName));
        this.mFileNameView.setText((CharSequence)this.mFileName);
        this.mFileSize = this.mFileMessage.getSize();
        this.mFileSizeView.setText((CharSequence)FileTypeUtils.formatFileSize(this.mFileSize));
        this.mFileDownloadInfo = new FileDownloadInfo();
        this.mFileButton.setOnClickListener((View.OnClickListener)this);
        this.mCancel.setOnClickListener((View.OnClickListener)this);
        RongContext.getInstance().getEventBus().register((Object)this);
    }

    private void initView() {
        this.contentContainer = (FrameLayout)this.findViewById(R.id.rc_ac_ll_content_container);
        View view = LayoutInflater.from((Context)this).inflate(R.layout.rc_ac_file_preview_content, null);
        this.contentContainer.addView(view);
        this.mFileTypeImage = (ImageView)this.findViewById(R.id.rc_ac_iv_file_type_image);
        this.mFileNameView = (TextView)this.findViewById(R.id.rc_ac_tv_file_name);
        this.mFileSizeView = (TextView)this.findViewById(R.id.rc_ac_tv_file_size);
        this.mFileButton = (Button)this.findViewById(R.id.rc_ac_btn_download_button);
        this.mDownloadProgressView = (LinearLayout)this.findViewById(R.id.rc_ac_ll_progress_view);
        this.mCancel = this.findViewById(R.id.rc_btn_cancel);
        this.mFileDownloadProgressBar = (ProgressBar)this.findViewById(R.id.rc_ac_pb_download_progress);
        this.mDownloadProgressTextView = (TextView)this.findViewById(R.id.rc_ac_tv_download_progress);
        TextView title = (TextView)this.findViewById(R.id.rc_action_bar_title);
        title.setText(R.string.rc_ac_file_download_preview);
        this.onCreateActionbar(new RongBaseActivity.ActionBar());
    }

    private void setViewStatus() {
        if (this.mMessage.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            if (this.mProgress == 0) {
                this.mDownloadProgressView.setVisibility(8);
                this.mFileButton.setVisibility(0);
            } else if (this.mProgress == 100) {
                this.mDownloadProgressView.setVisibility(8);
                this.mFileButton.setVisibility(0);
            } else {
                this.mFileButton.setVisibility(8);
                this.mDownloadProgressView.setVisibility(0);
                this.mFileDownloadProgressBar.setProgress(this.mProgress);
            }
        }
    }

    private void setViewStatusForResumeTransfer() {
        this.mFileButton.setVisibility(0);
        this.mDownloadProgressTextView.setVisibility(8);
        this.mCancel.setVisibility(8);
    }

    public void onClick(View v) {
        if (v == this.mFileButton) {
            switch (this.mFileDownloadInfo.state) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    this.startToDownload();
                    break;
                }
                case 1: 
                case 6: {
                    Uri uri = this.mFileMessage.getLocalPath();
                    String path = uri.toString();
                    if (path.toLowerCase().startsWith("file://")) {
                        path = path.substring(7);
                    }
                    this.openFile(this.mFileName, path);
                    break;
                }
                case 2: {
                    if (this.supportResumeTransfer != SupportResumeStatus.SUPPORT) break;
                    this.mFileDownloadInfo.state = 7;
                    RongIM.getInstance().pauseDownloadMediaMessage(this.mMessage, null);
                    this.info = this.getFileInfo();
                    this.downloadedFileLength = this.info != null ? this.info.getFinished() : (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
                    this.mFileSizeView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_pause, new Object[]{FileTypeUtils.formatFileSize(this.downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
                    this.mFileButton.setText((CharSequence)this.getResources().getString(R.string.rc_ac_file_preview_download_resume));
                    break;
                }
                case 7: {
                    if (RongIM.getInstance().getCurrentConnectionStatus() == RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) {
                        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_notice_network_unavailable), (int)0).show();
                        return;
                    }
                    if (this.supportResumeTransfer != SupportResumeStatus.SUPPORT) break;
                    this.mFileDownloadInfo.state = 2;
                    this.downloadFile();
                    if (this.mFileDownloadInfo.state == 4 || this.mFileDownloadInfo.state == 5) break;
                    this.mFileButton.setText((CharSequence)this.getResources().getString(R.string.rc_cancel));
                }
            }
        } else if (v == this.mCancel && this.mFileDownloadInfo.state != 5) {
            this.mFileDownloadInfo.state = 5;
            this.refreshDownloadState();
            RongIM.getInstance().cancelDownloadMediaMessage(this.mMessage, null);
        }
    }

    private void startToDownload() {
        if (!(this.mMessage.getContent() instanceof MediaMessageContent)) {
            this.refreshDownloadState();
            return;
        }
        this.resetMediaMessageLocalPath();
        if (RongIM.getInstance().getCurrentConnectionStatus() == RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_notice_network_unavailable), (int)0).show();
            return;
        }
        MediaMessageContent mediaMessage = (MediaMessageContent)this.mMessage.getContent();
        if (mediaMessage != null && (mediaMessage.getMediaUrl() == null || TextUtils.isEmpty((CharSequence)mediaMessage.getMediaUrl().toString()))) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_ac_file_url_error), (int)0).show();
            this.finish();
            return;
        }
        if (this.supportResumeTransfer == SupportResumeStatus.NOT_SET) {
            String url = ((FileMessage)this.mMessage.getContent()).getFileUrl().toString();
            RongIM.getInstance().supportResumeBrokenTransfer(url, new RongIMClient.ResultCallback<Boolean>(){

                public void onSuccess(Boolean aBoolean) {
                    if (FilePreviewActivity.this.mFileDownloadInfo.state == 0 || FilePreviewActivity.this.mFileDownloadInfo.state == 3 || FilePreviewActivity.this.mFileDownloadInfo.state == 4 || FilePreviewActivity.this.mFileDownloadInfo.state == 5) {
                        FilePreviewActivity.this.supportResumeTransfer = SupportResumeStatus.valueOf(aBoolean != false ? 1 : 0);
                        FilePreviewActivity.this.downloadFile();
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                    FilePreviewActivity.this.mFileDownloadInfo.state = 4;
                    FilePreviewActivity.this.refreshDownloadState();
                }
            });
        } else if (this.mFileDownloadInfo.state == 0 || this.mFileDownloadInfo.state == 4 || this.mFileDownloadInfo.state == 3 || this.mFileDownloadInfo.state == 5) {
            this.downloadFile();
        }
    }

    protected void resetMediaMessageLocalPath() {
        FileMessage fileMessage;
        if (this.mMessage.getContent() instanceof FileMessage && (fileMessage = (FileMessage)this.mMessage.getContent()).getLocalPath() != null && !TextUtils.isEmpty((CharSequence)fileMessage.getLocalPath().toString())) {
            ((FileMessage)this.mMessage.getContent()).setLocalPath(null);
            this.mFileMessage.setLocalPath(null);
            EventBus.getDefault().post(this.mMessage);
        }
    }

    public void openFile(String fileName, String fileSavePath) {
        if (!this.openInsidePreview(fileName, fileSavePath)) {
            Intent intent = FileTypeUtils.getOpenFileIntent(fileName, fileSavePath);
            try {
                if (intent != null) {
                    intent.addFlags(1);
                    this.startActivity(intent);
                } else {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_ac_file_preview_can_not_open_file), (int)0).show();
                }
            }
            catch (Exception e) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_ac_file_preview_can_not_open_file), (int)0).show();
            }
        }
    }

    protected boolean openInsidePreview(String fileName, String fileSavePath) {
        if (fileSavePath.endsWith(TXT_FILE)) {
            Intent webIntent = new Intent((Context)this, RongWebviewActivity.class);
            webIntent.setPackage(this.getPackageName());
            if (Build.VERSION.SDK_INT >= 24) {
                Uri uri = FileProvider.getUriForFile((Context)RongContext.getInstance(), (String)(RongContext.getInstance().getApplicationContext().getPackageName() + RongContext.getInstance().getResources().getString(R.string.rc_authorities_fileprovider)), (File)new File(fileSavePath));
                webIntent.putExtra("url", uri.toString());
            } else {
                webIntent.putExtra("url", "file://" + fileSavePath);
            }
            webIntent.putExtra("title", fileName);
            this.startActivity(webIntent);
            return true;
        }
        if (fileSavePath.endsWith(APK_FILE)) {
            File file = new File(fileSavePath);
            if (!file.exists()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_file_not_exist), (int)0).show();
                return false;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                Uri downloaded_apk;
                try {
                    downloaded_apk = FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + this.getString(R.string.rc_authorities_fileprovider)), (File)file);
                }
                catch (Exception e) {
                    throw new RuntimeException("Please check IMKit Manifest FileProvider config.");
                }
                Intent intent = new Intent("android.intent.action.VIEW").setDataAndType(downloaded_apk, "application/vnd.android.package-archive");
                intent.addFlags(1);
                this.startActivity(intent);
            } else {
                Intent installIntent = new Intent("android.intent.action.VIEW");
                installIntent.setFlags(0x10000000);
                installIntent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
                this.startActivity(installIntent);
            }
            return true;
        }
        return false;
    }

    @TargetApi(value=23)
    private void downloadFile() {
        String[] permission2 = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        if (!PermissionCheckUtil.checkPermissions((Context)this, permission2)) {
            PermissionCheckUtil.requestPermissions(this, permission2, 104);
            return;
        }
        this.mFileDownloadInfo.state = 2;
        if (this.supportResumeTransfer == SupportResumeStatus.SUPPORT) {
            this.mFileButton.setText((CharSequence)this.getResources().getString(R.string.rc_cancel));
            this.mCancel.setVisibility(8);
            this.mDownloadProgressView.setVisibility(0);
            this.mDownloadProgressTextView.setVisibility(8);
            this.info = this.getFileInfo();
            this.downloadedFileLength = this.info != null ? this.info.getFinished() : (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
            this.mFileSizeView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_tv, new Object[]{FileTypeUtils.formatFileSize(this.downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
        } else {
            this.mFileButton.setVisibility(8);
            this.mDownloadProgressView.setVisibility(0);
            this.mDownloadProgressTextView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_tv, new Object[]{FileTypeUtils.formatFileSize(0L), FileTypeUtils.formatFileSize(this.mFileSize)}));
        }
        RongIM.getInstance().downloadMediaMessage(this.mMessage, null);
    }

    private void getFileDownloadInfo() {
        if (this.mFileMessage.getLocalPath() != null && this.mFileMessage.getLocalPath().toString().toLowerCase().startsWith("file://")) {
            String path = this.mFileMessage.getLocalPath().toString().substring(7);
            File file = new File(path);
            this.mFileDownloadInfo.state = file.exists() ? 1 : 3;
        } else if (this.mProgress > 0 && this.mProgress < 100) {
            this.mFileDownloadInfo.state = 2;
            this.mFileDownloadInfo.progress = this.mProgress;
        } else {
            this.mFileDownloadInfo.state = 0;
        }
        this.refreshDownloadState();
    }

    private void getFileDownloadInfoForResumeTransfer() {
        if (this.mFileMessage.getLocalPath() != null && !TextUtils.isEmpty((CharSequence)this.mFileMessage.getLocalPath().toString())) {
            String path = this.mFileMessage.getLocalPath().getPath();
            if (path != null) {
                File file = new File(path);
                if (this.info == null) {
                    this.mFileDownloadInfo.state = file.exists() ? 1 : 3;
                } else if (file.exists()) {
                    if (this.info.isStop()) {
                        this.mFileDownloadInfo.state = 7;
                    }
                    if (this.info.isDownLoading()) {
                        this.mFileDownloadInfo.state = RongIMClient.getInstance().isFileDownloading(this.mMessage.getMessageId()) ? 2 : 7;
                    }
                } else {
                    FileUtils.removeFile((String)this.pausedPath);
                    this.mFileDownloadInfo.state = 3;
                }
            }
        } else if (this.info != null) {
            if (this.info.isStop()) {
                this.mFileDownloadInfo.state = 7;
            }
            if (this.info.isDownLoading()) {
                this.mFileDownloadInfo.state = RongIMClient.getInstance().isFileDownloading(this.mMessage.getMessageId()) ? 2 : 7;
            }
        } else if (this.mProgress > 0 && this.mProgress < 100) {
            this.mFileDownloadInfo.state = 2;
            this.mFileDownloadInfo.progress = this.mProgress;
        } else {
            this.mFileDownloadInfo.state = 0;
        }
        this.refreshDownloadState();
    }

    protected void refreshDownloadState() {
        switch (this.mFileDownloadInfo.state) {
            case 0: {
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_begin_download));
                break;
            }
            case 2: {
                if (this.supportResumeTransfer == SupportResumeStatus.SUPPORT) {
                    this.mDownloadProgressView.setVisibility(0);
                    this.mFileDownloadProgressBar.setProgress(this.mFileDownloadInfo.progress);
                    this.downloadedFileLength = (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
                    this.mFileSizeView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_tv, new Object[]{FileTypeUtils.formatFileSize(this.downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
                    this.mDownloadProgressTextView.setVisibility(8);
                    this.mFileButton.setText((CharSequence)this.getString(R.string.rc_cancel));
                    break;
                }
                this.mFileButton.setVisibility(8);
                this.mDownloadProgressView.setVisibility(0);
                this.mFileDownloadProgressBar.setProgress(this.mFileDownloadInfo.progress);
                long downloadedFileLength = (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
                this.mDownloadProgressTextView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_tv, new Object[]{FileTypeUtils.formatFileSize(downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
                break;
            }
            case 1: {
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_download_open_file_btn));
                break;
            }
            case 6: {
                this.mDownloadProgressView.setVisibility(8);
                this.mFileButton.setVisibility(0);
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_download_open_file_btn));
                this.mFileSizeView.setText((CharSequence)FileTypeUtils.formatFileSize(this.mFileSize));
                Toast.makeText((Context)this, (CharSequence)(this.getString(R.string.rc_ac_file_preview_downloaded) + this.mFileDownloadInfo.path), (int)0).show();
                break;
            }
            case 4: {
                if (this.supportResumeTransfer == SupportResumeStatus.SUPPORT) {
                    this.mDownloadProgressView.setVisibility(0);
                    this.info = this.getFileInfo();
                    if (this.info != null) {
                        this.mFileDownloadInfo.progress = (int)(100L * this.info.getFinished() / this.info.getLength());
                    }
                    this.mFileDownloadProgressBar.setProgress(this.mFileDownloadInfo.progress);
                    long downloadedFileLength = (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
                    this.mFileSizeView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_pause, new Object[]{FileTypeUtils.formatFileSize(downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
                    this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_download_resume));
                } else {
                    this.mDownloadProgressView.setVisibility(8);
                    this.mFileButton.setVisibility(0);
                    this.mFileSizeView.setText((CharSequence)FileTypeUtils.formatFileSize(this.mFileSize));
                    this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_begin_download));
                }
                Toast toast = Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_ac_file_preview_download_error), (int)0);
                if (this.mFileDownloadInfo.state != 5) {
                    toast.show();
                }
                this.mToasts.add(toast);
                break;
            }
            case 5: {
                this.mDownloadProgressView.setVisibility(8);
                this.mFileDownloadProgressBar.setProgress(0);
                this.mFileButton.setVisibility(0);
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_begin_download));
                this.mFileSizeView.setText((CharSequence)FileTypeUtils.formatFileSize(this.mFileSize));
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.rc_ac_file_preview_download_cancel), (int)0).show();
                break;
            }
            case 3: {
                this.mFileSizeView.setText((CharSequence)FileTypeUtils.formatFileSize(this.mFileSize));
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_begin_download));
                break;
            }
            case 7: {
                this.mDownloadProgressView.setVisibility(0);
                if (this.info != null) {
                    this.mFileDownloadInfo.progress = (int)(100L * this.info.getFinished() / this.info.getLength());
                    this.downloadedFileLength = this.info.getFinished();
                } else {
                    this.downloadedFileLength = (long)((double)this.mFileMessage.getSize() * ((double)this.mFileDownloadInfo.progress / 100.0) + 0.5);
                }
                this.mFileDownloadProgressBar.setProgress(this.mFileDownloadInfo.progress);
                this.mFileSizeView.setText((CharSequence)this.getString(R.string.rc_ac_file_download_progress_pause, new Object[]{FileTypeUtils.formatFileSize(this.downloadedFileLength), FileTypeUtils.formatFileSize(this.mFileSize)}));
                this.mFileButton.setText((CharSequence)this.getString(R.string.rc_ac_file_preview_download_resume));
            }
        }
    }

    public void onEventMainThread(Event.FileMessageEvent event) {
        if (this.mMessage.getMessageId() == event.getMessage().getMessageId()) {
            switch (event.getCallBackType()) {
                case 100: {
                    if (this.mFileDownloadInfo.state == 5) break;
                    if (event.getMessage() == null || event.getMessage().getContent() == null) {
                        return;
                    }
                    FileMessage fileMessage = (FileMessage)event.getMessage().getContent();
                    this.mFileMessage.setLocalPath(Uri.parse((String)fileMessage.getLocalPath().toString()));
                    this.mFileDownloadInfo.state = 6;
                    this.mFileDownloadInfo.path = fileMessage.getLocalPath().toString();
                    this.refreshDownloadState();
                    break;
                }
                case 101: {
                    if (this.mFileDownloadInfo.state == 5 || this.mFileDownloadInfo.state == 7) break;
                    this.mFileDownloadInfo.state = 2;
                    this.mFileDownloadInfo.progress = event.getProgress();
                    this.refreshDownloadState();
                    break;
                }
                case 103: {
                    if (this.mFileDownloadInfo.state == 5) break;
                    this.mFileDownloadInfo.state = 4;
                    this.refreshDownloadState();
                    break;
                }
                case 102: {
                    this.mFileDownloadInfo.state = 5;
                    this.refreshDownloadState();
                }
            }
        }
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onRestart() {
        super.onRestart();
        this.pausedPath = FileUtils.getTempFilePath((Context)this, (int)this.mMessage.getMessageId());
        this.getFileDownloadInfoInSubThread();
    }

    private void getFileDownloadInfoInSubThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilePreviewActivity.this.info = FilePreviewActivity.this.getFileInfo();
                FilePreviewActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FilePreviewActivity.this.setViewStatusForResumeTransfer();
                        FilePreviewActivity.this.getFileDownloadInfoForResumeTransfer();
                    }
                });
            }
        }).start();
    }

    private FileInfo getFileInfo() {
        FileInfo savedFileInfo = null;
        try {
            String savedFileInfoString = FileUtils.getStringFromFile((String)this.pausedPath);
            if (!TextUtils.isEmpty((CharSequence)savedFileInfoString)) {
                savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString);
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"getFileInfo", (Throwable)e);
        }
        return savedFileInfo;
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        RongContext.getInstance().getEventBus().unregister((Object)this);
        try {
            for (Toast toast : this.mToasts) {
                toast.cancel();
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"onDestroy", (Throwable)e);
        }
        super.onDestroy();
    }

    public Message getMessage() {
        return this.mMessage;
    }

    private FileInfo getFileInfoFromJsonString(String jsonString) {
        FileInfo fileInfo = new FileInfo();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            fileInfo.setFileName(jsonObject.optString("filename"));
            fileInfo.setUrl(jsonObject.optString("url"));
            fileInfo.setLength(jsonObject.optLong("length"));
            fileInfo.setFinished(jsonObject.optLong("finish"));
            fileInfo.setStop(jsonObject.optBoolean("isStop", false));
            fileInfo.setDownLoading(jsonObject.optBoolean("isDownLoading", false));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)"getFileInfoFromJsonString", (Throwable)e);
        }
        return fileInfo;
    }

    private static enum SupportResumeStatus {
        NOT_SET(-1),
        NOT_SUPPORT(0),
        SUPPORT(1);

        int value;

        private SupportResumeStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SupportResumeStatus valueOf(int code) {
            for (SupportResumeStatus c : SupportResumeStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            SupportResumeStatus c = NOT_SET;
            c.value = code;
            return c;
        }
    }

    public class FileDownloadInfo {
        public int state;
        public int progress;
        public String path;
    }
}

