/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.emoticon;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ReplacementSpan;
import android.util.DisplayMetrics;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidEmoji {
    private static float density;
    private static Context mContext;
    private static final int MAX_DISPLAY_EMOJI = 600;
    private static Map<Integer, EmojiInfo> sEmojiMap;
    private static List<EmojiInfo> sEmojiList;

    public static void init(Context context) {
        sEmojiMap = new HashMap<Integer, EmojiInfo>();
        sEmojiList = new ArrayList<EmojiInfo>();
        mContext = context.getApplicationContext();
        int[] codes = context.getResources().getIntArray(context.getResources().getIdentifier("rc_emoji_code", "array", context.getPackageName()));
        TypedArray array2 = context.getResources().obtainTypedArray(context.getResources().getIdentifier("rc_emoji_res", "array", context.getPackageName()));
        TypedArray strArray = context.getResources().obtainTypedArray(context.getResources().getIdentifier("rc_emoji_description", "array", context.getPackageName()));
        if (codes.length != array2.length()) {
            throw new RuntimeException("Emoji resource init fail.");
        }
        int i = -1;
        while (++i < codes.length) {
            EmojiInfo emoji = new EmojiInfo(codes[i], array2.getResourceId(i, -1), strArray.getResourceId(i, -1));
            sEmojiMap.put(codes[i], emoji);
            sEmojiList.add(emoji);
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        density = dm.density;
        array2.recycle();
    }

    public static List<EmojiInfo> getEmojiList() {
        return sEmojiList;
    }

    public static int getEmojiCount(String input) {
        if (input == null) {
            return 0;
        }
        int count = 0;
        char[] chars = input.toCharArray();
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)input);
        for (int i = 0; i < chars.length; ++i) {
            boolean isSurrogatePair;
            int codePoint;
            if (Character.isHighSurrogate(chars[i])) continue;
            if (Character.isLowSurrogate(chars[i])) {
                if (i <= 0 || !Character.isSurrogatePair(chars[i - 1], chars[i])) continue;
                codePoint = Character.toCodePoint(chars[i - 1], chars[i]);
                isSurrogatePair = true;
            } else {
                codePoint = chars[i];
                isSurrogatePair = false;
            }
            if (!sEmojiMap.containsKey(codePoint)) continue;
            ++count;
        }
        return count;
    }

    public static CharSequence ensure(String input) {
        if (input == null) {
            return input;
        }
        char[] chars = input.toCharArray();
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)input);
        for (int i = 0; i < chars.length; ++i) {
            boolean isSurrogatePair;
            int codePoint;
            if (Character.isHighSurrogate(chars[i])) continue;
            if (Character.isLowSurrogate(chars[i])) {
                if (i <= 0 || !Character.isSurrogatePair(chars[i - 1], chars[i])) continue;
                codePoint = Character.toCodePoint(chars[i - 1], chars[i]);
                isSurrogatePair = true;
            } else {
                codePoint = chars[i];
                isSurrogatePair = false;
            }
            if (!sEmojiMap.containsKey(codePoint)) continue;
            ssb.setSpan((Object)new EmojiImageSpan(codePoint), isSurrogatePair ? i - 1 : i, i + 1, 33);
        }
        return ssb;
    }

    public static boolean isEmoji(String input) {
        if (input == null) {
            return false;
        }
        char[] chars = input.toCharArray();
        int codePoint = 0;
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            if (Character.isHighSurrogate(chars[i])) continue;
            if (Character.isLowSurrogate(chars[i])) {
                if (i <= 0 || !Character.isSurrogatePair(chars[i - 1], chars[i])) continue;
                codePoint = Character.toCodePoint(chars[i - 1], chars[i]);
            } else {
                codePoint = chars[i];
            }
            if (!sEmojiMap.containsKey(codePoint)) continue;
            return true;
        }
        return false;
    }

    public static void ensure(Spannable spannable, float textSize) {
        char[] chars = spannable.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean isSurrogatePair;
            int codePoint;
            if (Character.isHighSurrogate(chars[i])) continue;
            if (Character.isLowSurrogate(chars[i])) {
                if (i <= 0 || !Character.isSurrogatePair(chars[i - 1], chars[i])) continue;
                codePoint = Character.toCodePoint(chars[i - 1], chars[i]);
                isSurrogatePair = true;
            } else {
                codePoint = chars[i];
                isSurrogatePair = false;
            }
            if (!sEmojiMap.containsKey(codePoint)) continue;
            spannable.setSpan((Object)new EmojiImageSpan(codePoint, textSize), isSurrogatePair ? i - 1 : i, i + 1, 34);
        }
    }

    public static void ensure(Spannable spannable) {
        AndroidEmoji.ensure(spannable, 0.0f);
    }

    public static SpannableStringBuilder replaceEmojiWithText(Spannable spannable) {
        if (spannable == null) {
            return null;
        }
        char[] chars = spannable.toString().toCharArray();
        String resultSpanStr = AndroidEmoji.getReplaceEmojiText(chars, spannable.toString());
        return new SpannableStringBuilder((CharSequence)resultSpanStr);
    }

    public static String replaceEmojiWithText(String input) {
        if (input == null) {
            return null;
        }
        char[] chars = input.toCharArray();
        String resultSpanStr = AndroidEmoji.getReplaceEmojiText(chars, input);
        return resultSpanStr == null ? null : resultSpanStr.toString();
    }

    private static String getReplaceEmojiText(char[] chars, String srcString) {
        int emojiCount = 0;
        StringBuilder resultSpanStr = new StringBuilder("");
        for (int i = 0; i < chars.length; ++i) {
            boolean isSurrogatePair;
            int codePoint;
            if (Character.isHighSurrogate(chars[i])) continue;
            if (Character.isLowSurrogate(chars[i])) {
                if (i <= 0 || !Character.isSurrogatePair(chars[i - 1], chars[i])) continue;
                codePoint = Character.toCodePoint(chars[i - 1], chars[i]);
                isSurrogatePair = true;
            } else {
                codePoint = chars[i];
                isSurrogatePair = false;
            }
            if (sEmojiMap.containsKey(codePoint)) {
                ++emojiCount;
                String spannableStr = srcString;
                char[] spanchars = spannableStr.toCharArray();
                if (spanchars != null && spanchars.length > 0) {
                    if (emojiCount > 600) {
                        resultSpanStr.append("[");
                        resultSpanStr.append(mContext.getResources().getString(AndroidEmoji.sEmojiMap.get((Object)Integer.valueOf((int)codePoint)).strId));
                        resultSpanStr.append("]");
                        continue;
                    }
                    resultSpanStr = AndroidEmoji.appendSpanStr(isSurrogatePair, resultSpanStr, chars, i);
                    continue;
                }
                resultSpanStr = AndroidEmoji.appendSpanStr(isSurrogatePair, resultSpanStr, chars, i);
                continue;
            }
            resultSpanStr = AndroidEmoji.appendSpanStr(isSurrogatePair, resultSpanStr, chars, i);
        }
        return resultSpanStr == null ? null : resultSpanStr.toString();
    }

    private static StringBuilder appendSpanStr(boolean isSurrogatePair, StringBuilder resultSpanStr, char[] chars, int index) {
        if (resultSpanStr == null) {
            return null;
        }
        if (isSurrogatePair) {
            if (index - 1 >= 0) {
                resultSpanStr.append(chars[index - 1]);
                resultSpanStr.append(chars[index]);
            }
        } else if (index >= 0) {
            resultSpanStr.append(chars[index]);
        }
        return resultSpanStr;
    }

    public static int getEmojiSize() {
        return sEmojiMap.size();
    }

    public static int getEmojiCode(int index) {
        EmojiInfo info = sEmojiList.get(index);
        return info.code;
    }

    public static Drawable getEmojiDrawable(Context context, int index) {
        Drawable drawable2 = null;
        if (index >= 0 && index < sEmojiList.size()) {
            EmojiInfo emoji = sEmojiList.get(index);
            drawable2 = context.getResources().getDrawable(emoji.resId);
        }
        return drawable2;
    }

    private static class EmojiInfo {
        int code;
        int resId;
        int strId;

        public EmojiInfo(int code, int resId) {
            this.code = code;
            this.resId = resId;
        }

        public EmojiInfo(int code, int resId, int strId) {
            this.code = code;
            this.resId = resId;
            this.strId = strId;
        }
    }

    public static class EmojiImageSpan
    extends ReplacementSpan {
        Drawable mDrawable;
        private static final String TAG = "DynamicDrawableSpan";
        public static final int ALIGN_BOTTOM = 0;
        private WeakReference<Drawable> mDrawableRef;

        private EmojiImageSpan(int codePoint) {
            this(codePoint, 0.0f);
        }

        public EmojiImageSpan(int codePoint, float textSize) {
            if (sEmojiMap.containsKey(codePoint)) {
                this.mDrawable = mContext.getResources().getDrawable(((EmojiInfo)sEmojiMap.get((Object)Integer.valueOf((int)codePoint))).resId);
                int offset = textSize == 0.0f ? -((int)(4.0f * density)) : (int)(textSize - 21.0f * density);
                int width = this.mDrawable.getIntrinsicWidth() + offset;
                int height = this.mDrawable.getIntrinsicHeight() + offset;
                this.mDrawable.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
            }
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getCachedDrawable();
            Rect rect = d.getBounds();
            if (fm != null) {
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
            return rect.right;
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            Drawable b = this.getCachedDrawable();
            canvas.save();
            int transY = bottom - b.getBounds().bottom;
            transY = (int)((float)transY - density);
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }

        private Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.mDrawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(d);
            }
            return d;
        }
    }
}

