/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Intent;
import android.support.v4.app.Fragment;
import io.rong.imkit.fragment.UriFragment;
import java.util.Iterator;

public abstract class DispatchResultFragment
extends UriFragment {
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        int index = requestCode >> 12;
        if (index != 0) {
            Fragment fragment;
            if ((fragment = this.getOffsetFragment(--index, this)) != null) {
                fragment.onActivityResult(requestCode & 0xFFF, resultCode, data);
            }
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void startActivityForResult(Fragment fragment, Intent intent, int requestCode) {
        int index = this.getFragmentOffset(0, fragment, this);
        if (index > 15) {
            throw new RuntimeException("DispatchFragment only support 16 fragments\u3002");
        }
        if (requestCode == -1) {
            this.startActivityForResult(intent, -1);
            return;
        }
        if ((requestCode & 0xFFFFF000) != 0) {
            throw new IllegalArgumentException("Can only use lower 12 bits for requestCode");
        }
        this.startActivityForResult(intent, (index + 1 << 12) + (requestCode & 0xFFF));
    }

    private int getFragmentOffset(int offset, Fragment targetFragment, Fragment parentFragment) {
        if (parentFragment == null || parentFragment.getChildFragmentManager() == null || parentFragment.getChildFragmentManager().getFragments() == null) {
            return 0;
        }
        Iterator iterator = parentFragment.getChildFragmentManager().getFragments().iterator();
        if (iterator.hasNext()) {
            Fragment item = (Fragment)iterator.next();
            ++offset;
            if (targetFragment == item) {
                return offset;
            }
            return this.getFragmentOffset(offset, targetFragment, item);
        }
        return 0;
    }

    private Fragment getOffsetFragment(int offset, Fragment fragment) {
        if (offset == 0) {
            return fragment;
        }
        for (Fragment item : this.getChildFragmentManager().getFragments()) {
            if (--offset == 0) {
                return item;
            }
            if (item.getChildFragmentManager().getFragments() == null || item.getChildFragmentManager().getFragments().size() <= 0) continue;
            return this.getOffsetFragment(offset, item);
        }
        return null;
    }
}

