/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.DispatchResultFragment;
import io.rong.imkit.model.Event;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.LoadingDialogFragment;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;

public class PublicServiceSearchFragment
extends DispatchResultFragment {
    private static final String TAG = "PublicServiceSearchFragment";
    private EditText mEditText;
    private Button mSearchBtn;
    private ListView mListView;
    private PublicServiceListAdapter mAdapter;
    private LoadingDialogFragment mLoadingDialogFragment;

    @Override
    protected void initFragment(Uri uri) {
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_public_service_search, container, false);
        this.mEditText = (EditText)view.findViewById(R.id.rc_search_ed);
        this.mSearchBtn = (Button)view.findViewById(R.id.rc_search_btn);
        this.mListView = (ListView)view.findViewById(R.id.rc_search_list);
        RongContext.getInstance().getEventBus().register((Object)this);
        return view;
    }

    @Override
    public boolean handleMessage(Message msg) {
        return false;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingDialogFragment = LoadingDialogFragment.newInstance("", this.getResources().getString(R.string.rc_notice_data_is_loading));
        this.mSearchBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PublicServiceSearchFragment.this.mLoadingDialogFragment.show(PublicServiceSearchFragment.this.getFragmentManager());
                RongIM.getInstance().searchPublicService(RongIMClient.SearchType.FUZZY, PublicServiceSearchFragment.this.mEditText.getText().toString(), new RongIMClient.ResultCallback<PublicServiceProfileList>(){

                    public void onError(RongIMClient.ErrorCode e) {
                        PublicServiceSearchFragment.this.mLoadingDialogFragment.dismiss();
                    }

                    public void onSuccess(PublicServiceProfileList list) {
                        PublicServiceSearchFragment.this.mAdapter.clear();
                        PublicServiceSearchFragment.this.mAdapter.addCollection(list.getPublicServiceData());
                        PublicServiceSearchFragment.this.mAdapter.notifyDataSetChanged();
                        PublicServiceSearchFragment.this.mLoadingDialogFragment.dismiss();
                    }
                });
            }
        });
        this.mAdapter = new PublicServiceListAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PublicServiceProfile info = PublicServiceSearchFragment.this.mAdapter.getItem(position);
                if (info.isFollow()) {
                    RongIM.getInstance().startConversation((Context)PublicServiceSearchFragment.this.getActivity(), info.getConversationType(), info.getTargetId(), info.getName());
                } else {
                    Uri uri = Uri.parse((String)("rong://" + view.getContext().getApplicationInfo().packageName)).buildUpon().appendPath("publicServiceProfile").appendPath(info.getConversationType().getName().toLowerCase()).appendQueryParameter("targetId", info.getTargetId()).build();
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    intent.putExtra("arg_public_account_info", (Parcelable)info);
                    PublicServiceSearchFragment.this.startActivity(intent);
                }
            }
        });
    }

    @Override
    public void onDestroy() {
        RongContext.getInstance().getEventBus().unregister((Object)this);
        super.onDestroy();
    }

    public void onEventMainThread(Event.PublicServiceFollowableEvent event) {
        RLog.d((String)TAG, (String)("onEventMainThread PublicAccountIsFollowEvent, follow=" + event.isFollow()));
        if (event != null) {
            this.getActivity().finish();
        }
    }

    private class PublicServiceListAdapter
    extends BaseAdapter<PublicServiceProfile> {
        LayoutInflater mInflater;

        public PublicServiceListAdapter(Context context) {
            this.mInflater = LayoutInflater.from((Context)context);
        }

        @Override
        protected View newView(Context context, int position, ViewGroup group) {
            View view = this.mInflater.inflate(R.layout.rc_item_public_service_search, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.portrait = (AsyncImageView)view.findViewById(R.id.rc_portrait);
            viewHolder.title = (TextView)view.findViewById(R.id.rc_title);
            viewHolder.description = (TextView)view.findViewById(R.id.rc_description);
            view.setTag((Object)viewHolder);
            return view;
        }

        @Override
        protected void bindView(View v, int position, PublicServiceProfile data) {
            ViewHolder viewHolder = (ViewHolder)v.getTag();
            if (data != null) {
                viewHolder.portrait.setResource(data.getPortraitUri());
                viewHolder.title.setText((CharSequence)data.getName());
                viewHolder.description.setText((CharSequence)data.getIntroduction());
            }
        }

        @Override
        public int getCount() {
            return super.getCount();
        }

        @Override
        public PublicServiceProfile getItem(int position) {
            return (PublicServiceProfile)super.getItem(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        class ViewHolder {
            AsyncImageView portrait;
            TextView title;
            TextView description;

            ViewHolder() {
            }
        }
    }
}

