/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import io.rong.common.RLog;
import io.rong.imkit.manager.IAudioPlayListener;
import java.io.FileInputStream;
import java.io.IOException;

public class AudioPlayManager
implements SensorEventListener {
    private static final String TAG = "AudioPlayManager";
    private MediaPlayer mMediaPlayer;
    private IAudioPlayListener _playListener;
    private Uri mUriPlaying;
    private Sensor _sensor;
    private SensorManager _sensorManager;
    private AudioManager mAudioManager;
    private PowerManager _powerManager;
    private PowerManager.WakeLock _wakeLock;
    private AudioManager.OnAudioFocusChangeListener afChangeListener;
    private boolean isVOIPMode = false;

    public static AudioPlayManager getInstance() {
        return SingletonHolder.sInstance;
    }

    @TargetApi(value=11)
    public void onSensorChanged(SensorEvent event) {
        float range = event.values[0];
        RLog.d((String)TAG, (String)("onSensorChanged. range:" + range + "; max range:" + event.sensor.getMaximumRange()));
        double rangeJudgeValue = 0.0;
        if (this._sensor == null || this.mMediaPlayer == null) {
            return;
        }
        boolean judge = this.judgeCondition(event, range, rangeJudgeValue);
        if (this.mMediaPlayer.isPlaying()) {
            if (judge) {
                if (this.mAudioManager.getMode() == 0) {
                    return;
                }
                this.mAudioManager.setMode(0);
                this.mAudioManager.setSpeakerphoneOn(true);
                final int positions = this.mMediaPlayer.getCurrentPosition();
                try {
                    this.mMediaPlayer.reset();
                    this.mMediaPlayer.setAudioStreamType(3);
                    this.mMediaPlayer.setVolume(1.0f, 1.0f);
                    FileInputStream fis = new FileInputStream(this.mUriPlaying.getPath());
                    this.mMediaPlayer.setDataSource(fis.getFD());
                    this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mp) {
                            mp.seekTo(positions);
                        }
                    });
                    this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                        public void onSeekComplete(MediaPlayer mp) {
                            mp.start();
                        }
                    });
                    this.mMediaPlayer.prepareAsync();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"onSensorChanged", (Throwable)e);
                }
                this.setScreenOn();
            } else {
                if (!Build.BRAND.equals("samsung") || !Build.MODEL.equals("SM-N9200")) {
                    this.setScreenOff();
                }
                if (Build.VERSION.SDK_INT >= 11) {
                    if (this.mAudioManager.getMode() == 3) {
                        return;
                    }
                    this.mAudioManager.setMode(3);
                } else {
                    if (this.mAudioManager.getMode() == 2) {
                        return;
                    }
                    this.mAudioManager.setMode(2);
                }
                this.mAudioManager.setSpeakerphoneOn(false);
                this.replay();
            }
        } else if ((double)range > 0.0) {
            if (this.mAudioManager.getMode() == 0) {
                return;
            }
            this.mAudioManager.setMode(0);
            this.mAudioManager.setSpeakerphoneOn(true);
            this.setScreenOn();
        }
    }

    private boolean judgeCondition(SensorEvent event, float range, double rangeJudgeValue) {
        boolean judge;
        if (Build.BRAND.equalsIgnoreCase("HUAWEI")) {
            judge = range >= event.sensor.getMaximumRange();
        } else {
            if (Build.BRAND.equalsIgnoreCase("ZTE")) {
                rangeJudgeValue = 1.0;
            } else if (Build.BRAND.equalsIgnoreCase("nubia")) {
                rangeJudgeValue = 3.0;
            }
            judge = (double)range > rangeJudgeValue;
        }
        return judge;
    }

    @TargetApi(value=21)
    private void setScreenOff() {
        if (this._wakeLock == null) {
            this._wakeLock = this._powerManager.newWakeLock(32, TAG);
        }
        if (this._wakeLock != null && !this._wakeLock.isHeld()) {
            this._wakeLock.acquire();
        }
    }

    private void setScreenOn() {
        if (this._wakeLock != null && this._wakeLock.isHeld()) {
            this._wakeLock.setReferenceCounted(false);
            this._wakeLock.release();
            this._wakeLock = null;
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void replay() {
        try {
            this.mMediaPlayer.reset();
            if (Build.BRAND.equals("samsung") && Build.MODEL.equals("SM-N9200")) {
                this.mMediaPlayer.setAudioStreamType(0);
            } else {
                this.mMediaPlayer.setAudioStreamType(3);
            }
            this.mMediaPlayer.setVolume(1.0f, 1.0f);
            FileInputStream fis = new FileInputStream(this.mUriPlaying.getPath());
            this.mMediaPlayer.setDataSource(fis.getFD());
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        RLog.e((String)AudioPlayManager.TAG, (String)"replay", (Throwable)e);
                    }
                    mp.start();
                }
            });
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            RLog.e((String)TAG, (String)"replay", (Throwable)e);
        }
    }

    public void startPlay(Context context, Uri audioUri, IAudioPlayListener playListener) {
        if (context == null || audioUri == null) {
            RLog.e((String)TAG, (String)"startPlay context or audioUri is null.");
            return;
        }
        if (this._playListener != null && this.mUriPlaying != null) {
            this._playListener.onStop(this.mUriPlaying);
        }
        this.resetMediaPlayer();
        this.afChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                RLog.d((String)AudioPlayManager.TAG, (String)("OnAudioFocusChangeListener " + focusChange));
                if (AudioPlayManager.this.mAudioManager != null && focusChange == -1) {
                    AudioPlayManager.this.mAudioManager.abandonAudioFocus(AudioPlayManager.this.afChangeListener);
                    AudioPlayManager.this.afChangeListener = null;
                    if (AudioPlayManager.this._playListener != null) {
                        AudioPlayManager.this._playListener.onComplete(AudioPlayManager.this.mUriPlaying);
                        AudioPlayManager.this._playListener = null;
                    }
                    AudioPlayManager.this.reset();
                }
            }
        };
        try {
            this._powerManager = (PowerManager)context.getApplicationContext().getSystemService("power");
            this.mAudioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
            if (!this.mAudioManager.isWiredHeadsetOn()) {
                this._sensorManager = (SensorManager)context.getApplicationContext().getSystemService("sensor");
                this._sensor = this._sensorManager.getDefaultSensor(8);
                this._sensorManager.registerListener((SensorEventListener)this, this._sensor, 3);
            }
            this.muteAudioFocus(this.mAudioManager, true);
            this._playListener = playListener;
            this.mUriPlaying = audioUri;
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (AudioPlayManager.this._playListener != null) {
                        AudioPlayManager.this._playListener.onComplete(AudioPlayManager.this.mUriPlaying);
                        AudioPlayManager.this._playListener = null;
                    }
                    AudioPlayManager.this.reset();
                }
            });
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    AudioPlayManager.this.reset();
                    return true;
                }
            });
            FileInputStream fis = new FileInputStream(audioUri.getPath());
            this.mMediaPlayer.setDataSource(fis.getFD());
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.prepare();
            this.mMediaPlayer.start();
            if (this._playListener != null) {
                this._playListener.onStart(this.mUriPlaying);
            }
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"startPlay", (Throwable)e);
            if (this._playListener != null) {
                this._playListener.onStop(audioUri);
                this._playListener = null;
            }
            this.reset();
        }
    }

    public void setPlayListener(IAudioPlayListener listener) {
        this._playListener = listener;
    }

    public void stopPlay() {
        if (this._playListener != null && this.mUriPlaying != null) {
            this._playListener.onStop(this.mUriPlaying);
        }
        this.reset();
    }

    private void reset() {
        this.resetMediaPlayer();
        this.resetAudioPlayManager();
    }

    private void resetAudioPlayManager() {
        if (this.mAudioManager != null) {
            this.mAudioManager.setMode(0);
            this.muteAudioFocus(this.mAudioManager, false);
        }
        if (this._sensorManager != null) {
            this.setScreenOn();
            this._sensorManager.unregisterListener((SensorEventListener)this);
        }
        this._sensorManager = null;
        this._sensor = null;
        this._powerManager = null;
        this.mAudioManager = null;
        this._wakeLock = null;
        this.mUriPlaying = null;
        this._playListener = null;
    }

    private void resetMediaPlayer() {
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.stop();
                this.mMediaPlayer.reset();
                this.mMediaPlayer.release();
                this.mMediaPlayer = null;
            }
            catch (IllegalStateException e) {
                RLog.e((String)TAG, (String)"resetMediaPlayer", (Throwable)e);
            }
        }
    }

    public Uri getPlayingUri() {
        return this.mUriPlaying != null ? this.mUriPlaying : Uri.EMPTY;
    }

    @TargetApi(value=8)
    private void muteAudioFocus(AudioManager audioManager, boolean bMute) {
        if (bMute) {
            audioManager.requestAudioFocus(this.afChangeListener, 3, 2);
        } else {
            audioManager.abandonAudioFocus(this.afChangeListener);
            this.afChangeListener = null;
        }
    }

    public boolean isInNormalMode(Context context) {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
        }
        return this.mAudioManager != null && this.mAudioManager.getMode() == 0;
    }

    public boolean isInVOIPMode(Context context) {
        return this.isVOIPMode;
    }

    public void setInVoipMode(boolean isVOIPMode) {
        this.isVOIPMode = isVOIPMode;
    }

    public boolean isPlaying() {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
    }

    static class SingletonHolder {
        static AudioPlayManager sInstance = new AudioPlayManager();

        SingletonHolder() {
        }
    }
}

