/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.imkit.manager.IExternalModule;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imlib.model.Conversation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class InternalModuleManager {
    private static final String TAG = "InternalModuleManager";
    private static IExternalModule callModule;

    private InternalModuleManager() {
    }

    public static InternalModuleManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public static void init(Context context) {
        RLog.i((String)TAG, (String)"init");
        try {
            String moduleName = "io.rong.callkit.RongCallModule";
            Class<?> cls = Class.forName(moduleName);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            callModule = (IExternalModule)constructor.newInstance(new Object[0]);
            callModule.onCreate(context);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Can not find RongCallModule.");
        }
    }

    public void onInitialized(String appKey) {
        RLog.i((String)TAG, (String)"onInitialized");
        if (callModule != null) {
            callModule.onInitialized(appKey);
        }
    }

    public List<IPluginModule> getInternalPlugins(Conversation.ConversationType conversationType) {
        ArrayList<IPluginModule> pluginModules = new ArrayList<IPluginModule>();
        if (callModule != null && (conversationType.equals((Object)Conversation.ConversationType.PRIVATE) || conversationType.equals((Object)Conversation.ConversationType.DISCUSSION) || conversationType.equals((Object)Conversation.ConversationType.GROUP))) {
            pluginModules.addAll(callModule.getPlugins(conversationType));
        }
        return pluginModules;
    }

    public void onConnected(String token) {
        RLog.i((String)TAG, (String)"onConnected");
        if (callModule != null) {
            callModule.onConnected(token);
        }
    }

    public void onLoaded() {
        RLog.i((String)TAG, (String)"onLoaded");
        if (callModule != null) {
            callModule.onViewCreated();
        }
    }

    static class SingletonHolder {
        static InternalModuleManager sInstance = new InternalModuleManager();

        SingletonHolder() {
        }
    }
}

