/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.manager;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.Toast;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.Event;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.utilities.videocompressor.VideoCompress;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.SightMessage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SendMediaManager {
    private static final String TAG = SendMediaManager.class.getSimpleName();
    private ExecutorService executorService = this.getExecutorService();
    private UploadController uploadController = new UploadController();

    public static SendMediaManager getInstance() {
        return SingletonHolder.sInstance;
    }

    private SendMediaManager() {
    }

    public void sendMedia(Conversation.ConversationType conversationType, String targetId, List<Uri> mediaList, boolean isFull) {
        RLog.d((String)TAG, (String)("The size of media is " + mediaList.size()));
        for (Uri mediaUri : mediaList) {
            File file;
            if (TextUtils.isEmpty((CharSequence)mediaUri.getPath()) || !(file = new File(mediaUri.getPath())).exists()) continue;
            int mediaDuration = RongUtils.getVideoDuration((Context)RongContext.getInstance(), mediaUri.toString());
            SightMessage sightMessage = SightMessage.obtain((Uri)mediaUri, (int)(mediaDuration / 1000));
            RongIM.OnSendMessageListener listener = RongContext.getInstance().getOnSendMessageListener();
            if (listener != null) {
                Message message = listener.onSend(Message.obtain((String)targetId, (Conversation.ConversationType)conversationType, (MessageContent)sightMessage));
                if (message == null) continue;
                RongIMClient.getInstance().insertMessage(conversationType, targetId, null, message.getContent(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                    public void onSuccess(Message message) {
                        message.setSentStatus(Message.SentStatus.SENDING);
                        RongIMClient.getInstance().setMessageSentStatus(message.getMessageId(), Message.SentStatus.SENDING, null);
                        RongContext.getInstance().getEventBus().post(message);
                        SendMediaManager.this.uploadController.execute(message);
                    }

                    public void onError(RongIMClient.ErrorCode e) {
                    }
                });
                continue;
            }
            RongIMClient.getInstance().insertMessage(conversationType, targetId, null, (MessageContent)sightMessage, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message) {
                    message.setSentStatus(Message.SentStatus.SENDING);
                    RongIMClient.getInstance().setMessageSentStatus(message.getMessageId(), Message.SentStatus.SENDING, null);
                    RongContext.getInstance().getEventBus().post(message);
                    SendMediaManager.this.uploadController.execute(message);
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    public void cancelSendingMedia(Conversation.ConversationType conversationType, String targetId) {
        RLog.d((String)TAG, (String)"cancel Sending media");
        if (conversationType != null && targetId != null && this.uploadController != null) {
            this.uploadController.cancel(conversationType, targetId);
        }
    }

    public void reset() {
        this.uploadController.reset();
    }

    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory("Rong SendMediaManager", false));
        }
        return this.executorService;
    }

    private ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(@Nullable Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    private class UploadController
    implements Runnable {
        final List<Message> pendingMessages = new ArrayList<Message>();
        Message executingMessage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Message message) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                this.pendingMessages.add(message);
                if (this.executingMessage == null) {
                    this.executingMessage = this.pendingMessages.remove(0);
                    SendMediaManager.this.executorService.submit(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            RLog.w((String)TAG, (String)"Reset Sending media.");
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                for (Message message : this.pendingMessages) {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    RongContext.getInstance().getEventBus().post(message);
                }
                this.pendingMessages.clear();
            }
            if (this.executingMessage != null) {
                this.executingMessage.setSentStatus(Message.SentStatus.FAILED);
                RongContext.getInstance().getEventBus().post(this.executingMessage);
                this.executingMessage = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Conversation.ConversationType conversationType, String targetId) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                int count = this.pendingMessages.size();
                for (int i = 0; i < count; ++i) {
                    Message msg = this.pendingMessages.get(i);
                    if (!msg.getConversationType().equals((Object)conversationType) || !msg.getTargetId().equals(targetId)) continue;
                    this.pendingMessages.remove(msg);
                }
                if (this.pendingMessages.size() == 0) {
                    this.executingMessage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Conversation.ConversationType conversationType, String targetId, int messageId) {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                int count = this.pendingMessages.size();
                for (int i = 0; i < count; ++i) {
                    Message msg = this.pendingMessages.get(i);
                    if (!msg.getConversationType().equals((Object)conversationType) || !msg.getTargetId().equals(targetId) || msg.getMessageId() != messageId) continue;
                    this.pendingMessages.remove(msg);
                    break;
                }
                if (this.pendingMessages.size() == 0) {
                    this.executingMessage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void polling() {
            List<Message> list = this.pendingMessages;
            synchronized (list) {
                RLog.d((String)TAG, (String)("polling " + this.pendingMessages.size()));
                if (this.pendingMessages.size() > 0) {
                    this.executingMessage = this.pendingMessages.remove(0);
                    SendMediaManager.this.executorService.submit(this);
                } else {
                    this.pendingMessages.clear();
                    this.executingMessage = null;
                }
            }
        }

        @Override
        public void run() {
            final Event.OnReceiveMessageProgressEvent result = new Event.OnReceiveMessageProgressEvent();
            result.setMessage(this.executingMessage);
            final String originLocalPath = ((SightMessage)this.executingMessage.getContent()).getLocalPath().toString().substring(7);
            final String compressPath = RongUtils.getImageSavePath((Context)RongContext.getInstance()) + File.separator + "VID_" + new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA).format(new Date()) + ".mp4";
            VideoCompress.compressVideo(originLocalPath, compressPath, new VideoCompress.CompressListener(){

                @Override
                public void onStart() {
                    RongContext.getInstance().getEventBus().post(result);
                    RLog.d((String)TAG, (String)"Compressing video file starts.");
                }

                @Override
                public void onSuccess() {
                    ((SightMessage)UploadController.this.executingMessage.getContent()).setLocalPath(Uri.parse((String)("file://" + originLocalPath)));
                    RongIM.getInstance().sendMediaMessage(UploadController.this.executingMessage, RongContext.getInstance().getString(R.string.rc_message_content_sight), null, new IRongCallback.ISendMediaMessageCallback(){

                        public void onAttached(Message message) {
                        }

                        public void onSuccess(Message message) {
                            FileUtils.removeFile((String)compressPath);
                            UploadController.this.polling();
                        }

                        public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                            FileUtils.removeFile((String)compressPath);
                            UploadController.this.polling();
                        }

                        public void onProgress(Message message, int progress) {
                        }

                        public void onCanceled(Message message) {
                        }
                    });
                    RLog.d((String)TAG, (String)"Compressing video file successes.");
                }

                @Override
                public void onFail() {
                    Toast.makeText((Context)RongContext.getInstance(), (CharSequence)RongContext.getInstance().getString(R.string.rc_picsel_video_corrupted), (int)0).show();
                    UploadController.this.polling();
                    RLog.d((String)TAG, (String)"Compressing video file failed.");
                }

                @Override
                public void onProgress(float percent) {
                }
            });
        }
    }

    static class SingletonHolder {
        static SendMediaManager sInstance = new SendMediaManager();

        SingletonHolder() {
        }
    }
}

