/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.mention;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.rong.imkit.mention.MentionBlock;
import io.rong.imkit.mention.RongMentionManager;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DraftHelper {
    private static final String CONTENT = "content";
    private static final String MENTION = "mention";
    private String content;
    private List<MentionBlock> mentionBlocks;

    public DraftHelper(String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jsonObject = new JSONObject(s);
                this.content = jsonObject.getString(CONTENT);
                String mentionInfo = jsonObject.optString(MENTION);
                this.mentionBlocks = this.getMentionBlocks(mentionInfo);
            }
            catch (JSONException e) {
                this.content = s;
            }
        }
    }

    public static String encode(String content, String mentionBlocks) {
        if (TextUtils.isEmpty((CharSequence)mentionBlocks)) {
            return content;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            return jsonObject.putOpt(CONTENT, (Object)content).putOpt(MENTION, (Object)mentionBlocks).toString();
        }
        catch (JSONException e) {
            return content;
        }
    }

    public String decode() {
        return this.content;
    }

    public void restoreMentionInfo() {
        if (this.mentionBlocks != null) {
            for (MentionBlock mentionBlock : this.mentionBlocks) {
                RongMentionManager.getInstance().addMentionBlock(mentionBlock);
            }
        }
    }

    public static String getDraftContent(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            return jsonObject.getString(CONTENT);
        }
        catch (Exception e) {
            return json;
        }
    }

    @Nullable
    private List<MentionBlock> getMentionBlocks(String mentionInfo) {
        try {
            JSONArray jsonArray = new JSONArray(mentionInfo);
            ArrayList<MentionBlock> list = new ArrayList<MentionBlock>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String s = jsonArray.getString(i);
                MentionBlock mentionBlock = new MentionBlock(s);
                list.add(mentionBlock);
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }
}

