/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.mention.DraftHelper;
import io.rong.imkit.model.ConversationKey;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.UserInfo;
import io.rong.message.VoiceMessage;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UIConversation
implements Parcelable {
    private static final String TAG = "UIConversation";
    private String conversationTitle;
    private Uri portrait;
    private Spannable conversationContent;
    private MessageContent messageContent;
    private long conversationTime;
    private int unReadMessageCount;
    private boolean isTop;
    private Conversation.ConversationType conversationType;
    private Message.SentStatus sentStatus;
    private Message.ReceivedStatus receivedStatus;
    private String targetId;
    private String senderId;
    private boolean isGathered;
    private Map<String, Integer> gatheredConversations;
    private Conversation.ConversationNotificationStatus notificationBlockStatus;
    private String draft;
    private int latestMessageId;
    private boolean extraFlag;
    private boolean isMentioned;
    private UserInfo senderUserInfo;
    private String extra;
    private Context mContext;
    private long syncReadReceiptTime;
    private Set<String> nicknameIds;
    private UnreadRemindType mUnreadType = UnreadRemindType.REMIND_WITH_COUNTING;
    public static final Parcelable.Creator<UIConversation> CREATOR = new Parcelable.Creator<UIConversation>(){

        public UIConversation createFromParcel(Parcel source) {
            return new UIConversation();
        }

        public UIConversation[] newArray(int size) {
            return new UIConversation[size];
        }
    };

    public void setSyncReadReceiptTime(long syncReadReceiptTime) {
        this.syncReadReceiptTime = syncReadReceiptTime;
    }

    public long getSyncReadReceiptTime() {
        return this.syncReadReceiptTime;
    }

    public static UIConversation obtain(Message message, boolean isGathered) {
        return UIConversation.obtain((Context)RongContext.getInstance(), message, isGathered);
    }

    public static UIConversation obtain(Conversation conversation, boolean isGathered) {
        return UIConversation.obtain((Context)RongContext.getInstance(), conversation, isGathered);
    }

    public static UIConversation obtain(Context context, Message message, boolean isGathered) {
        String title;
        UIConversation uiConversation = new UIConversation(context);
        Conversation.ConversationType conversationType = message.getConversationType();
        String targetId = message.getTargetId();
        Uri portrait = null;
        if (isGathered) {
            title = RongContext.getInstance().getGatheredConversationTitle(conversationType);
        } else {
            title = RongContext.getInstance().getConversationTemplate(conversationType.getName()).getTitle(targetId);
            portrait = RongContext.getInstance().getConversationTemplate(conversationType.getName()).getPortraitUri(targetId);
        }
        ConversationKey key = ConversationKey.obtain(targetId, conversationType);
        Conversation.ConversationNotificationStatus notificationStatus = RongContext.getInstance().getConversationNotifyStatusFromCache(key);
        uiConversation.updateConversation(message, isGathered);
        uiConversation.conversationTitle = title;
        uiConversation.notificationBlockStatus = notificationStatus == null ? Conversation.ConversationNotificationStatus.NOTIFY : notificationStatus;
        uiConversation.portrait = portrait;
        if (conversationType.equals((Object)Conversation.ConversationType.GROUP)) {
            GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(message.getTargetId(), message.getSenderUserId());
            UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            if (groupUserInfo != null && userInfo != null) {
                uiConversation.senderUserInfo = new UserInfo(message.getSenderUserId(), groupUserInfo.getNickname(), userInfo.getPortraitUri());
                uiConversation.nicknameIds.add(message.getSenderUserId());
            } else {
                uiConversation.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            }
        } else if ((conversationType.equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE) || conversationType.equals((Object)Conversation.ConversationType.PUBLIC_SERVICE)) && targetId.equals(message.getSenderUserId())) {
            ConversationKey mKey = ConversationKey.obtain(targetId, conversationType);
            PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
            if (publicServiceProfile != null) {
                uiConversation.senderUserInfo = new UserInfo(targetId, publicServiceProfile.getName(), publicServiceProfile.getPortraitUri());
            }
        } else {
            uiConversation.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
        }
        uiConversation.senderId = message.getSenderUserId();
        uiConversation.gatheredConversations.put(message.getConversationType().getName() + message.getTargetId(), 0);
        return uiConversation;
    }

    public void updateConversation(Message message, boolean isGathered) {
        boolean isCount;
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        MentionedInfo mentionedInfo = message.getContent().getMentionedInfo();
        boolean mentioned = mentionedInfo != null && (mentionedInfo.getType().equals((Object)MentionedInfo.MentionedType.ALL) && !message.getSenderUserId().equals(RongIMClient.getInstance().getCurrentUserId()) || mentionedInfo.getType().equals((Object)MentionedInfo.MentionedType.PART) && mentionedInfo.getMentionedUserIdList() != null && mentionedInfo.getMentionedUserIdList().contains(RongIMClient.getInstance().getCurrentUserId()));
        this.conversationType = message.getConversationType();
        this.targetId = message.getTargetId();
        this.receivedStatus = message.getReceivedStatus();
        if (message.getSentTime() > this.syncReadReceiptTime) {
            this.sentStatus = message.getSentStatus();
        }
        this.conversationTime = message.getSentTime();
        this.isGathered = isGathered;
        this.messageContent = message.getContent();
        this.latestMessageId = message.getMessageId();
        this.isMentioned = !isGathered && (this.isMentioned || mentioned);
        boolean bl = isCount = msgTag != null && (msgTag.flag() & 3) == 3 && message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE);
        if (isCount && !message.getReceivedStatus().isRead()) {
            ++this.unReadMessageCount;
        }
        if (isGathered && isCount) {
            String key = this.conversationType.getName() + this.targetId;
            Set<String> set = this.gatheredConversations.keySet();
            if (set.contains(key)) {
                int count = this.gatheredConversations.get(key);
                this.gatheredConversations.put(key, count + 1);
            } else {
                this.gatheredConversations.put(key, 1);
            }
        }
        if (!message.getSenderUserId().equals(this.senderId)) {
            if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP)) {
                GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(message.getTargetId(), message.getSenderUserId());
                UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
                if (groupUserInfo != null && userInfo != null) {
                    this.senderUserInfo = new UserInfo(message.getSenderUserId(), groupUserInfo.getNickname(), userInfo.getPortraitUri());
                    this.nicknameIds.add(message.getSenderUserId());
                } else {
                    this.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
                }
            } else if ((this.conversationType.equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE) || this.conversationType.equals((Object)Conversation.ConversationType.PUBLIC_SERVICE)) && this.targetId.equals(message.getSenderUserId())) {
                ConversationKey mKey = ConversationKey.obtain(this.targetId, this.conversationType);
                PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                if (publicServiceProfile != null) {
                    this.senderUserInfo = new UserInfo(this.targetId, publicServiceProfile.getName(), publicServiceProfile.getPortraitUri());
                }
            } else {
                this.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
            }
            this.senderId = message.getSenderUserId();
        }
        this.buildContent(this.senderUserInfo);
    }

    public static UIConversation obtain(Context context, Conversation conversation, boolean isGathered) {
        UIConversation uiConversation = new UIConversation(context);
        uiConversation.gatheredConversations.put(conversation.getConversationType().getName() + conversation.getTargetId(), 0);
        uiConversation.updateConversation(conversation, isGathered);
        return uiConversation;
    }

    public void updateConversation(Conversation conversation, boolean isGathered) {
        String portrait = null;
        if (conversation.getSentTime() >= this.conversationTime) {
            String title;
            if (isGathered) {
                title = RongContext.getInstance().getGatheredConversationTitle(conversation.getConversationType());
            } else {
                String string2 = title = this.conversationTitle == null ? conversation.getConversationTitle() : this.conversationTitle;
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title = RongContext.getInstance().getConversationTemplate(conversation.getConversationType().getName()).getTitle(conversation.getTargetId());
                }
                String string3 = portrait = this.portrait != null ? this.portrait.toString() : this.filterConversationPortrait(conversation.getPortraitUrl());
                if (TextUtils.isEmpty((CharSequence)portrait)) {
                    Uri url = RongContext.getInstance().getConversationTemplate(conversation.getConversationType().getName()).getPortraitUri(conversation.getTargetId());
                    portrait = url != null ? url.toString() : null;
                }
            }
            this.conversationType = conversation.getConversationType();
            this.targetId = conversation.getTargetId();
            this.conversationTitle = title;
            this.portrait = portrait != null ? Uri.parse((String)portrait) : null;
            this.receivedStatus = conversation.getReceivedStatus();
            this.sentStatus = conversation.getSentStatus();
            this.conversationTime = conversation.getSentTime();
            this.notificationBlockStatus = conversation.getNotificationStatus() == null ? Conversation.ConversationNotificationStatus.NOTIFY : conversation.getNotificationStatus();
            this.draft = isGathered ? null : DraftHelper.getDraftContent(conversation.getDraft());
            this.isGathered = isGathered;
            this.isTop = !isGathered && conversation.isTop();
            this.messageContent = conversation.getLatestMessage();
            this.latestMessageId = conversation.getLatestMessageId();
            this.senderId = conversation.getSenderUserId();
            boolean bl = this.isMentioned = !isGathered && conversation.getMentionedCount() > 0;
            if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP)) {
                if (this.latestMessageId >= 0) {
                    GroupUserInfo groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(this.targetId, this.senderId);
                    UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(this.senderId);
                    if (groupUserInfo != null && userInfo != null) {
                        this.senderUserInfo = new UserInfo(this.senderId, groupUserInfo.getNickname(), userInfo.getPortraitUri());
                        this.nicknameIds.add(this.senderId);
                    } else {
                        this.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(this.senderId);
                    }
                }
            } else if ((this.conversationType.equals((Object)Conversation.ConversationType.APP_PUBLIC_SERVICE) || this.conversationType.equals((Object)Conversation.ConversationType.PUBLIC_SERVICE)) && this.targetId.equals(this.senderId)) {
                ConversationKey mKey = ConversationKey.obtain(this.targetId, this.conversationType);
                PublicServiceProfile publicServiceProfile = RongContext.getInstance().getPublicServiceInfoFromCache(mKey.getKey());
                if (publicServiceProfile != null) {
                    this.senderUserInfo = new UserInfo(this.targetId, publicServiceProfile.getName(), publicServiceProfile.getPortraitUri());
                }
            } else {
                this.senderUserInfo = RongUserInfoManager.getInstance().getUserInfo(this.senderId);
            }
            this.buildContent(this.senderUserInfo);
        }
        if (isGathered) {
            this.unReadMessageCount += conversation.getUnreadMessageCount();
            this.gatheredConversations.put(conversation.getConversationType().getName() + conversation.getTargetId(), conversation.getUnreadMessageCount());
        } else {
            this.unReadMessageCount = conversation.getUnreadMessageCount();
        }
    }

    private void buildContent(UserInfo userInfo) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (this.messageContent == null) {
            builder.append((CharSequence)"");
        } else {
            ProviderTag providerTag = RongContext.getInstance().getMessageProviderTag(this.messageContent.getClass());
            IContainerItemProvider.MessageProvider messageProvider = RongContext.getInstance().getMessageTemplate(this.messageContent.getClass());
            if (providerTag == null || messageProvider == null) {
                builder.append((CharSequence)"");
            } else {
                Spannable summary = null;
                if (this.mContext != null && (summary = messageProvider.getContentSummary(this.mContext, this.messageContent)) == null) {
                    Message message = Message.obtain((String)this.targetId, (Conversation.ConversationType)this.conversationType, (MessageContent)this.messageContent);
                    UIMessage uiMessage = UIMessage.obtain(message);
                    summary = messageProvider.getSummary(uiMessage);
                }
                boolean isShowName = providerTag.showSummaryWithName();
                String curUserId = RongIM.getInstance().getCurrentUserId();
                if (summary == null) {
                    builder.append((CharSequence)"");
                } else {
                    if (this.messageContent instanceof VoiceMessage) {
                        boolean isListened = this.receivedStatus.isListened();
                        if (this.senderId.equals(curUserId) || isListened) {
                            summary.setSpan((Object)new ForegroundColorSpan(RongContext.getInstance().getResources().getColor(R.color.rc_text_color_secondary)), 0, summary.length(), 33);
                        } else {
                            summary.setSpan((Object)new ForegroundColorSpan(RongContext.getInstance().getResources().getColor(R.color.rc_voice_color)), 0, summary.length(), 33);
                        }
                    }
                    if (this.isGathered) {
                        String name = RongContext.getInstance().getConversationTemplate(this.conversationType.getName()).getTitle(this.targetId);
                        builder.append((CharSequence)String.format("%s: ", name)).append((CharSequence)summary);
                    } else if (!TextUtils.isEmpty((CharSequence)this.draft) && !this.isMentioned) {
                        builder.append((CharSequence)this.draft);
                    } else if (this.senderId.equals(curUserId)) {
                        builder.append((CharSequence)summary);
                    } else {
                        String name;
                        String string2 = name = userInfo != null ? userInfo.getName() : this.senderId;
                        if ((this.conversationType.equals((Object)Conversation.ConversationType.GROUP) || this.conversationType.equals((Object)Conversation.ConversationType.DISCUSSION)) && isShowName) {
                            GroupUserInfo groupUserInfo;
                            if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(this.targetId, this.senderId)) != null && !TextUtils.isEmpty((CharSequence)groupUserInfo.getNickname())) {
                                name = groupUserInfo.getNickname();
                            }
                            builder.append((CharSequence)String.format("%s: ", name)).append((CharSequence)summary);
                        } else {
                            builder.append((CharSequence)summary);
                        }
                    }
                }
            }
        }
        this.conversationContent = builder;
    }

    private String filterConversationPortrait(String portrait) {
        File file;
        if (!TextUtils.isEmpty((CharSequence)portrait) && (portrait.toLowerCase().startsWith("file") ? (file = new File(portrait.substring(7))).exists() : portrait.toLowerCase().startsWith("http"))) {
            return portrait;
        }
        return "";
    }

    public void clearLastMessage() {
        this.messageContent = null;
        this.latestMessageId = 0;
        this.conversationContent = null;
        this.unReadMessageCount = 0;
        this.isMentioned = false;
        this.sentStatus = Message.SentStatus.DESTROYED;
    }

    public void clearUnRead(Conversation.ConversationType conversationType, String targetId) {
        if (this.isGathered) {
            String key = conversationType.getName() + targetId;
            this.gatheredConversations.put(key, 0);
            this.unReadMessageCount = 0;
            Collection<Integer> collection = this.gatheredConversations.values();
            for (int count : collection) {
                this.unReadMessageCount += count;
            }
        } else {
            this.unReadMessageCount = 0;
            this.isMentioned = false;
        }
    }

    public void updateConversation(UserInfo userInfo) {
        if (this.isGathered) {
            this.conversationTitle = RongContext.getInstance().getGatheredConversationTitle(this.conversationType);
            this.buildContent(userInfo);
        } else if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP) || this.conversationType.equals((Object)Conversation.ConversationType.DISCUSSION)) {
            if (this.senderId != null && userInfo.getUserId().equals(this.senderId)) {
                this.senderUserInfo = userInfo;
                this.buildContent(userInfo);
            }
        } else if (this.conversationType == Conversation.ConversationType.ENCRYPTED) {
            if (this.targetId.endsWith(userInfo.getUserId())) {
                this.conversationTitle = userInfo.getName();
                this.buildContent(userInfo);
            }
        } else if (userInfo.getUserId().equals(this.targetId)) {
            this.conversationTitle = userInfo.getName();
            this.portrait = userInfo.getPortraitUri();
            this.buildContent(userInfo);
        }
    }

    public void updateConversation(Group group) {
        if (this.isGathered) {
            this.conversationTitle = RongContext.getInstance().getGatheredConversationTitle(this.conversationType);
            this.buildContent(this.senderUserInfo);
        } else if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP) && group.getId().equals(this.targetId)) {
            this.conversationTitle = group.getName();
            this.portrait = group.getPortraitUri();
        }
    }

    public void updateConversation(Discussion discussion) {
        if (this.isGathered) {
            this.conversationTitle = RongContext.getInstance().getGatheredConversationTitle(this.conversationType);
            this.buildContent(this.senderUserInfo);
        } else if (this.conversationType.equals((Object)Conversation.ConversationType.DISCUSSION) && discussion.getId().equals(this.targetId)) {
            this.conversationTitle = discussion.getName();
        }
    }

    public void updateConversation(GroupUserInfo groupUserInfo) {
        UserInfo userInfo = new UserInfo(groupUserInfo.getUserId(), groupUserInfo.getNickname(), this.portrait);
        this.addNickname(groupUserInfo.getUserId());
        this.senderUserInfo = new UserInfo(groupUserInfo.getUserId(), groupUserInfo.getNickname(), null);
        this.buildContent(userInfo);
    }

    public boolean getExtraFlag() {
        return this.extraFlag;
    }

    public void setExtraFlag(boolean extraFlag) {
        this.extraFlag = extraFlag;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    private UIConversation(Context context) {
        this.mContext = context;
        this.nicknameIds = new HashSet<String>();
        this.gatheredConversations = new HashMap<String, Integer>();
    }

    private UIConversation() {
        this.nicknameIds = new HashSet<String>();
        this.gatheredConversations = new HashMap<String, Integer>();
    }

    public void setUIConversationTitle(String title) {
        this.conversationTitle = title;
    }

    public String getUIConversationTitle() {
        return this.conversationTitle;
    }

    public void setIconUrl(Uri iconUrl) {
        this.portrait = iconUrl;
    }

    public Uri getIconUrl() {
        return this.portrait;
    }

    public void setConversationContent(Spannable content) {
        this.conversationContent = content;
    }

    public Spannable getConversationContent() {
        return this.conversationContent;
    }

    public void setMessageContent(MessageContent content) {
        this.messageContent = content;
    }

    public MessageContent getMessageContent() {
        return this.messageContent;
    }

    public void setUIConversationTime(long time) {
        this.conversationTime = time;
    }

    public long getUIConversationTime() {
        return this.conversationTime;
    }

    public void setUnReadMessageCount(int count) {
        this.unReadMessageCount = count;
    }

    public int getUnReadMessageCount() {
        return this.unReadMessageCount;
    }

    public void setTop(boolean value) {
        this.isTop = value;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public void setConversationType(Conversation.ConversationType type) {
        this.conversationType = type;
    }

    public Conversation.ConversationType getConversationType() {
        return this.conversationType;
    }

    public void setSentStatus(Message.SentStatus status) {
        this.sentStatus = status;
    }

    public Message.SentStatus getSentStatus() {
        return this.sentStatus;
    }

    public void setConversationTargetId(String id2) {
        this.targetId = id2;
    }

    public String getConversationTargetId() {
        return this.targetId;
    }

    public void setConversationSenderId(String id2) {
        this.senderId = id2;
    }

    public String getConversationSenderId() {
        return this.senderId;
    }

    public void setConversationGatherState(boolean state) {
        this.isGathered = state;
    }

    public boolean getConversationGatherState() {
        return this.isGathered;
    }

    public void setNotificationStatus(Conversation.ConversationNotificationStatus status) {
        this.notificationBlockStatus = status;
    }

    public Conversation.ConversationNotificationStatus getNotificationStatus() {
        return this.notificationBlockStatus;
    }

    public void setDraft(String content) {
        this.draft = content;
    }

    public String getDraft() {
        return this.draft;
    }

    public void setLatestMessageId(int id2) {
        this.latestMessageId = id2;
    }

    public int getLatestMessageId() {
        return this.latestMessageId;
    }

    public void addNickname(String userId) {
        this.nicknameIds.add(userId);
    }

    public void removeNickName(String userId) {
        this.nicknameIds.remove(userId);
    }

    public boolean hasNickname(String userId) {
        return this.nicknameIds.contains(userId);
    }

    public void setMentionedFlag(boolean flag) {
        this.isMentioned = flag;
    }

    public boolean getMentionedFlag() {
        return this.isMentioned;
    }

    public void setUnreadType(UnreadRemindType type) {
        this.mUnreadType = type;
    }

    public UnreadRemindType getUnReadType() {
        return this.mUnreadType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }

    public static enum UnreadRemindType {
        NO_REMIND,
        REMIND_ONLY,
        REMIND_WITH_COUNTING;

    }
}

