/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.plugin.location.AMapLocationActivity;
import io.rong.imkit.plugin.location.AMapLocationActivity2D;
import io.rong.imkit.utilities.PermissionCheckUtil;

public class DefaultLocationPlugin
implements IPluginModule,
IPluginRequestPermissionResultCallback {
    @Override
    public Drawable obtainDrawable(Context context) {
        return context.getResources().getDrawable(R.drawable.rc_ext_plugin_location_selector);
    }

    @Override
    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugin_location);
    }

    @Override
    public void onClick(Fragment currentFragment, RongExtension extension) {
        String[] permissions = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_NETWORK_STATE"};
        if (PermissionCheckUtil.checkPermissions((Context)currentFragment.getActivity(), permissions)) {
            this.startLocationActivity(currentFragment, extension);
        } else {
            extension.requestPermissionForPluginResult(permissions, 255, this);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    private void startLocationActivity(Fragment fragment, RongExtension extension) {
        Intent intent = extension.getContext().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent((Context)fragment.getActivity(), AMapLocationActivity2D.class) : new Intent((Context)fragment.getActivity(), AMapLocationActivity.class);
        extension.startActivityForPluginResult(intent, 1, this);
    }

    @Override
    public boolean onRequestPermissionResult(Fragment fragment, RongExtension extension, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionCheckUtil.checkPermissions((Context)fragment.getActivity(), permissions)) {
            this.startLocationActivity(fragment, extension);
        } else {
            extension.showRequestPermissionFailedAlter(PermissionCheckUtil.getNotGrantedPermissionMsg((Context)fragment.getActivity(), permissions, grantResults));
        }
        return true;
    }
}

