/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.plugin.location;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.amap.api.services.core.PoiItem;
import com.amap.api.services.poisearch.PoiResult;
import com.amap.api.services.poisearch.PoiSearch;
import io.rong.imkit.R;
import java.util.ArrayList;
import java.util.List;

public class SearchLocationActivity
extends Activity {
    private EditText mSearchEditText;
    private ImageView mPressBackImageView;
    private ListView searchListView;
    private TextView searchNoResult;
    private SearchListAdapter searchListAdapter;
    private String filterString;
    private final int PAGE_COUNT = 20;
    private int currentPage = 1;
    private String cityCode = "";
    private AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            View lastVisibleItemView;
            if (firstVisibleItem != 0 && firstVisibleItem + visibleItemCount == totalItemCount && (lastVisibleItemView = SearchLocationActivity.this.searchListView.getChildAt(SearchLocationActivity.this.searchListView.getChildCount() - 1)) != null && lastVisibleItemView.getBottom() == SearchLocationActivity.this.searchListView.getHeight()) {
                SearchLocationActivity.this.searchNextPageByKeyword(SearchLocationActivity.this.filterString);
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_location_search_activity);
        Intent intent = this.getIntent();
        this.cityCode = intent.getStringExtra("city code");
        this.initView();
    }

    private void initView() {
        this.mSearchEditText = (EditText)this.findViewById(R.id.rc_et_search);
        this.mPressBackImageView = (ImageView)this.findViewById(R.id.rc_iv_press_back);
        this.searchListView = (ListView)this.findViewById(R.id.rc_filtered_location_list);
        this.searchNoResult = (TextView)this.findViewById(R.id.rc_tv_search_no_results);
        this.mSearchEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SearchLocationActivity.this.filterString = s.toString();
                SearchLocationActivity.this.searchLocationByKeyword(SearchLocationActivity.this.filterString);
            }
        });
        this.mSearchEditText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int DRAWABLE_RIGHT = 2;
                if (event.getAction() == 1 && event.getRawX() >= (float)(SearchLocationActivity.this.mSearchEditText.getRight() - 2 * SearchLocationActivity.this.mSearchEditText.getCompoundDrawables()[2].getBounds().width())) {
                    SearchLocationActivity.this.mSearchEditText.setText((CharSequence)"");
                    SearchLocationActivity.this.mSearchEditText.clearFocus();
                    return true;
                }
                return false;
            }
        });
        this.searchListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SearchLocationInfo searchLocationInfo = (SearchLocationInfo)SearchLocationActivity.this.searchListAdapter.getItem(position);
                Intent intent = new Intent();
                intent.putExtra("longitude", searchLocationInfo.getLongitude());
                intent.putExtra("latitude", searchLocationInfo.getLatitude());
                intent.putExtra("poi", searchLocationInfo.getPoi());
                SearchLocationActivity.this.setResult(-1, intent);
                SearchLocationActivity.this.finish();
            }
        });
        this.mPressBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchLocationActivity.this.finish();
            }
        });
        this.searchListView.setOnScrollListener(this.onScrollListener);
    }

    private void searchLocationByKeyword(final String keyword) {
        String searchCityCode = this.cityCode;
        if (TextUtils.isEmpty((CharSequence)this.cityCode)) {
            searchCityCode = "010";
        }
        PoiSearch.Query query = new PoiSearch.Query(keyword, "", searchCityCode);
        query.setPageSize(20);
        this.currentPage = 1;
        query.setPageNum(this.currentPage);
        PoiSearch poiSearch = new PoiSearch((Context)this, query);
        poiSearch.setOnPoiSearchListener(new PoiSearch.OnPoiSearchListener(){

            public void onPoiSearched(PoiResult poiResult, int i) {
                if (poiResult != null && poiResult.getPois().size() > 0) {
                    ArrayList poiItemList = poiResult.getPois();
                    ArrayList<SearchLocationInfo> searchLocationInfoList = new ArrayList<SearchLocationInfo>();
                    for (int j = 0; j < poiItemList.size(); ++j) {
                        PoiItem poiItem = (PoiItem)poiItemList.get(j);
                        SearchLocationInfo searchLocationInfo = new SearchLocationInfo(poiItem.getTitle(), poiItem.getSnippet());
                        searchLocationInfo.setLongitude(poiItem.getLatLonPoint().getLongitude());
                        searchLocationInfo.setLatitude(poiItem.getLatLonPoint().getLatitude());
                        searchLocationInfo.setPoi(poiItem.getTitle());
                        searchLocationInfoList.add(searchLocationInfo);
                    }
                    SearchLocationActivity.this.searchNoResult.setVisibility(8);
                    SearchLocationActivity.this.searchListView.setVisibility(0);
                    SearchLocationActivity.this.searchListAdapter = new SearchListAdapter((Context)SearchLocationActivity.this, searchLocationInfoList, keyword);
                    SearchLocationActivity.this.searchListView.setAdapter((ListAdapter)SearchLocationActivity.this.searchListAdapter);
                } else {
                    if (SearchLocationActivity.this.filterString.equals("")) {
                        SearchLocationActivity.this.searchNoResult.setVisibility(8);
                    } else {
                        SearchLocationActivity.this.searchNoResult.setVisibility(0);
                        SearchLocationActivity.this.searchNoResult.setText((CharSequence)SearchLocationActivity.this.getResources().getString(R.string.rc_ext_search_no_result));
                    }
                    SearchLocationActivity.this.searchListView.setVisibility(8);
                }
            }

            public void onPoiItemSearched(PoiItem poiItem, int i) {
            }
        });
        poiSearch.searchPOIAsyn();
    }

    private void searchNextPageByKeyword(String keyword) {
        String searchCityCode = this.cityCode;
        if (TextUtils.isEmpty((CharSequence)this.cityCode)) {
            searchCityCode = "010";
        }
        PoiSearch.Query query = new PoiSearch.Query(keyword, "", searchCityCode);
        query.setPageSize(20);
        query.setPageNum(++this.currentPage);
        PoiSearch poiSearch = new PoiSearch((Context)this, query);
        poiSearch.setOnPoiSearchListener(new PoiSearch.OnPoiSearchListener(){

            public void onPoiSearched(PoiResult poiResult, int i) {
                if (poiResult != null && poiResult.getPois().size() > 0) {
                    ArrayList poiItemList = poiResult.getPois();
                    ArrayList<SearchLocationInfo> searchLocationInfoList = new ArrayList<SearchLocationInfo>();
                    for (int j = 0; j < poiItemList.size(); ++j) {
                        PoiItem poiItem = (PoiItem)poiItemList.get(j);
                        SearchLocationInfo searchLocationInfo = new SearchLocationInfo(poiItem.getTitle(), poiItem.getSnippet());
                        searchLocationInfo.setLongitude(poiItem.getLatLonPoint().getLongitude());
                        searchLocationInfo.setLatitude(poiItem.getLatLonPoint().getLatitude());
                        searchLocationInfo.setPoi(poiItem.getTitle());
                        searchLocationInfoList.add(searchLocationInfo);
                    }
                    SearchLocationActivity.this.searchListAdapter.addItems(searchLocationInfoList);
                    SearchLocationActivity.this.searchListAdapter.notifyDataSetChanged();
                }
            }

            public void onPoiItemSearched(PoiItem poiItem, int i) {
            }
        });
        poiSearch.searchPOIAsyn();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.getCurrentFocus() && event.getAction() == 1) {
            InputMethodManager mInputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            return mInputMethodManager.hideSoftInputFromWindow(this.mSearchEditText.getWindowToken(), 0);
        }
        return super.onTouchEvent(event);
    }

    protected void onResume() {
        this.mSearchEditText.requestFocus();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mSearchEditText, 0);
        super.onResume();
    }

    protected void onPause() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(this.mSearchEditText.getWindowToken(), 0);
        super.onPause();
    }

    private void setLocationTitle(TextView titleView, String locationTitle, String keyword) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        SpannableStringBuilder colorFilterStr = new SpannableStringBuilder((CharSequence)locationTitle);
        int subPosition = locationTitle.toLowerCase().indexOf(keyword.toLowerCase());
        if (subPosition >= 0) {
            colorFilterStr.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.rc_map_search_highlight_color)), subPosition, subPosition + keyword.length(), 17);
            spannableStringBuilder.append((CharSequence)colorFilterStr);
            titleView.setText((CharSequence)spannableStringBuilder);
        } else {
            titleView.setText((CharSequence)locationTitle);
        }
    }

    private void setLocationAddress(TextView addressView, String locationAddress, String keyword) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        SpannableStringBuilder colorFilterStr = new SpannableStringBuilder((CharSequence)locationAddress);
        int subPosition = locationAddress.toLowerCase().indexOf(keyword.toLowerCase());
        if (subPosition >= 0) {
            colorFilterStr.setSpan((Object)new ForegroundColorSpan(this.getResources().getColor(R.color.rc_map_search_highlight_color)), subPosition, subPosition + keyword.length(), 17);
            spannableStringBuilder.append((CharSequence)colorFilterStr);
            addressView.setText((CharSequence)spannableStringBuilder);
            addressView.setText((CharSequence)spannableStringBuilder);
        } else {
            addressView.setText((CharSequence)locationAddress);
        }
    }

    private class SearchLocationInfo {
        String name;
        String address;
        double latitude;
        double longitude;
        String poi;

        public SearchLocationInfo(String name, String address) {
            this.name = name;
            this.address = address;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public String getPoi() {
            return this.poi;
        }

        public void setPoi(String poi) {
            this.poi = poi;
        }
    }

    private class SearchListAdapter
    extends BaseAdapter {
        private List<SearchLocationInfo> searchList = new ArrayList<SearchLocationInfo>();
        private Context context;
        private String keyword;

        public SearchListAdapter(Context context, List<SearchLocationInfo> searchList, String keyword) {
            this.context = context;
            this.searchList = searchList;
            this.keyword = keyword;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            SearchViewHolder searchViewHolder;
            SearchLocationInfo searchLocationInfo = this.searchList.get(position);
            if (convertView == null) {
                searchViewHolder = new SearchViewHolder();
                convertView = View.inflate((Context)this.context, (int)R.layout.rc_location_search_item, null);
                searchViewHolder.tvName = (TextView)convertView.findViewById(R.id.rc_search_name);
                searchViewHolder.tvAddress = (TextView)convertView.findViewById(R.id.rc_search_address);
                convertView.setTag((Object)searchViewHolder);
            } else {
                searchViewHolder = (SearchViewHolder)convertView.getTag();
            }
            SearchLocationActivity.this.setLocationTitle(searchViewHolder.tvName, searchLocationInfo.getName(), this.keyword);
            SearchLocationActivity.this.setLocationAddress(searchViewHolder.tvAddress, searchLocationInfo.getAddress(), this.keyword);
            return convertView;
        }

        public Object getItem(int position) {
            if (this.searchList != null && this.searchList.size() > 0) {
                return this.searchList.get(position);
            }
            return null;
        }

        public void addItems(List<SearchLocationInfo> searchList) {
            if (this.searchList != null) {
                this.searchList.addAll(searchList);
            }
        }

        public long getItemId(int position) {
            return position;
        }

        public int getCount() {
            if (TextUtils.isEmpty((CharSequence)SearchLocationActivity.this.filterString)) {
                return 0;
            }
            return this.searchList.size();
        }

        class SearchViewHolder {
            TextView tvName;
            TextView tvAddress;

            SearchViewHolder() {
            }
        }
    }
}

