/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.userInfoCache;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.RongUserCacheDatabaseHelper;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.List;

class RongDatabaseDao {
    private static final String TAG = "RongDatabaseDao";
    private RongUserCacheDatabaseHelper rongUserCacheDatabaseHelper;
    private SQLiteDatabase db;
    private final String usersTable = "users";
    private final String groupUsersTable = "group_users";
    private final String groupsTable = "groups";
    private final String discussionsTable = "discussions";

    RongDatabaseDao() {
    }

    void open(Context context, String appKey, String currentUserId) {
        RongUserCacheDatabaseHelper.setDbPath(context, appKey, currentUserId);
        try {
            this.rongUserCacheDatabaseHelper = new RongUserCacheDatabaseHelper(context);
            this.db = this.rongUserCacheDatabaseHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            RLog.e((String)TAG, (String)"SQLiteException occur");
            e.printStackTrace();
        }
    }

    void close() {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.db != null) {
            this.db.close();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getUserInfo(String userId) {
        if (userId == null) {
            RLog.w((String)TAG, (String)"getUserInfo userId is invalid");
            return null;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"getUserInfo db is invalid");
            return null;
        }
        UserInfo info = null;
        try (Cursor c = null;){
            c = this.db.query("users", null, "id = ?", new String[]{userId}, null, null, null);
            if (c != null && c.moveToFirst()) {
                String id2 = c.getString(c.getColumnIndex("id"));
                String name = c.getString(c.getColumnIndex("name"));
                String portrait = c.getString(c.getColumnIndex("portrait"));
                String extra = c.getString(c.getColumnIndex("extra"));
                info = new UserInfo(id2, name, Uri.parse((String)portrait));
                info.setExtra(extra);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserInfo> getAllUserInfo() {
        if (this.db == null) {
            RLog.w((String)TAG, (String)"getUserInfo db is invalid");
            return null;
        }
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        try (Cursor c = null;){
            c = this.db.query("users", null, null, null, null, null, null);
            if (c != null) {
                while (c.moveToNext()) {
                    String id2 = c.getString(c.getColumnIndex("id"));
                    String name = c.getString(c.getColumnIndex("name"));
                    String portrait = c.getString(c.getColumnIndex("portrait"));
                    String extra = c.getString(c.getColumnIndex("extra"));
                    UserInfo info = new UserInfo(id2, name, Uri.parse((String)portrait));
                    info.setExtra(extra);
                    userInfoList.add(info);
                }
            }
        }
        return userInfoList;
    }

    synchronized void insertUserInfo(UserInfo userInfo) {
        if (userInfo == null || userInfo.getUserId() == null) {
            RLog.w((String)TAG, (String)"insertUserInfo userId is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"insertUserInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", userInfo.getUserId());
        cv.put("name", userInfo.getName());
        cv.put("portrait", userInfo.getPortraitUri() + "");
        cv.put("extra", userInfo.getExtra());
        this.db.insert("users", null, cv);
    }

    synchronized void updateUserInfo(UserInfo userInfo) {
        if (userInfo == null || userInfo.getUserId() == null) {
            RLog.w((String)TAG, (String)"updateUserInfo userId is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"updateUserInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", userInfo.getUserId());
        cv.put("name", userInfo.getName());
        cv.put("portrait", userInfo.getPortraitUri() + "");
        cv.put("extra", userInfo.getExtra());
        this.db.update("users", cv, "id = ?", new String[]{userInfo.getUserId()});
    }

    synchronized void putUserInfo(UserInfo userInfo) {
        if (userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.getUserId())) {
            RLog.w((String)TAG, (String)"putUserInfo userId is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"putUserInfo db is invalid");
            return;
        }
        try {
            this.db.execSQL("replace into users (id, name, portrait, extra) values (?, ?, ?, ?)", (Object[])new String[]{userInfo.getUserId(), userInfo.getName(), userInfo.getPortraitUri() + "", userInfo.getExtra()});
        }
        catch (SQLException e) {
            RLog.e((String)TAG, (String)"putUserInfo DB if full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupUserInfo getGroupUserInfo(String groupId, String userId) {
        if (userId == null || groupId == null) {
            RLog.w((String)TAG, (String)"getGroupUserInfo parameter is invalid");
            return null;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"getGroupUserInfo db is invalid");
            return null;
        }
        GroupUserInfo info = null;
        try (Cursor c = null;){
            c = this.db.query("group_users", null, "group_id = ? and user_id = ?", new String[]{groupId, userId}, null, null, null);
            if (c != null && c.moveToFirst()) {
                String gId = c.getString(c.getColumnIndex("group_id"));
                String uId = c.getString(c.getColumnIndex("user_id"));
                String nickname = c.getString(c.getColumnIndex("nickname"));
                info = new GroupUserInfo(gId, uId, nickname);
            }
        }
        return info;
    }

    synchronized void insertGroupUserInfo(GroupUserInfo userInfo) {
        if (userInfo == null || userInfo.getGroupId() == null || userInfo.getUserId() == null) {
            RLog.w((String)TAG, (String)"insertGroupUserInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"insertGroupUserInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("group_id", userInfo.getGroupId());
        cv.put("user_id", userInfo.getUserId());
        cv.put("nickname", userInfo.getNickname());
        this.db.insert("group_users", null, cv);
    }

    synchronized void updateGroupUserInfo(GroupUserInfo userInfo) {
        if (userInfo == null || userInfo.getGroupId() == null || userInfo.getUserId() == null) {
            RLog.w((String)TAG, (String)"updateGroupUserInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"updateGroupUserInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("group_id", userInfo.getGroupId());
        cv.put("user_id", userInfo.getUserId());
        cv.put("nickname", userInfo.getNickname());
        this.db.update("group_users", cv, "group_id=? and user_id=?", new String[]{userInfo.getGroupId(), userInfo.getUserId()});
    }

    synchronized void putGroupUserInfo(GroupUserInfo userInfo) {
        if (userInfo == null || userInfo.getGroupId() == null || userInfo.getUserId() == null) {
            RLog.w((String)TAG, (String)"putGroupUserInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"putGroupUserInfo db is invalid");
            return;
        }
        this.db.execSQL("delete from group_users where group_id=? and user_id=?", (Object[])new String[]{userInfo.getGroupId(), userInfo.getUserId()});
        this.db.execSQL("insert into group_users (group_id, user_id, nickname) values (?, ?, ?)", (Object[])new String[]{userInfo.getGroupId(), userInfo.getUserId(), userInfo.getNickname()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Group getGroupInfo(String groupId) {
        if (groupId == null) {
            RLog.w((String)TAG, (String)"getGroupInfo parameter is invalid");
            return null;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"getGroupInfo db is invalid");
            return null;
        }
        Group group = null;
        try (Cursor c = null;){
            c = this.db.query("groups", null, "id = ?", new String[]{groupId}, null, null, null);
            if (c != null && c.moveToFirst()) {
                String id2 = c.getString(c.getColumnIndex("id"));
                String name = c.getString(c.getColumnIndex("name"));
                String portrait = c.getString(c.getColumnIndex("portrait"));
                group = new Group(id2, name, Uri.parse((String)portrait));
            }
        }
        return group;
    }

    synchronized void insertGroupInfo(Group group) {
        if (group == null || group.getId() == null) {
            RLog.w((String)TAG, (String)"insertGroupInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"insertGroupInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", group.getId());
        cv.put("name", group.getName());
        cv.put("portrait", group.getPortraitUri() + "");
        this.db.insert("groups", null, cv);
    }

    synchronized void updateGroupInfo(Group group) {
        if (group == null || group.getId() == null) {
            RLog.w((String)TAG, (String)"updateGroupInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"updateGroupInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", group.getId());
        cv.put("name", group.getName());
        cv.put("portrait", group.getPortraitUri() + "");
        this.db.update("groups", cv, "id = ?", new String[]{group.getId()});
    }

    synchronized void putGroupInfo(Group group) {
        if (group == null || group.getId() == null) {
            RLog.w((String)TAG, (String)"putGroupInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"putGroupInfo db is invalid");
            return;
        }
        this.db.execSQL("replace into groups (id, name, portrait) values (?, ?, ?)", (Object[])new String[]{group.getId(), group.getName(), group.getPortraitUri() == null ? "" : group.getPortraitUri().toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Discussion getDiscussionInfo(String discussionId) {
        if (discussionId == null) {
            RLog.w((String)TAG, (String)"getDiscussionInfo parameter is invalid");
            return null;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"getDiscussionInfo db is invalid");
            return null;
        }
        Discussion discussion = null;
        try (Cursor c = null;){
            c = this.db.query("discussions", null, "id = ?", new String[]{discussionId}, null, null, null);
            if (c != null && c.moveToFirst()) {
                String id2 = c.getString(c.getColumnIndex("id"));
                String name = c.getString(c.getColumnIndex("name"));
                discussion = new Discussion(id2, name);
            }
        }
        return discussion;
    }

    synchronized void insertDiscussionInfo(Discussion discussion) {
        if (discussion == null || discussion.getId() == null) {
            RLog.w((String)TAG, (String)"insertDiscussionInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"insertDiscussionInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", discussion.getId());
        cv.put("name", discussion.getName());
        cv.put("portrait", "");
        this.db.insert("discussions", null, cv);
    }

    synchronized void updateDiscussionInfo(Discussion discussion) {
        if (discussion == null || discussion.getId() == null) {
            RLog.w((String)TAG, (String)"updateDiscussionInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"updateDiscussionInfo db is invalid");
            return;
        }
        ContentValues cv = new ContentValues();
        cv.put("id", discussion.getId());
        cv.put("name", discussion.getName());
        cv.put("portrait", "");
        this.db.update("discussions", cv, "id = ?", new String[]{discussion.getId()});
    }

    synchronized void putDiscussionInfo(Discussion discussion) {
        if (discussion == null || discussion.getId() == null) {
            RLog.w((String)TAG, (String)"putDiscussionInfo parameter is invalid");
            return;
        }
        if (this.db == null) {
            RLog.w((String)TAG, (String)"putDiscussionInfo db is invalid");
            return;
        }
        this.db.execSQL("replace into discussions (id, name, portrait) values (?, ?, ?)", (Object[])new String[]{discussion.getId(), discussion.getName(), ""});
    }
}

