/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import io.rong.imlib.RongIMClient;
import java.util.Locale;

public class LangUtils {
    private static final String LOCALE_CONF_FILE_NAME = "locale.config";
    private static final String APP_LOCALE = "app_locale";
    private static final String APP_PUSH_LANGUAGE = "app_push_language";
    private static Locale systemLocale = Locale.getDefault();

    public static Context getConfigurationContext(Context context) {
        Resources resources = context.getResources();
        Configuration config = new Configuration(resources.getConfiguration());
        Context configurationContext = context;
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList localeList = new LocaleList(new Locale[]{LangUtils.getAppLocale(context).toLocale()});
            LocaleList.setDefault((LocaleList)localeList);
            config.setLocales(localeList);
            configurationContext = context.createConfigurationContext(config);
        }
        return configurationContext;
    }

    public static RCLocale getAppLocale(Context context) {
        SharedPreferences sp = context.getSharedPreferences(LOCALE_CONF_FILE_NAME, 0);
        String locale = sp.getString(APP_LOCALE, "auto");
        return RCLocale.valueOf(locale);
    }

    public static void saveLocale(Context context, RCLocale locale) {
        SharedPreferences sp = context.getSharedPreferences(LOCALE_CONF_FILE_NAME, 0);
        sp.edit().putString(APP_LOCALE, locale.value()).commit();
    }

    public static RongIMClient.PushLanguage getPushLanguage(Context context) {
        SharedPreferences sp = context.getSharedPreferences(LOCALE_CONF_FILE_NAME, 0);
        String language = sp.getString(APP_PUSH_LANGUAGE, "");
        if (language.equals(RongIMClient.PushLanguage.ZH_CN.getMsg())) {
            return RongIMClient.PushLanguage.ZH_CN;
        }
        if (language.equals(RongIMClient.PushLanguage.EN_US.getMsg())) {
            return RongIMClient.PushLanguage.EN_US;
        }
        return null;
    }

    public static void setPushLanguage(Context context, RongIMClient.PushLanguage pushLanguage) {
        SharedPreferences sp = context.getSharedPreferences(LOCALE_CONF_FILE_NAME, 0);
        sp.edit().putString(APP_PUSH_LANGUAGE, pushLanguage.getMsg()).commit();
    }

    public static Locale getSystemLocale() {
        return systemLocale;
    }

    public static void setSystemLocale(Locale locale) {
        systemLocale = locale;
    }

    public static RCLocale getCurrentLanguage(Context context) {
        SharedPreferences sp = context.getSharedPreferences(LOCALE_CONF_FILE_NAME, 0);
        String locale = sp.getString(APP_LOCALE, "auto");
        if (locale.equals("auto")) {
            return LangUtils.getSystemLocale().toString().equals("zh_CN") ? RCLocale.LOCALE_CHINA : RCLocale.LOCALE_US;
        }
        return RCLocale.valueOf(locale);
    }

    public static class RCLocale {
        public static final RCLocale LOCALE_CHINA = new RCLocale("zh");
        public static final RCLocale LOCALE_US = new RCLocale("en");
        public static final RCLocale LOCALE_AUTO = new RCLocale("auto");
        private String rcLocale;

        private RCLocale(String rcLocale) {
            this.rcLocale = rcLocale;
        }

        public String value() {
            return this.rcLocale;
        }

        public Locale toLocale() {
            Locale locale = this.rcLocale.equals(LOCALE_CHINA.value()) ? Locale.CHINESE : (this.rcLocale.equals(LOCALE_US.value()) ? Locale.ENGLISH : LangUtils.getSystemLocale());
            return locale;
        }

        public static RCLocale valueOf(String rcLocale) {
            RCLocale locale = rcLocale.equals(LOCALE_CHINA.value()) ? LOCALE_CHINA : (rcLocale.equals(LOCALE_US.value()) ? LOCALE_US : LOCALE_AUTO);
            return locale;
        }
    }
}

