/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utilities;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.AudioRecord;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.app.Fragment;
import io.rong.common.RLog;
import io.rong.imkit.R;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PermissionCheckUtil {
    private static final String TAG = PermissionCheckUtil.class.getSimpleName();

    public static boolean requestPermissions(Fragment fragment, String[] permissions) {
        return PermissionCheckUtil.requestPermissions(fragment, permissions, 0);
    }

    public static boolean requestPermissions(final Fragment fragment, String[] permissions, int requestCode) {
        if (permissions.length == 0) {
            return true;
        }
        ArrayList<String> permissionsNotGranted = new ArrayList<String>();
        boolean result = false;
        for (int i = 0; i < permissions.length; ++i) {
            if ((PermissionCheckUtil.isFlyme() || Build.VERSION.SDK_INT < 23) && permissions[i].equals("android.permission.RECORD_AUDIO")) {
                PermissionCheckUtil.showPermissionAlert(fragment.getContext(), fragment.getString(R.string.rc_permission_grant_needed) + fragment.getString(R.string.rc_permission_microphone), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (-1 == which) {
                            fragment.startActivity(new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS"));
                        }
                    }
                });
                return false;
            }
            if (PermissionCheckUtil.hasPermission((Context)fragment.getActivity(), permissions[i])) continue;
            permissionsNotGranted.add(permissions[i]);
        }
        if (permissionsNotGranted.size() > 0) {
            fragment.requestPermissions(permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]), requestCode);
        } else {
            result = true;
        }
        return result;
    }

    public static boolean requestPermissions(Activity activity, @NonNull String[] permissions) {
        return PermissionCheckUtil.requestPermissions(activity, permissions, 0);
    }

    @TargetApi(value=23)
    public static boolean requestPermissions(Activity activity, @NonNull String[] permissions, int requestCode) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (permissions.length == 0) {
            return true;
        }
        ArrayList<String> permissionsNotGranted = new ArrayList<String>();
        boolean result = false;
        for (int i = 0; i < permissions.length; ++i) {
            if (PermissionCheckUtil.hasPermission((Context)activity, permissions[i])) continue;
            permissionsNotGranted.add(permissions[i]);
        }
        if (permissionsNotGranted.size() > 0) {
            activity.requestPermissions(permissionsNotGranted.toArray(new String[permissionsNotGranted.size()]), requestCode);
        } else {
            result = true;
        }
        return result;
    }

    public static boolean checkPermissions(Context context, @NonNull String[] permissions) {
        if (permissions == null || permissions.length == 0) {
            return true;
        }
        for (String permission2 : permissions) {
            if (!((PermissionCheckUtil.isFlyme() || Build.VERSION.SDK_INT < 23) && permission2.equals("android.permission.RECORD_AUDIO") ? !PermissionCheckUtil.hasRecordPermision(context) : !PermissionCheckUtil.hasPermission(context, permission2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlyme() {
        String osString = "";
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method get = clz.getMethod("get", String.class, String.class);
            osString = (String)get.invoke(clz, "ro.build.display.id", "");
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"isFlyme", (Throwable)e);
        }
        return osString.toLowerCase().contains("flyme");
    }

    private static boolean hasRecordPermision(Context context) {
        boolean hasPermission = false;
        int bufferSizeInBytes = AudioRecord.getMinBufferSize((int)44100, (int)12, (int)2);
        AudioRecord audioRecord = new AudioRecord(1, 44100, 12, 2, bufferSizeInBytes);
        try {
            audioRecord.startRecording();
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"hasRecordPermision", (Throwable)e);
            hasPermission = false;
        }
        if (audioRecord.getRecordingState() == 3) {
            audioRecord.stop();
            hasPermission = true;
        }
        audioRecord.release();
        return hasPermission;
    }

    public static String getNotGrantedPermissionMsg(Context context, String[] permissions, int[] grantResults) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getResources().getString(R.string.rc_permission_grant_needed));
        sb.append("(");
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] != -1) continue;
            String permissionName = context.getString(context.getResources().getIdentifier("rc_" + permissions[i], "string", context.getPackageName()), new Object[]{0});
            sb.append(permissionName);
            if (i == permissions.length - 1) continue;
            sb.append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getNotGrantedPermissionMsg(Context context, List<String> permissions) {
        HashSet<String> permissionsValue = new HashSet<String>();
        for (String permission2 : permissions) {
            String permissionValue = context.getString(context.getResources().getIdentifier("rc_" + permission2, "string", context.getPackageName()), new Object[]{0});
            permissionsValue.add(permissionValue);
        }
        String result = "(";
        for (String value : permissionsValue) {
            result = result + value + " ";
        }
        result = result.trim() + ")";
        return result;
    }

    @TargetApi(value=11)
    private static void showPermissionAlert(Context context, String content, DialogInterface.OnClickListener listener) {
        new AlertDialog.Builder(context).setMessage((CharSequence)content).setPositiveButton(R.string.rc_confirm, listener).setNegativeButton(R.string.rc_cancel, listener).setCancelable(false).create().show();
    }

    @TargetApi(value=19)
    public static boolean canDrawOverlays(Context context) {
        return PermissionCheckUtil.canDrawOverlays(context, true);
    }

    @TargetApi(value=19)
    public static boolean canDrawOverlays(final Context context, boolean needOpenPermissionSetting) {
        Method method;
        boolean result = true;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                boolean booleanValue = (Boolean)Settings.class.getDeclaredMethod("canDrawOverlays", Context.class).invoke(null, context);
                if (!booleanValue && needOpenPermissionSetting) {
                    ArrayList<String> permissionList = new ArrayList<String>();
                    permissionList.add("android.settings.action.MANAGE_OVERLAY_PERMISSION");
                    PermissionCheckUtil.showPermissionAlert(context, context.getString(R.string.rc_permission_grant_needed) + PermissionCheckUtil.getNotGrantedPermissionMsg(context, permissionList), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            if (-1 == which) {
                                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
                                context.startActivity(intent);
                            }
                        }
                    });
                }
                RLog.i((String)TAG, (String)("isFloatWindowOpAllowed allowed: " + booleanValue));
                return booleanValue;
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)String.format("getDeclaredMethod:canDrawOverlays! Error:%s, etype:%s", e.getMessage(), e.getClass().getCanonicalName()));
                return true;
            }
        }
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        Object systemService = context.getSystemService("appops");
        try {
            method = Class.forName("android.app.AppOpsManager").getMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (NoSuchMethodException e) {
            RLog.e((String)TAG, (String)String.format("NoSuchMethodException method:checkOp! Error:%s", e.getMessage()));
            method = null;
        }
        catch (ClassNotFoundException e) {
            RLog.e((String)TAG, (String)"canDrawOverlays", (Throwable)e);
            method = null;
        }
        if (method != null) {
            try {
                Integer tmp = (Integer)method.invoke(systemService, 24, context.getApplicationInfo().uid, context.getPackageName());
                result = tmp == 0;
            }
            catch (Exception e) {
                RLog.e((String)TAG, (String)String.format("call checkOp failed: %s etype:%s", e.getMessage(), e.getClass().getCanonicalName()));
            }
        }
        RLog.i((String)TAG, (String)("isFloatWindowOpAllowed allowed: " + result));
        return result;
    }

    private static boolean hasPermission(Context context, String permission2) {
        String opStr = AppOpsManagerCompat.permissionToOp((String)permission2);
        if (opStr == null) {
            return true;
        }
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    public static void showRequestPermissionFailedAlter(final Context context, String content) {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -1: {
                        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                        intent.setData(uri);
                        context.startActivity(intent);
                        break;
                    }
                    case -2: {
                        break;
                    }
                }
            }
        };
        new AlertDialog.Builder(context, 16974394).setMessage((CharSequence)content).setPositiveButton(R.string.rc_confirm, listener).setNegativeButton(R.string.rc_cancel, listener).setCancelable(false).create().show();
    }
}

