/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.util.Patterns;
import android.webkit.WebView;
import android.widget.TextView;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RongLinkify {
    public static final int WEB_URLS = 1;
    public static final int EMAIL_ADDRESSES = 2;
    public static final int PHONE_NUMBERS = 4;
    public static final int MAP_ADDRESSES = 8;
    public static final int ALL = 15;
    private static final int PHONE_NUMBER_MINIMUM_DIGITS = 5;
    private static final String WEB_URL_REGEX = "[-a-zA-Z0-9+&@#/%?=~_|!:.,;]*\\.[-a-zA-Z0-9+&@#%=~_|]{2,4}(:[0-9]{1,5})?(/[-a-zA-Z0-9+&@#/%?=~_|!:,;]*)*";
    public static final Pattern WEB_URL = Patterns.WEB_URL;
    private static final String PHONE_NUMBER_REGEX = "(\\d{2,}-\\d{5,})|(\\d{7,})";
    private static final Pattern PHONE_NUMBER = Patterns.PHONE;
    public static final Linkify.MatchFilter sUrlMatchFilter = new Linkify.MatchFilter(){

        public final boolean acceptMatch(CharSequence s, int start, int end) {
            if (start == 0) {
                return true;
            }
            return s.charAt(start - 1) != '@';
        }
    };
    public static final Linkify.MatchFilter sPhoneNumberMatchFilter = new Linkify.MatchFilter(){

        public final boolean acceptMatch(CharSequence s, int start, int end) {
            int digitCount = 0;
            for (int i = start; i < end; ++i) {
                if (!Character.isDigit(s.charAt(i)) || ++digitCount < 5) continue;
                return true;
            }
            return false;
        }
    };
    public static final Linkify.TransformFilter sPhoneNumberTransformFilter = new Linkify.TransformFilter(){

        public final String transformUrl(Matcher match, String url) {
            return Patterns.digitsAndPlusOnly((Matcher)match);
        }
    };

    public static final boolean addLinks(Spannable text, int mask) {
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan((Object)old[i]);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            RongLinkify.gatherLinks(links, text, WEB_URL, new String[]{"http://", "https://", "rtsp://"}, sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            RongLinkify.gatherLinks(links, text, Patterns.EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 4) != 0) {
            RongLinkify.gatherTelLinks(links, text, PHONE_NUMBER);
        }
        if ((mask & 8) != 0) {
            RongLinkify.gatherMapLinks(links, text);
        }
        RongLinkify.pruneOverlaps(links);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            RongLinkify.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    public static final boolean addLinks(TextView text, int mask) {
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (RongLinkify.addLinks((Spannable)t, mask)) {
                RongLinkify.addLinkMovementMethod(text);
                return true;
            }
            return false;
        }
        SpannableString s = SpannableString.valueOf((CharSequence)t);
        if (RongLinkify.addLinks((Spannable)s, mask)) {
            RongLinkify.addLinkMovementMethod(text);
            text.setText((CharSequence)s);
            return true;
        }
        return false;
    }

    private static final void addLinkMovementMethod(TextView t) {
        MovementMethod m = t.getMovementMethod();
        if ((m == null || !(m instanceof LinkMovementMethod)) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public static final void addLinks(TextView text, Pattern pattern, String scheme) {
        RongLinkify.addLinks(text, pattern, scheme, null, null);
    }

    public static final void addLinks(TextView text, Pattern p, String scheme, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        SpannableString s = SpannableString.valueOf((CharSequence)text.getText());
        if (RongLinkify.addLinks((Spannable)s, p, scheme, matchFilter, transformFilter)) {
            text.setText((CharSequence)s);
            RongLinkify.addLinkMovementMethod(text);
        }
    }

    public static final boolean addLinks(Spannable text, Pattern pattern, String scheme) {
        return RongLinkify.addLinks(text, pattern, scheme, null, null);
    }

    public static final boolean addLinks(Spannable s, Pattern p, String scheme, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        boolean hasMatches = false;
        String prefix = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        Matcher m = p.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch((CharSequence)s, start, end);
            }
            if (!allowed) continue;
            String url = RongLinkify.makeUrl(m.group(0), new String[]{prefix}, m, transformFilter);
            RongLinkify.applyLink(url, start, end, s);
            hasMatches = true;
        }
        return hasMatches;
    }

    private static final void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan((Object)span, start, end, 33);
    }

    private static final String makeUrl(String url, String[] prefixes, Matcher m, Linkify.TransformFilter filter) {
        if (filter != null) {
            url = filter.transformUrl(m, url);
        }
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static final void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            String url;
            int start = m.start();
            int end = m.end();
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end)) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = url = RongLinkify.makeUrl(m.group(0), schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static final void gatherTelLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            LinkSpec spec = new LinkSpec();
            spec.url = "tel:" + m.group();
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static final void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string2 = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = WebView.findAddress((String)string2)) != null && (start = string2.indexOf(address)) >= 0) {
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string2 = string2.substring(end);
                base += end;
                String encodedAddress = null;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException e) {
            return;
        }
    }

    private static final void pruneOverlaps(ArrayList<LinkSpec> links) {
        Comparator<LinkSpec> c = new Comparator<LinkSpec>(){

            @Override
            public final int compare(LinkSpec a, LinkSpec b) {
                if (a.start < b.start) {
                    return -1;
                }
                if (a.start > b.start) {
                    return 1;
                }
                if (a.end < b.end) {
                    return 1;
                }
                if (a.end > b.end) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(links, c);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    private static class LinkSpec {
        String url;
        int start;
        int end;

        private LinkSpec() {
        }
    }

    public static interface TransformFilter {
        public String transformUrl(Matcher var1, String var2);
    }

    public static interface MatchFilter {
        public boolean acceptMatch(CharSequence var1, int var2, int var3);
    }
}

