/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.widget.SingleChoiceAdapter;
import java.util.List;

public class SingleChoiceDialog
extends Dialog {
    protected Context mContext;
    protected View mRootView;
    protected TextView mTVTitle;
    protected TextView mButtonOK;
    protected TextView mButtonCancel;
    protected ListView mListView;
    protected List<String> mList;
    protected DialogInterface.OnClickListener mOkClickListener;
    protected DialogInterface.OnClickListener mCancelClickListener;
    private SingleChoiceAdapter<String> mSingleChoiceAdapter;

    public SingleChoiceDialog(Context context, List<String> list) {
        super(context);
        this.mContext = context;
        this.mList = list;
        this.initView(this.mContext);
        this.initData();
    }

    protected void initView(Context context) {
        this.requestWindowFeature(1);
        this.setContentView(R.layout.rc_cs_single_choice_layout);
        this.mRootView = this.findViewById(R.id.rc_cs_rootView);
        this.mRootView.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mTVTitle = (TextView)this.findViewById(R.id.rc_cs_tv_title);
        this.mButtonOK = (Button)this.findViewById(R.id.rc_cs_btn_ok);
        this.mButtonOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SingleChoiceDialog.this.onButtonOK();
            }
        });
        this.mButtonCancel = (Button)this.findViewById(R.id.rc_cs_btn_cancel);
        this.mButtonCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SingleChoiceDialog.this.onButtonCancel();
            }
        });
        this.mListView = (ListView)this.findViewById(R.id.rc_cs_group_dialog_listView);
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        ColorDrawable dw = new ColorDrawable(0);
        dialogWindow.setBackgroundDrawable((Drawable)dw);
    }

    public void setTitle(String title) {
        this.mTVTitle.setText((CharSequence)title);
    }

    public void setOnOKButtonListener(DialogInterface.OnClickListener onClickListener) {
        this.mOkClickListener = onClickListener;
    }

    public void setOnCancelButtonListener(DialogInterface.OnClickListener onClickListener) {
        this.mCancelClickListener = onClickListener;
    }

    protected void onButtonOK() {
        this.dismiss();
        if (this.mOkClickListener != null) {
            this.mOkClickListener.onClick((DialogInterface)this, 0);
        }
    }

    protected void onButtonCancel() {
        this.dismiss();
        if (this.mCancelClickListener != null) {
            this.mCancelClickListener.onClick((DialogInterface)this, 0);
        }
    }

    protected void initData() {
        this.mSingleChoiceAdapter = new SingleChoiceAdapter<String>(this.mContext, this.mList, R.drawable.rc_cs_group_checkbox_selector);
        this.mListView.setAdapter(this.mSingleChoiceAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position != SingleChoiceDialog.this.mSingleChoiceAdapter.getSelectItem()) {
                    if (!SingleChoiceDialog.this.mButtonOK.isEnabled()) {
                        SingleChoiceDialog.this.mButtonOK.setEnabled(true);
                    }
                    SingleChoiceDialog.this.mSingleChoiceAdapter.setSelectItem(position);
                    SingleChoiceDialog.this.mSingleChoiceAdapter.notifyDataSetChanged();
                }
            }
        });
        this.setListViewHeightBasedOnChildren(this.mListView);
    }

    public int getSelectItem() {
        return this.mSingleChoiceAdapter.getSelectItem();
    }

    private void setListViewHeightBasedOnChildren(ListView listView) {
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter == null) {
            return;
        }
        int totalHeight = 0;
        for (int i = 0; i < listAdapter.getCount(); ++i) {
            View listItem = listAdapter.getView(i, null, (ViewGroup)listView);
            listItem.measure(0, 0);
            totalHeight += listItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = (totalHeight += 10) + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }
}

