/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.ConversationListFragment;
import io.rong.imkit.model.ConversationProviderTag;
import io.rong.imkit.model.Event;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.ProviderContainerView;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;

public class ConversationListAdapter
extends BaseAdapter<UIConversation> {
    private static final String TAG = "ConversationListAdapter";
    LayoutInflater mInflater;
    Context mContext;
    private OnPortraitItemClick mOnPortraitItemClick;

    public long getItemId(int position) {
        UIConversation conversation = (UIConversation)this.getItem(position);
        if (conversation == null) {
            return 0L;
        }
        return conversation.hashCode();
    }

    public ConversationListAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    public int findGatheredItem(Conversation.ConversationType type) {
        int index = this.getCount();
        int position = -1;
        while (index-- > 0) {
            UIConversation uiConversation = (UIConversation)this.getItem(index);
            if (!uiConversation.getConversationType().equals((Object)type)) continue;
            position = index;
            break;
        }
        return position;
    }

    public int findPosition(Conversation.ConversationType type, String targetId) {
        int index = this.getCount();
        int position = -1;
        while (index-- > 0) {
            if (!((UIConversation)this.getItem(index)).getConversationType().equals((Object)type) || !((UIConversation)this.getItem(index)).getConversationTargetId().equals(targetId)) continue;
            position = index;
            break;
        }
        return position;
    }

    @Override
    protected View newView(Context context, int position, ViewGroup group) {
        View result = this.mInflater.inflate(R.layout.rc_item_conversation, null);
        ViewHolder holder = new ViewHolder();
        holder.layout = this.findViewById(result, R.id.rc_item_conversation);
        holder.leftImageLayout = this.findViewById(result, R.id.rc_item1);
        holder.rightImageLayout = this.findViewById(result, R.id.rc_item2);
        holder.leftUnReadView = this.findViewById(result, R.id.rc_unread_view_left);
        holder.rightUnReadView = this.findViewById(result, R.id.rc_unread_view_right);
        holder.leftImageView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_left));
        holder.rightImageView = (AsyncImageView)((Object)this.findViewById(result, R.id.rc_right));
        holder.contentView = (ProviderContainerView)((Object)this.findViewById(result, R.id.rc_content));
        holder.unReadMsgCount = (TextView)this.findViewById(result, R.id.rc_unread_message);
        holder.unReadMsgCountRight = (TextView)this.findViewById(result, R.id.rc_unread_message_right);
        holder.unReadMsgCountIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon);
        holder.unReadMsgCountRightIcon = (ImageView)this.findViewById(result, R.id.rc_unread_message_icon_right);
        result.setTag((Object)holder);
        return result;
    }

    @Override
    protected void bindView(View v, int position, final UIConversation data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (data == null) {
            return;
        }
        IContainerItemProvider.ConversationProvider provider = RongContext.getInstance().getConversationTemplate(data.getConversationType().getName());
        if (provider == null) {
            RLog.e((String)TAG, (String)"provider is null");
            return;
        }
        View view = holder.contentView.inflate(provider);
        provider.bindView(view, position, data);
        if (data.isTop()) {
            holder.layout.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.rc_item_top_list_selector));
        } else {
            holder.layout.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.rc_item_list_selector));
        }
        ConversationProviderTag tag = RongContext.getInstance().getConversationProviderTag(data.getConversationType().getName());
        int defaultId = 0;
        defaultId = data.getConversationType().equals((Object)Conversation.ConversationType.GROUP) ? R.drawable.rc_default_group_portrait : (data.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION) ? R.drawable.rc_default_discussion_portrait : R.drawable.rc_default_portrait);
        if (tag.portraitPosition() == 1) {
            holder.leftImageLayout.setVisibility(0);
            holder.leftImageLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ConversationListAdapter.this.mOnPortraitItemClick != null) {
                        ConversationListAdapter.this.mOnPortraitItemClick.onPortraitItemClick(v, data);
                    }
                }
            });
            holder.leftImageLayout.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (ConversationListAdapter.this.mOnPortraitItemClick != null) {
                        ConversationListAdapter.this.mOnPortraitItemClick.onPortraitItemLongClick(v, data);
                    }
                    return true;
                }
            });
            if (data.getConversationGatherState()) {
                holder.leftImageView.setAvatar(null, defaultId);
            } else if (data.getIconUrl() != null) {
                holder.leftImageView.setAvatar(data.getIconUrl().toString(), defaultId);
            } else {
                holder.leftImageView.setAvatar(null, defaultId);
            }
            if (data.getUnReadMessageCount() > 0) {
                holder.unReadMsgCountIcon.setVisibility(0);
                this.setUnReadViewLayoutParams(holder.leftUnReadView, data.getUnReadType());
                if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                    if (data.getUnReadMessageCount() > 99) {
                        holder.unReadMsgCount.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                    } else {
                        holder.unReadMsgCount.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                    }
                    holder.unReadMsgCount.setVisibility(0);
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_count_bg);
                } else {
                    holder.unReadMsgCount.setVisibility(8);
                    holder.unReadMsgCountIcon.setImageResource(R.drawable.rc_unread_remind_list_count);
                }
            } else {
                holder.unReadMsgCountIcon.setVisibility(8);
                holder.unReadMsgCount.setVisibility(8);
            }
            holder.rightImageLayout.setVisibility(8);
        } else if (tag.portraitPosition() == 2) {
            holder.rightImageLayout.setVisibility(0);
            holder.rightImageLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ConversationListAdapter.this.mOnPortraitItemClick != null) {
                        ConversationListAdapter.this.mOnPortraitItemClick.onPortraitItemClick(v, data);
                    }
                }
            });
            holder.rightImageLayout.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (ConversationListAdapter.this.mOnPortraitItemClick != null) {
                        ConversationListAdapter.this.mOnPortraitItemClick.onPortraitItemLongClick(v, data);
                    }
                    return true;
                }
            });
            if (data.getConversationGatherState()) {
                holder.rightImageView.setAvatar(null, defaultId);
            } else if (data.getIconUrl() != null) {
                holder.rightImageView.setAvatar(data.getIconUrl().toString(), defaultId);
            } else {
                holder.rightImageView.setAvatar(null, defaultId);
            }
            if (data.getUnReadMessageCount() > 0) {
                holder.unReadMsgCountRightIcon.setVisibility(0);
                this.setUnReadViewLayoutParams(holder.rightUnReadView, data.getUnReadType());
                if (data.getUnReadType().equals((Object)UIConversation.UnreadRemindType.REMIND_WITH_COUNTING)) {
                    holder.unReadMsgCount.setVisibility(0);
                    if (data.getUnReadMessageCount() > 99) {
                        holder.unReadMsgCountRight.setText((CharSequence)this.mContext.getResources().getString(R.string.rc_message_unread_count));
                    } else {
                        holder.unReadMsgCountRight.setText((CharSequence)Integer.toString(data.getUnReadMessageCount()));
                    }
                    holder.unReadMsgCountRightIcon.setImageResource(R.drawable.rc_unread_count_bg);
                } else {
                    holder.unReadMsgCount.setVisibility(8);
                    holder.unReadMsgCountRightIcon.setImageResource(R.drawable.rc_unread_remind_without_count);
                }
            } else {
                holder.unReadMsgCountIcon.setVisibility(8);
                holder.unReadMsgCount.setVisibility(8);
            }
            holder.leftImageLayout.setVisibility(8);
        } else if (tag.portraitPosition() == 3) {
            holder.rightImageLayout.setVisibility(8);
            holder.leftImageLayout.setVisibility(8);
        } else {
            throw new IllegalArgumentException("the portrait position is wrong!");
        }
        MessageContent content = data.getMessageContent();
        if (content != null && content.isDestruct()) {
            RongIMClient.getInstance().getMessage(data.getLatestMessageId(), (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<Message>(){

                public void onSuccess(Message message) {
                    if (message == null) {
                        EventBus.getDefault().post(new Event.MessageDeleteEvent(data.getLatestMessageId()));
                    } else if (message.getReadTime() > 0L) {
                        long readTime = message.getReadTime();
                        long serverTime = System.currentTimeMillis() - RongIMClient.getInstance().getDeltaTime();
                        long delay = message.getContent().getDestructTime() - (serverTime - readTime) / 1000L;
                        if (delay > 0L) {
                            RongIM.getInstance().createDestructionTask(message, null, ConversationListFragment.TAG);
                        } else {
                            EventBus.getDefault().post(new Event.DestructionEvent(message));
                        }
                    }
                }

                public void onError(RongIMClient.ErrorCode e) {
                }
            });
        }
    }

    protected void setUnReadViewLayoutParams(View view, UIConversation.UnreadRemindType type) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        Context context = view.getContext();
        if (type == UIConversation.UnreadRemindType.REMIND_WITH_COUNTING) {
            params.width = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_18);
            params.height = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_18);
            params.leftMargin = (int)this.mContext.getResources().getDimension(R.dimen.rc_dimen_size_44);
            params.topMargin = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_5);
        } else {
            params.width = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_9);
            params.height = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_9);
            params.leftMargin = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_50);
            params.topMargin = (int)context.getResources().getDimension(R.dimen.rc_dimen_size_7);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setOnPortraitItemClick(OnPortraitItemClick onPortraitItemClick) {
        this.mOnPortraitItemClick = onPortraitItemClick;
    }

    public static interface OnPortraitItemClick {
        public void onPortraitItemClick(View var1, UIConversation var2);

        public boolean onPortraitItemLongClick(View var1, UIConversation var2);
    }

    protected class ViewHolder {
        public View layout;
        public View leftImageLayout;
        public View rightImageLayout;
        public View leftUnReadView;
        public View rightUnReadView;
        public AsyncImageView leftImageView;
        public TextView unReadMsgCount;
        public ImageView unReadMsgCountIcon;
        public AsyncImageView rightImageView;
        public TextView unReadMsgCountRight;
        public ImageView unReadMsgCountRightIcon;
        public ProviderContainerView contentView;

        protected ViewHolder() {
        }
    }
}

