/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongConfigurationManager;
import io.rong.imkit.RongContext;
import io.rong.imkit.model.FileInfo;
import io.rong.imkit.utils.FileTypeUtils;
import java.util.HashSet;
import java.util.List;

public class FileListAdapter
extends BaseAdapter {
    private List<FileInfo> mFileList;
    private HashSet<FileInfo> mSelectedFiles;
    private Context mContext;

    public FileListAdapter(Context context, List<FileInfo> mFileList, HashSet<FileInfo> mSelectedFiles) {
        this.mFileList = mFileList;
        this.mContext = context;
        this.mSelectedFiles = mSelectedFiles;
    }

    public int getCount() {
        if (this.mFileList != null) {
            return this.mFileList.size();
        }
        return 0;
    }

    public Object getItem(int position) {
        if (this.mFileList == null) {
            return null;
        }
        if (position >= this.mFileList.size()) {
            return null;
        }
        return this.mFileList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.rc_wi_file_list_adapter, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.fileCheckStateImageView = (ImageView)view.findViewById(R.id.rc_wi_ad_iv_file_check_state);
        viewHolder.fileIconImageView = (ImageView)view.findViewById(R.id.rc_wi_ad_iv_file_icon);
        viewHolder.fileNameTextView = (TextView)view.findViewById(R.id.rc_wi_ad_tv_file_name);
        viewHolder.fileDetailsTextView = (TextView)view.findViewById(R.id.rc_wi_ad_tv_file_details);
        FileInfo file = this.mFileList.get(position);
        viewHolder.fileNameTextView.setText((CharSequence)file.getFileName());
        if (file.isDirectory()) {
            long filesNumber = file.getFileSize();
            if (filesNumber == 0L) {
                viewHolder.fileDetailsTextView.setText((CharSequence)RongContext.getInstance().getString(R.string.rc_ad_folder_no_files));
            } else {
                viewHolder.fileDetailsTextView.setText((CharSequence)RongContext.getInstance().getString(R.string.rc_ad_folder_files_number, new Object[]{filesNumber}));
            }
            viewHolder.fileIconImageView.setImageResource(FileTypeUtils.getFileIconResource(file));
        } else {
            if (this.mSelectedFiles.contains(file)) {
                viewHolder.fileCheckStateImageView.setImageResource(R.drawable.rc_ad_list_file_checked);
            } else {
                viewHolder.fileCheckStateImageView.setImageResource(R.drawable.rc_ad_list_file_unchecked);
            }
            viewHolder.fileDetailsTextView.setText((CharSequence)RongContext.getInstance().getString(R.string.rc_ad_file_size, new Object[]{FileTypeUtils.formatFileSize(file.getFileSize())}));
            viewHolder.fileIconImageView.setImageResource(FileTypeUtils.getFileIconResource(file));
            if (file.getFileSize() > (long)RongConfigurationManager.getInstance().getFileMaxSize(view.getContext()) * 1024L * 1024L) {
                view.setAlpha(0.4f);
            }
        }
        return view;
    }

    private class ViewHolder {
        ImageView fileCheckStateImageView;
        ImageView fileIconImageView;
        TextView fileNameTextView;
        TextView fileDetailsTextView;

        private ViewHolder() {
        }
    }
}

