/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.MessageProviderUserInfoHelper;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.DiscussionNotificationMessage;

@ProviderTag(messageContent=DiscussionNotificationMessage.class, showPortrait=false, centerInHorizontal=true, showSummaryWithName=false)
public class DiscussionNotificationMessageItemProvider
extends IContainerItemProvider.MessageProvider<DiscussionNotificationMessage> {
    private static final String TAG = "DiscussionNotificationMessageItemProvider";
    private static final int DISCUSSION_ADD_MEMBER = 1;
    private static final int DISCUSSION_EXIT = 2;
    private static final int DISCUSSION_RENAME = 3;
    private static final int DISCUSSION_REMOVE = 4;
    private static final int DISCUSSION_MEMBER_INVITE = 5;

    public DiscussionNotificationMessageItemProvider() {
        RongContext.getInstance().getEventBus().register(this);
    }

    @Override
    public void bindView(View v, int position, DiscussionNotificationMessage content, UIMessage message) {
        ViewHolder viewHolder = (ViewHolder)v.getTag();
        Spannable spannable = this.getContentSummary(v.getContext(), content);
        if (spannable != null && spannable.length() > 0) {
            viewHolder.contentTextView.setVisibility(0);
            viewHolder.contentTextView.setText((CharSequence)spannable);
        } else {
            viewHolder.contentTextView.setVisibility(8);
        }
    }

    @Override
    public Spannable getContentSummary(DiscussionNotificationMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, DiscussionNotificationMessage data) {
        if (data == null) {
            RLog.e((String)TAG, (String)"getContentSummary DiscussionNotificationMessage is null;");
            return new SpannableString((CharSequence)"");
        }
        RLog.i((String)TAG, (String)"getContentSummary call getContentSummary()  method ");
        return new SpannableString((CharSequence)this.getWrapContent((Context)RongContext.getInstance(), data));
    }

    @Override
    public void onItemClick(View view, int position, DiscussionNotificationMessage content, UIMessage message) {
    }

    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_discussion_notification_message, null);
        ViewHolder viewHolder = new ViewHolder();
        viewHolder.contentTextView = (TextView)view.findViewById(R.id.rc_msg);
        viewHolder.contentTextView.setMovementMethod(LinkMovementMethod.getInstance());
        view.setTag((Object)viewHolder);
        return view;
    }

    private final String getWrapContent(Context context, DiscussionNotificationMessage discussionNotificationMessage) {
        if (discussionNotificationMessage == null) {
            return "";
        }
        String[] operatedUserIds = null;
        String extension = discussionNotificationMessage.getExtension();
        String operatorId = discussionNotificationMessage.getOperator();
        String currentUserId = "";
        String content = "";
        int operatedUserIdsLength = 0;
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            operatedUserIds = extension.indexOf(",") != -1 ? extension.split(",") : new String[]{extension};
            operatedUserIdsLength = operatedUserIds.length;
        }
        if (TextUtils.isEmpty((CharSequence)(currentUserId = RongIM.getInstance().getCurrentUserId()))) {
            return "";
        }
        int operatorType = discussionNotificationMessage.getType();
        switch (operatorType) {
            case 1: {
                if (operatedUserIds == null) break;
                if (currentUserId.equals(operatorId)) {
                    if (operatedUserIdsLength == 1) {
                        String userId = operatedUserIds[0];
                        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(userId);
                        if (userInfo != null) {
                            String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you_added);
                            content = String.format(formatString, userInfo.getName());
                            break;
                        }
                        MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, userId);
                        break;
                    }
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you_add);
                    content = String.format(formatString, operatedUserIdsLength);
                    break;
                }
                if (operatedUserIdsLength == 1) {
                    String userId = operatedUserIds[0];
                    UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(userId);
                    UserInfo operator = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                    if (userInfo != null && operator != null) {
                        String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_added);
                        content = String.format(formatString, operator.getName(), userInfo.getName());
                        break;
                    }
                    if (userInfo == null) {
                        MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, userId);
                    }
                    if (operator != null) break;
                    MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                    break;
                }
                UserInfo operator = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                if (operator != null) {
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_add);
                    content = String.format(formatString, operator.getName(), operatedUserIdsLength);
                    break;
                }
                MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                break;
            }
            case 2: {
                UserInfo operator = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                if (operator != null) {
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_exit);
                    content = String.format(formatString, operator.getName());
                    break;
                }
                MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                break;
            }
            case 3: {
                if (currentUserId.equals(operatorId)) {
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you_rename);
                    content = String.format(formatString, extension);
                    break;
                }
                UserInfo operatorUserInfo = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                if (operatorUserInfo != null) {
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_rename);
                    content = String.format(formatString, operatorUserInfo.getName(), extension);
                    break;
                }
                MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                break;
            }
            case 4: {
                String operatedUserId = operatedUserIds[0];
                if (currentUserId.equals(operatorId)) {
                    UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(operatedUserId);
                    if (userInfo != null) {
                        String you = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you);
                        String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_who_removed);
                        content = String.format(formatString, userInfo.getName(), you);
                        break;
                    }
                    MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                    break;
                }
                if (currentUserId.equals(operatedUserId)) {
                    UserInfo operatorUserInfo = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                    if (operatorUserInfo != null) {
                        String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_removed);
                        content = String.format(formatString, operatorUserInfo.getName());
                        break;
                    }
                    MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                    break;
                }
                UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(operatedUserId);
                UserInfo operatorUserInfo = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                if (userInfo != null && operatorUserInfo != null) {
                    String formatString = context.getResources().getString(R.string.rc_discussion_nt_msg_for_who_removed);
                    content = String.format(formatString, userInfo.getName(), operatorUserInfo.getName());
                    break;
                }
                if (operatorUserInfo == null) {
                    MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                }
                if (userInfo != null) break;
                MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatedUserId);
                break;
            }
            case 5: {
                if (currentUserId.equals(operatorId)) {
                    if ("1".equals(extension)) {
                        String closeFormat = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you_is_open_invite_close);
                        content = String.format(closeFormat, new Object[0]);
                        break;
                    }
                    if (!"0".equals(extension)) break;
                    String openFormat = context.getResources().getString(R.string.rc_discussion_nt_msg_for_you_is_open_invite_open);
                    content = String.format(openFormat, new Object[0]);
                    break;
                }
                UserInfo operatorUserInfo = RongUserInfoManager.getInstance().getUserInfo(operatorId);
                if (operatorUserInfo != null) {
                    if ("1".equals(extension)) {
                        String closeFormat = context.getResources().getString(R.string.rc_discussion_nt_msg_for_is_open_invite_close);
                        content = String.format(closeFormat, operatorUserInfo.getName());
                        break;
                    }
                    if (!"0".equals(extension)) break;
                    String openFormat = context.getResources().getString(R.string.rc_discussion_nt_msg_for_is_open_invite_open);
                    content = String.format(openFormat, operatorUserInfo.getName());
                    break;
                }
                MessageProviderUserInfoHelper.getInstance().registerMessageUserInfo((MessageContent)discussionNotificationMessage, operatorId);
                break;
            }
            default: {
                content = "";
            }
        }
        RLog.i((String)TAG, (String)("content return " + content));
        return content;
    }

    public void onEventMainThread(UserInfo userInfo) {
        if (userInfo.getName() == null) {
            return;
        }
        if (MessageProviderUserInfoHelper.getInstance().isCacheUserId(userInfo.getUserId())) {
            MessageProviderUserInfoHelper.getInstance().notifyMessageUpdate(userInfo.getUserId());
        }
    }

    private static class ViewHolder {
        TextView contentTextView;

        private ViewHolder() {
        }
    }
}

