/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.RongIM;
import io.rong.imkit.activity.FileManagerActivity;
import io.rong.imkit.model.FileInfo;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.FileMessage;
import java.util.HashSet;

public class FilePlugin
implements IPluginModule,
IPluginRequestPermissionResultCallback {
    private static final String TAG = "FileInputProvider";
    private static final int REQUEST_FILE = 100;
    private Conversation.ConversationType conversationType;
    private String targetId;

    @Override
    public Drawable obtainDrawable(Context context) {
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ic_files_selector);
    }

    @Override
    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugins_files);
    }

    @Override
    public void onClick(Fragment currentFragment, RongExtension extension) {
        this.conversationType = extension.getConversationType();
        this.targetId = extension.getTargetId();
        String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        if (PermissionCheckUtil.checkPermissions(currentFragment.getContext(), permissions)) {
            Intent intent = new Intent((Context)currentFragment.getActivity(), FileManagerActivity.class);
            extension.startActivityForPluginResult(intent, 100, this);
        } else {
            extension.requestPermissionForPluginResult(permissions, 255, this);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100 && data != null) {
            HashSet selectedFileInfos = (HashSet)data.getSerializableExtra("sendSelectedFiles");
            for (FileInfo fileInfo : selectedFileInfos) {
                Uri filePath = Uri.parse((String)("file://" + fileInfo.getFilePath()));
                FileMessage fileMessage = FileMessage.obtain((Uri)filePath);
                if (fileMessage == null) continue;
                fileMessage.setType(fileInfo.getSuffix());
                Message message = Message.obtain((String)this.targetId, (Conversation.ConversationType)this.conversationType, (MessageContent)fileMessage);
                RongIM.getInstance().sendMediaMessage(message, null, null, (IRongCallback.ISendMediaMessageCallback)null);
            }
        }
    }

    @Override
    public boolean onRequestPermissionResult(Fragment currentFragment, RongExtension extension, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionCheckUtil.checkPermissions((Context)currentFragment.getActivity(), permissions)) {
            Intent intent = new Intent((Context)currentFragment.getActivity(), FileManagerActivity.class);
            extension.startActivityForPluginResult(intent, 100, this);
        } else {
            extension.showRequestPermissionFailedAlter(PermissionCheckUtil.getNotGrantedPermissionMsg((Context)currentFragment.getActivity(), permissions, grantResults));
        }
        return true;
    }
}

