/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.model.ConversationProviderTag;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.RongDateUtils;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.UserInfo;
import io.rong.message.RecallNotificationMessage;

@ConversationProviderTag(conversationType="private", portraitPosition=1)
public class PrivateConversationProvider
implements IContainerItemProvider.ConversationProvider<UIConversation> {
    private static final String TAG = "PrivateConversationProvider";

    @Override
    public View newView(Context context, ViewGroup viewGroup) {
        View result = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_base_conversation, null);
        ViewHolder holder = new ViewHolder();
        holder.title = (TextView)result.findViewById(R.id.rc_conversation_title);
        holder.time = (TextView)result.findViewById(R.id.rc_conversation_time);
        holder.content = (TextView)result.findViewById(R.id.rc_conversation_content);
        holder.notificationBlockImage = (ImageView)result.findViewById(R.id.rc_conversation_msg_block);
        holder.readStatus = (ImageView)result.findViewById(R.id.rc_conversation_status);
        result.setTag((Object)holder);
        return result;
    }

    private void handleMentionedContent(final ViewHolder holder, final View view, final UIConversation data) {
        int empirical_value = 60;
        final SpannableStringBuilder builder = new SpannableStringBuilder();
        final String preStr = view.getContext().getString(R.string.rc_message_content_mentioned);
        if (holder.content.getWidth() > 60) {
            CharSequence cutStr = TextUtils.ellipsize((CharSequence)(preStr + " " + data.getConversationContent()), (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 60), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            SpannableString string2 = new SpannableString(cutStr);
            string2.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_mentioned_color)), 0, preStr.length(), 33);
            builder.append((CharSequence)string2);
            AndroidEmoji.ensure((Spannable)builder);
            holder.content.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
        } else {
            holder.content.post(new Runnable(){

                @Override
                public void run() {
                    if (holder.content.getWidth() > 60) {
                        CharSequence cutStr = TextUtils.ellipsize((CharSequence)(preStr + " " + data.getConversationContent()), (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 40), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                        SpannableString str = new SpannableString(cutStr);
                        str.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_mentioned_color)), 0, preStr.length(), 33);
                        builder.append((CharSequence)str);
                    } else {
                        SpannableString str = new SpannableString((CharSequence)(preStr + " " + data.getConversationContent()));
                        str.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_mentioned_color)), 0, preStr.length(), 33);
                        builder.append((CharSequence)str);
                    }
                    AndroidEmoji.ensure((Spannable)builder);
                    holder.content.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
                }
            });
        }
    }

    private void handleDraftContent(final ViewHolder holder, final View view, final UIConversation data) {
        int empirical_value = 60;
        final SpannableStringBuilder builder = new SpannableStringBuilder();
        final String preStr = view.getContext().getString(R.string.rc_message_content_draft);
        if (holder.content.getWidth() > 60) {
            CharSequence cutStr = TextUtils.ellipsize((CharSequence)(preStr + " " + data.getDraft()), (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 60), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            SpannableString string2 = new SpannableString(cutStr);
            string2.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_draft_color)), 0, preStr.length(), 33);
            builder.append((CharSequence)string2);
            AndroidEmoji.ensure((Spannable)builder);
            holder.content.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
        } else {
            holder.content.post(new Runnable(){

                @Override
                public void run() {
                    if (holder.content.getWidth() > 60) {
                        CharSequence cutStr = TextUtils.ellipsize((CharSequence)(preStr + " " + data.getDraft()), (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 60), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                        SpannableString str = new SpannableString(cutStr);
                        str.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_draft_color)), 0, preStr.length(), 33);
                        builder.append((CharSequence)str);
                    } else {
                        SpannableString str = new SpannableString((CharSequence)(preStr + " " + data.getDraft()));
                        str.setSpan((Object)new ForegroundColorSpan(view.getContext().getResources().getColor(R.color.rc_draft_color)), 0, preStr.length(), 33);
                        builder.append((CharSequence)str);
                    }
                    AndroidEmoji.ensure((Spannable)builder);
                    holder.content.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
                }
            });
        }
    }

    private void handleCommonContent(final ViewHolder holder, UIConversation data) {
        int empirical_value = 60;
        if (holder.content.getWidth() > 60 && data.getConversationContent() != null) {
            CharSequence cutStr = TextUtils.ellipsize((CharSequence)data.getConversationContent(), (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 60), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            holder.content.setText(cutStr, TextView.BufferType.SPANNABLE);
        } else {
            Spannable cutStr = data.getConversationContent();
            holder.content.post(new Runnable((CharSequence)cutStr){
                final /* synthetic */ CharSequence val$cutStr;
                {
                    this.val$cutStr = charSequence;
                }

                @Override
                public void run() {
                    if (holder.content.getWidth() > 60 && this.val$cutStr != null) {
                        CharSequence str = TextUtils.ellipsize((CharSequence)this.val$cutStr, (TextPaint)holder.content.getPaint(), (float)(holder.content.getWidth() - 60), (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                        holder.content.setText(str, TextView.BufferType.SPANNABLE);
                    } else {
                        holder.content.setText(this.val$cutStr);
                    }
                }
            });
        }
    }

    @Override
    public void bindView(View view, int position, UIConversation data) {
        ViewHolder holder = (ViewHolder)view.getTag();
        ProviderTag tag = null;
        if (data == null) {
            holder.title.setText(null);
            holder.time.setText(null);
            holder.content.setText(null);
        } else {
            holder.title.setText((CharSequence)data.getUIConversationTitle());
            String time = RongDateUtils.getConversationListFormatDate(data.getUIConversationTime(), view.getContext());
            holder.time.setText((CharSequence)time);
            if (!TextUtils.isEmpty((CharSequence)data.getDraft()) || data.getMentionedFlag()) {
                if (data.getMentionedFlag()) {
                    this.handleMentionedContent(holder, view, data);
                } else {
                    this.handleDraftContent(holder, view, data);
                }
                holder.readStatus.setVisibility(8);
            } else {
                boolean readRec = false;
                try {
                    readRec = view.getResources().getBoolean(R.bool.rc_read_receipt);
                }
                catch (Resources.NotFoundException e) {
                    RLog.e((String)TAG, (String)"rc_read_receipt not configure in rc_config.xml");
                    e.printStackTrace();
                }
                if (readRec) {
                    if (data.getSentStatus() == Message.SentStatus.READ && data.getConversationSenderId().equals(RongIM.getInstance().getCurrentUserId()) && !(data.getMessageContent() instanceof RecallNotificationMessage)) {
                        holder.readStatus.setVisibility(0);
                    } else {
                        holder.readStatus.setVisibility(8);
                    }
                }
                this.handleCommonContent(holder, data);
            }
            if (RongContext.getInstance() != null && data.getMessageContent() != null) {
                tag = RongContext.getInstance().getMessageProviderTag(data.getMessageContent().getClass());
            }
            if (data.getSentStatus() != null && (data.getSentStatus() == Message.SentStatus.FAILED || data.getSentStatus() == Message.SentStatus.SENDING) && tag != null && tag.showWarning() && data.getConversationSenderId() != null && data.getConversationSenderId().equals(RongIM.getInstance().getCurrentUserId())) {
                Bitmap bitmap = BitmapFactory.decodeResource((Resources)view.getResources(), (int)R.drawable.rc_conversation_list_msg_send_failure);
                int width = bitmap.getWidth();
                Drawable drawable2 = null;
                if (data.getSentStatus() == Message.SentStatus.FAILED && TextUtils.isEmpty((CharSequence)data.getDraft())) {
                    drawable2 = view.getContext().getResources().getDrawable(R.drawable.rc_conversation_list_msg_send_failure);
                } else if (data.getSentStatus() == Message.SentStatus.SENDING && TextUtils.isEmpty((CharSequence)data.getDraft())) {
                    drawable2 = view.getContext().getResources().getDrawable(R.drawable.rc_conversation_list_msg_sending);
                }
                if (drawable2 != null) {
                    drawable2.setBounds(0, 0, width, width);
                    holder.content.setCompoundDrawablePadding(10);
                    holder.content.setCompoundDrawables(drawable2, null, null, null);
                }
            } else {
                holder.content.setCompoundDrawables(null, null, null, null);
            }
            Conversation.ConversationNotificationStatus status = data.getNotificationStatus();
            if (status != null && status.equals((Object)Conversation.ConversationNotificationStatus.DO_NOT_DISTURB)) {
                holder.notificationBlockImage.setVisibility(0);
            } else {
                holder.notificationBlockImage.setVisibility(8);
            }
        }
    }

    public Spannable getSummary(UIConversation data) {
        return null;
    }

    @Override
    public String getTitle(String userId) {
        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(userId);
        return userInfo == null ? userId : userInfo.getName();
    }

    @Override
    public Uri getPortraitUri(String userId) {
        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(userId);
        return userInfo == null ? null : userInfo.getPortraitUri();
    }

    protected class ViewHolder {
        public TextView title;
        public TextView time;
        public TextView content;
        public ImageView notificationBlockImage;
        public ImageView readStatus;

        protected ViewHolder() {
        }
    }
}

