/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.message.PublicServiceMultiRichContentMessage;
import io.rong.message.RichContentItem;
import java.util.ArrayList;

@ProviderTag(messageContent=PublicServiceMultiRichContentMessage.class, showPortrait=false, centerInHorizontal=true, showSummaryWithName=false)
public class PublicServiceMultiRichContentMessageProvider
extends IContainerItemProvider.MessageProvider<PublicServiceMultiRichContentMessage> {
    @Override
    public void bindView(final View v, int position, PublicServiceMultiRichContentMessage content, UIMessage message) {
        ViewHolder vh = (ViewHolder)v.getTag();
        final ArrayList msgList = content.getMessages();
        if (msgList.size() > 0) {
            vh.tv.setText((CharSequence)((RichContentItem)msgList.get(0)).getTitle());
            vh.iv.setResource(((RichContentItem)msgList.get(0)).getImageUrl(), 0);
        }
        int height = 0;
        ViewGroup.LayoutParams params = v.getLayoutParams();
        PublicAccountMsgAdapter mAdapter = new PublicAccountMsgAdapter(v.getContext(), msgList);
        vh.lv.setAdapter((ListAdapter)mAdapter);
        vh.lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                RichContentItem item = (RichContentItem)msgList.get(position + 1);
                String url = item.getUrl();
                String action = "io.rong.imkit.intent.action.webview";
                Intent intent = new Intent(action);
                intent.setPackage(v.getContext().getPackageName());
                intent.putExtra("url", url);
                v.getContext().startActivity(intent);
            }
        });
        params.height = height = this.getListViewHeight(vh.lv) + vh.height;
        params.width = RongUtils.getScreenWidth() - RongUtils.dip2px(32.0f);
        v.setLayoutParams(params);
        v.requestLayout();
    }

    private int getListViewHeight(ListView list) {
        int totalHeight = 0;
        ListAdapter adapter = list.getAdapter();
        for (int i = 0; i < adapter.getCount(); ++i) {
            View item = adapter.getView(i, null, (ViewGroup)list);
            totalHeight += item.getLayoutParams().height;
        }
        return totalHeight;
    }

    @Override
    public Spannable getContentSummary(PublicServiceMultiRichContentMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, PublicServiceMultiRichContentMessage data) {
        ArrayList list = data.getMessages();
        if (list.size() > 0) {
            return new SpannableString((CharSequence)((RichContentItem)data.getMessages().get(0)).getTitle());
        }
        return null;
    }

    @Override
    public void onItemClick(View view, int position, PublicServiceMultiRichContentMessage content, UIMessage message) {
        if (content.getMessages().size() == 0) {
            return;
        }
        String url = ((RichContentItem)content.getMessages().get(0)).getUrl();
        String action = "io.rong.imkit.intent.action.webview";
        Context context = view.getContext();
        Intent intent = new Intent(action);
        intent.setPackage(context.getPackageName());
        intent.putExtra("url", url);
        context.startActivity(intent);
    }

    @Override
    public View newView(Context context, ViewGroup group) {
        ViewHolder holder = new ViewHolder();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_item_public_service_multi_rich_content_message, null);
        holder.lv = (ListView)view.findViewById(R.id.rc_list);
        holder.iv = (AsyncImageView)view.findViewById(R.id.rc_img);
        holder.tv = (TextView)view.findViewById(R.id.rc_txt);
        view.measure(0, 0);
        holder.height = view.getMeasuredHeight();
        view.setTag((Object)holder);
        return view;
    }

    private static class PublicAccountMsgAdapter
    extends BaseAdapter {
        LayoutInflater inflater;
        ArrayList<RichContentItem> itemList;
        int itemCount;

        public PublicAccountMsgAdapter(Context context, ArrayList<RichContentItem> msgList) {
            this.inflater = LayoutInflater.from((Context)context);
            this.itemList = new ArrayList();
            this.itemList.addAll(msgList);
            this.itemCount = msgList.size() - 1;
        }

        public int getCount() {
            return this.itemCount;
        }

        public RichContentItem getItem(int position) {
            if (this.itemList.size() == 0) {
                return null;
            }
            return this.itemList.get(position + 1);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            convertView = this.inflater.inflate(R.layout.rc_item_public_service_message, parent, false);
            AsyncImageView iv = (AsyncImageView)convertView.findViewById(R.id.rc_img);
            TextView tv = (TextView)convertView.findViewById(R.id.rc_txt);
            View divider = convertView.findViewById(R.id.rc_divider);
            if (this.itemList.size() == 0) {
                return null;
            }
            String title = this.itemList.get(position + 1).getTitle();
            if (title != null) {
                tv.setText((CharSequence)title);
            }
            iv.setResource(this.itemList.get(position + 1).getImageUrl(), 0);
            if (position == this.getCount() - 1) {
                divider.setVisibility(8);
            } else {
                divider.setVisibility(0);
            }
            return convertView;
        }
    }

    protected static class ViewHolder {
        public int height;
        public TextView tv;
        public AsyncImageView iv;
        public View divider;
        public ListView lv;

        protected ViewHolder() {
        }
    }
}

