/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.widget.provider;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.ProviderTag;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.plugin.location.AMapRealTimeActivity;
import io.rong.imkit.plugin.location.AMapRealTimeActivity2D;
import io.rong.imkit.plugin.location.LocationManager;
import io.rong.imkit.plugin.location.LocationManager2D;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.utilities.PromptPopupDialog;
import io.rong.imkit.widget.provider.IContainerItemProvider;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.location.message.RealTimeLocationStartMessage;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.List;

@ProviderTag(messageContent=RealTimeLocationStartMessage.class)
public class RealTimeLocationMessageProvider
extends IContainerItemProvider.MessageProvider<RealTimeLocationStartMessage> {
    @Override
    public View newView(Context context, ViewGroup group) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_share_location_message, null);
        ViewHolder holder = new ViewHolder();
        holder.message = (TextView)view.findViewById(16908308);
        view.setTag((Object)holder);
        return view;
    }

    @Override
    public Spannable getContentSummary(RealTimeLocationStartMessage data) {
        return null;
    }

    @Override
    public Spannable getContentSummary(Context context, RealTimeLocationStartMessage data) {
        if (data != null && data.getContent() != null) {
            return new SpannableString((CharSequence)context.getResources().getString(R.string.rc_real_time_location_summary));
        }
        return null;
    }

    @Override
    public void onItemClick(final View view, int position, RealTimeLocationStartMessage content, final UIMessage message) {
        if (message.getMessageDirection() == Message.MessageDirection.SEND) {
            this.joinMap(view, message);
        } else {
            PromptPopupDialog dialog = PromptPopupDialog.newInstance(view.getContext(), "", view.getContext().getResources().getString(R.string.rc_real_time_join_notification));
            dialog.setPromptButtonClickedListener(new PromptPopupDialog.OnPromptButtonClickedListener(){

                @Override
                public void onPositiveButtonClicked() {
                    RealTimeLocationMessageProvider.this.joinMap(view, message);
                }
            });
            dialog.show();
        }
    }

    private void joinMap(View view, UIMessage message) {
        List mLocationShareParticipants = RongIMClient.getInstance().getRealTimeLocationParticipants(message.getConversationType(), message.getTargetId());
        int result = RongContext.getInstance().getResources().getBoolean(R.bool.rc_location_2D) ? LocationManager2D.getInstance().joinLocationSharing() : LocationManager.getInstance().joinLocationSharing();
        if (result == 0) {
            Intent intent = RongContext.getInstance().getResources().getBoolean(R.bool.rc_location_2D) ? new Intent(view.getContext(), AMapRealTimeActivity2D.class) : new Intent(view.getContext(), AMapRealTimeActivity.class);
            if (mLocationShareParticipants != null) {
                intent.putStringArrayListExtra("participants", (ArrayList)mLocationShareParticipants);
            }
            view.getContext().startActivity(intent);
        } else if (result == 1) {
            Toast.makeText((Context)view.getContext(), (int)R.string.rc_network_exception, (int)0).show();
        } else if (result == 2) {
            Toast.makeText((Context)view.getContext(), (int)R.string.rc_location_sharing_exceed_max, (int)0).show();
        }
    }

    @Override
    public void onItemLongClick(View view, int position, RealTimeLocationStartMessage content, final UIMessage message) {
        CharSequence text;
        ViewHolder holder = (ViewHolder)view.getTag();
        holder.longClick = true;
        if (view instanceof TextView && (text = ((TextView)view).getText()) != null && text instanceof Spannable) {
            Selection.removeSelection((Spannable)((Spannable)text));
        }
        Resources res = view.getContext().getResources();
        String[] items = new String[]{res.getString(R.string.rc_dialog_item_message_delete)};
        OptionsPopupDialog.newInstance(view.getContext(), items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

            @Override
            public void onOptionsItemClicked(int which) {
                if (which == 0) {
                    RongIM.getInstance().deleteMessages(new int[]{message.getMessageId()}, null);
                }
            }
        }).show();
    }

    @Override
    public void bindView(View v, int position, RealTimeLocationStartMessage content, UIMessage data) {
        ViewHolder holder = (ViewHolder)v.getTag();
        if (data.getMessageDirection() == Message.MessageDirection.SEND) {
            Drawable drawable2 = holder.message.getResources().getDrawable(R.drawable.rc_icon_rt_message_right);
            drawable2.setBounds(0, 0, 29, 41);
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_right);
            holder.message.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
            holder.message.setText((CharSequence)RongContext.getInstance().getResources().getString(R.string.rc_real_time_location_sharing));
        } else {
            Drawable drawable3 = holder.message.getResources().getDrawable(R.drawable.rc_icon_rt_message_left);
            drawable3.setBounds(0, 0, 29, 41);
            holder.message.setBackgroundResource(R.drawable.rc_ic_bubble_left);
            holder.message.setCompoundDrawablesWithIntrinsicBounds(drawable3, null, null, null);
            holder.message.setText((CharSequence)RongContext.getInstance().getResources().getString(R.string.rc_real_time_location_sharing));
        }
    }

    private static class ViewHolder {
        TextView message;
        boolean longClick;

        private ViewHolder() {
        }
    }
}

